/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.settings.VersionCatalogModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleDslModelExperimentalSettings;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.DependencyManager;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFileCache;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.AndroidGradlePluginVersion;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.android.tools.idea.gradle.dsl.utils.BuildScriptUtil;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class BuildModelContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslFileCache myFileCache;
    @NotNull
    private final ResolvedConfigurationFileLocationProvider myResolvedConfigurationFileLocationProvider;
    @NotNull
    private final Map<GradleDslFile, ClassToInstanceMap<BuildModelNotification>> myNotifications;
    @NotNull
    private final DependencyManager myDependencyManager;
    @Nullable
    private GradleBuildFile myRootProjectFile;
    @Nullable
    private AndroidGradlePluginVersion agpVersion;
    @NotNull
    private final Set<GradleVersionCatalogFile> myVersionCatalogFiles;

    public void setRootProjectFile(@NotNull GradleBuildFile rootProjectFile) {
        if (rootProjectFile == null) {
            BuildModelContext.$$$reportNull$$$0(0);
        }
        this.myRootProjectFile = rootProjectFile;
    }

    @Nullable
    public GradleBuildFile getRootProjectFile() {
        return this.myRootProjectFile;
    }

    public void setAgpVersion(@Nullable AndroidGradlePluginVersion agpVersion) {
        this.agpVersion = agpVersion;
    }

    @Nullable
    public AndroidGradlePluginVersion getAgpVersion() {
        return this.agpVersion;
    }

    @NotNull
    public static BuildModelContext create(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(1);
        }
        if (resolvedConfigurationFileLocationProvider == null) {
            BuildModelContext.$$$reportNull$$$0(2);
        }
        return new BuildModelContext(project, resolvedConfigurationFileLocationProvider);
    }

    private BuildModelContext(@NotNull Project project, @NotNull ResolvedConfigurationFileLocationProvider resolvedConfigurationFileLocationProvider) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(3);
        }
        if (resolvedConfigurationFileLocationProvider == null) {
            BuildModelContext.$$$reportNull$$$0(4);
        }
        this.myNotifications = new HashMap<GradleDslFile, ClassToInstanceMap<BuildModelNotification>>();
        this.myVersionCatalogFiles = new LinkedHashSet<GradleVersionCatalogFile>();
        this.myProject = project;
        this.myFileCache = new GradleDslFileCache(project);
        this.myResolvedConfigurationFileLocationProvider = resolvedConfigurationFileLocationProvider;
        this.myDependencyManager = DependencyManager.create();
        this.myRootProjectFile = null;
    }

    @NotNull
    public DependencyManager getDependencyManager() {
        DependencyManager dependencyManager = this.myDependencyManager;
        if (dependencyManager == null) {
            BuildModelContext.$$$reportNull$$$0(5);
        }
        return dependencyManager;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications(@NotNull GradleDslFile file) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(7);
        }
        return new ArrayList<BuildModelNotification>(this.myNotifications.getOrDefault(file, (ClassToInstanceMap<BuildModelNotification>)MutableClassToInstanceMap.create()).values());
    }

    @NotNull
    public <T extends BuildModelNotification> T getNotificationForType(@NotNull GradleDslFile file, @NotNull NotificationTypeReference<T> type) {
        ClassToInstanceMap notificationMap;
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(8);
        }
        if (type == null) {
            BuildModelContext.$$$reportNull$$$0(9);
        }
        if ((notificationMap = this.myNotifications.computeIfAbsent(file, f -> MutableClassToInstanceMap.create())).containsKey(type.getClazz())) {
            BuildModelNotification buildModelNotification = (BuildModelNotification)notificationMap.getInstance(type.getClazz());
            if (buildModelNotification == null) {
                BuildModelContext.$$$reportNull$$$0(10);
            }
            return (T)buildModelNotification;
        }
        BuildModelNotification notification = (BuildModelNotification)type.getConstructor().produce();
        notificationMap.putInstance(type.getClazz(), (Object)notification);
        BuildModelNotification buildModelNotification = notification;
        if (buildModelNotification == null) {
            BuildModelContext.$$$reportNull$$$0(11);
        }
        return (T)buildModelNotification;
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myFileCache.getCurrentParsingRoot();
    }

    public void reset() {
        this.myFileCache.clearAllFiles();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name2, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(12);
        }
        if (name2 == null) {
            BuildModelContext.$$$reportNull$$$0(13);
        }
        GradleBuildFile gradleBuildFile = this.myFileCache.getOrCreateBuildFile(file, name2, this, isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(14);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, boolean isApplied) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(15);
        }
        GradleBuildFile gradleBuildFile = this.getOrCreateBuildFile(file, file.getName(), isApplied);
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(16);
        }
        return gradleBuildFile;
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile) {
        if (settingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(17);
        }
        GradleSettingsFile gradleSettingsFile = this.myFileCache.getOrCreateSettingsFile(settingsFile, this);
        if (gradleSettingsFile == null) {
            BuildModelContext.$$$reportNull$$$0(18);
        }
        return gradleSettingsFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(19);
        }
        if (moduleName == null) {
            BuildModelContext.$$$reportNull$$$0(20);
        }
        return this.myFileCache.getOrCreatePropertiesFile(file, moduleName, this);
    }

    @NotNull
    public GradleVersionCatalogFile getOrCreateVersionCatalogFile(@NotNull VirtualFile file, @NotNull String catalogName) {
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(21);
        }
        if (catalogName == null) {
            BuildModelContext.$$$reportNull$$$0(22);
        }
        GradleVersionCatalogFile gradleVersionCatalogFile = this.myFileCache.getOrCreateVersionCatalogFile(file, catalogName, this);
        if (gradleVersionCatalogFile == null) {
            BuildModelContext.$$$reportNull$$$0(23);
        }
        return gradleVersionCatalogFile;
    }

    @NotNull
    public GradleBuildFile parseBuildFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull String moduleName, boolean isApplied) {
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(24);
        }
        if (file == null) {
            BuildModelContext.$$$reportNull$$$0(25);
        }
        if (moduleName == null) {
            BuildModelContext.$$$reportNull$$$0(26);
        }
        GradleBuildFile buildDslFile = new GradleBuildFile(file, project, moduleName, this);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                GradleSettingsModel gradleSettingsModel = this.getSettingsModel(buildDslFile);
                this.populateWithParentModuleSubProjectsProperties(buildDslFile, gradleSettingsModel);
            }
            this.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        GradleBuildFile gradleBuildFile = buildDslFile;
        if (gradleBuildFile == null) {
            BuildModelContext.$$$reportNull$$$0(27);
        }
        return gradleBuildFile;
    }

    @Nullable
    public GradleBuildFile initializeContext(@NotNull Project project, @Nullable VirtualFile file) {
        GradleBuildFile result;
        if (project == null) {
            BuildModelContext.$$$reportNull$$$0(28);
        }
        GradleBuildFile gradleBuildFile = result = file != null ? new GradleBuildFile(file, project, ":", this) : null;
        if (result != null) {
            this.setRootProjectFile(result);
            ApplicationManager.getApplication().runReadAction(() -> {
                GradleSettingsModel gradleSettingsModel = this.getSettingsModel(result);
                this.populateWithParentModuleSubProjectsProperties(result, gradleSettingsModel);
                this.populateSiblingDslFileWithGradlePropertiesFile(result);
                this.populateVersionCatalogFiles(gradleSettingsModel);
                result.parse();
            });
            this.putBuildFile(file.getUrl(), result);
        } else {
            ApplicationManager.getApplication().runReadAction(() -> {
                VirtualFile maybeSettingsFile = this.getProjectSettingsFile();
                if (maybeSettingsFile != null) {
                    GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
                    this.populateVersionCatalogFiles(new GradleSettingsModelImpl(settingsFile));
                }
            });
        }
        return result;
    }

    private void putBuildFile(@NotNull String name2, @NotNull GradleBuildFile buildFile) {
        if (name2 == null) {
            BuildModelContext.$$$reportNull$$$0(29);
        }
        if (buildFile == null) {
            BuildModelContext.$$$reportNull$$$0(30);
        }
        this.myFileCache.putBuildFile(name2, buildFile);
    }

    @NotNull
    public List<GradleDslFile> getAllRequestedFiles() {
        List<GradleDslFile> list = this.myFileCache.getAllFiles();
        if (list == null) {
            BuildModelContext.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public Set<GradleVersionCatalogFile> getVersionCatalogFiles() {
        Set<GradleVersionCatalogFile> set = this.myVersionCatalogFiles;
        if (set == null) {
            BuildModelContext.$$$reportNull$$$0(32);
        }
        return set;
    }

    private void populateVersionCatalogFiles(@Nullable GradleSettingsModel gradleSettingsModel) {
        if (!GradleDslModelExperimentalSettings.getInstance().isVersionCatalogEnabled()) {
            return;
        }
        if (gradleSettingsModel == null) {
            this.checkVersionCatalog("gradle/libs.versions.toml", "libs").ifPresent(this.myVersionCatalogFiles::add);
            return;
        }
        for (VersionCatalogModel versionCatalogModel : gradleSettingsModel.dependencyResolutionManagement().versionCatalogs()) {
            String from2 = versionCatalogModel.from().getValue(GradlePropertyModel.STRING_TYPE);
            if (from2 == null) continue;
            this.checkVersionCatalog(from2, versionCatalogModel.getName()).ifPresent(this.myVersionCatalogFiles::add);
        }
    }

    private Optional<GradleVersionCatalogFile> checkVersionCatalog(String filePath, String name2) {
        @SystemIndependent String fromPath = FileUtilRt.toSystemIndependentName((String)filePath);
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        @SystemIndependent String path = String.join((CharSequence)"/", rootPath, fromPath);
        VirtualFile versionCatalogFile = VfsUtil.findFileByIoFile((File)new File(FileUtilRt.toSystemDependentName((String)path)), (boolean)false);
        if (versionCatalogFile == null) {
            return Optional.empty();
        }
        return Optional.of(this.getOrCreateVersionCatalogFile(versionCatalogFile, name2));
    }

    private void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile) {
        File propertiesFilePath;
        VirtualFile propertiesFile;
        if (buildDslFile == null) {
            BuildModelContext.$$$reportNull$$$0(33);
        }
        if ((propertiesFile = VfsUtil.findFileByIoFile((File)(propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties")), (boolean)false)) == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = this.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModelImpl propertiesModel = new GradlePropertiesModelImpl(parsedProperties);
        GradlePropertiesFile propertiesDslFile = propertiesModel.myGradlePropertiesFile;
        buildDslFile.setPropertiesFile(propertiesDslFile);
    }

    @Nullable
    private GradleSettingsModel getSettingsModel(@NotNull GradleBuildFile buildDslFile) {
        VirtualFile maybeSettingsFile;
        if (buildDslFile == null) {
            BuildModelContext.$$$reportNull$$$0(34);
        }
        if ((maybeSettingsFile = buildDslFile.tryToFindSettingsFile()) == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.getOrCreateSettingsFile(maybeSettingsFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    private void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile, @Nullable GradleSettingsModel gradleSettingsModel) {
        if (buildDslFile == null) {
            BuildModelContext.$$$reportNull$$$0(35);
        }
        if (gradleSettingsModel == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleBuildFile parentModuleDslFile = parentModuleModelImpl.myGradleBuildFile;
        buildDslFile.setParentModuleBuildFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement(SubProjectsDslElement.SUBPROJECTS);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.addAppliedProperty(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            GradleDslElement element = entry.getValue();
            if (element instanceof ApplyDslElement) {
                ApplyDslElement subProjectsApply = (ApplyDslElement)element;
                ApplyDslElement myApply = new ApplyDslElement(buildDslFile, buildDslFile);
                buildDslFile.setParsedElement(myApply);
                for (GradleDslElement appliedElement : subProjectsApply.getAllElements()) {
                    myApply.addParsedElement(appliedElement);
                }
                continue;
            }
            buildDslFile.addAppliedProperty(this.dslTreeCopy(element, buildDslFile));
        }
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element, GradleDslElement parent) {
        return this.dslTreeCopy(element, parent, new HashMap<GradleDslElement, GradleDslElement>());
    }

    private GradleDslElement dslTreeCopy(GradleDslElement element, GradleDslElement parent, Map<GradleDslElement, GradleDslElement> seen) {
        GradleDslElement result;
        GradleDslElement previous = seen.get(element);
        if (previous != null) {
            return previous;
        }
        if (element instanceof DescribedGradlePropertiesDslElement) {
            PropertiesElementDescription description = ((DescribedGradlePropertiesDslElement)((Object)element)).getDescription();
            Object myProperties = description.constructor.construct(parent, GradleNameElement.copy(element.getNameElement()));
            result = myProperties;
            seen.put(element, result);
            for (GradleDslElement subElement : ((GradlePropertiesDslElement)element).getAllElements()) {
                ((GradlePropertiesDslElement)myProperties).addAppliedProperty(this.dslTreeCopy(subElement, (GradleDslElement)myProperties, seen));
            }
        } else {
            result = element;
            seen.put(element, result);
        }
        return result;
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull Module module) {
        VirtualFile result;
        if (module == null) {
            BuildModelContext.$$$reportNull$$$0(36);
        }
        if ((result = this.myResolvedConfigurationFileLocationProvider.getGradleBuildFile(module)) != null) {
            return result;
        }
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(module);
        if (rootPath == null) {
            return null;
        }
        File moduleRoot = new File(FileUtilRt.toSystemDependentName((String)rootPath));
        return this.getGradleBuildFile(moduleRoot);
    }

    @Nullable
    public VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath;
        VirtualFile result;
        if (dirPath == null) {
            BuildModelContext.$$$reportNull$$$0(37);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleBuildFilePath = BuildScriptUtil.findGradleBuildFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath;
        VirtualFile result;
        if (dirPath == null) {
            BuildModelContext.$$$reportNull$$$0(38);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleSettingsFilePath = BuildScriptUtil.findGradleSettingsFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public VirtualFile getProjectSettingsFile() {
        @SystemIndependent String rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject());
        if (rootPath == null) {
            return null;
        }
        return this.getGradleSettingsFile(new File(FileUtilRt.toSystemDependentName((String)rootPath)));
    }

    @Nullable
    public VirtualFile getVersionCatalogFile(@NotNull File dirPath, @NotNull String name2) {
        File versionCatalogFilePath;
        VirtualFile result;
        if (dirPath == null) {
            BuildModelContext.$$$reportNull$$$0(39);
        }
        if (name2 == null) {
            BuildModelContext.$$$reportNull$$$0(40);
        }
        return (result = VfsUtil.findFileByIoFile((File)(versionCatalogFilePath = new File(dirPath, name2 + ".versions.toml")), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public VirtualFile getVersionCatalogFile(@NotNull String name2) {
        String rootPath;
        if (name2 == null) {
            BuildModelContext.$$$reportNull$$$0(41);
        }
        if ((rootPath = this.myResolvedConfigurationFileLocationProvider.getGradleProjectRootPath(this.getProject())) == null) {
            return null;
        }
        return this.getVersionCatalogFile(new File(FileUtilRt.toSystemDependentName((String)rootPath), "gradle"), name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 11, 14, 16, 18, 23, 27, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectFile";
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedConfigurationFileLocationProvider";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 27: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/BuildModelContext";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 29: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/BuildModelContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationForType";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSettingsFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVersionCatalogFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRequestedFiles";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionCatalogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRootProjectFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 27: 
            case 31: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPublicNotifications";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationForType";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePropertiesFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateVersionCatalogFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "initializeContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "populateSiblingDslFileWithGradlePropertiesFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsModel";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "populateWithParentModuleSubProjectsProperties";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFile";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVersionCatalogFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10, 11, 14, 16, 18, 23, 27, 31, 32 -> new IllegalStateException(string);
        };
    }

    public static interface ResolvedConfigurationFileLocationProvider {
        @Nullable
        public VirtualFile getGradleBuildFile(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Module var1);

        @Nullable
        public @SystemIndependent String getGradleProjectRootPath(@NotNull Project var1);
    }
}

