/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.incremental.LineOutputWriter;
import org.jetbrains.jps.javac.APIWrappers;
import org.jetbrains.jps.javac.CompilationCanceledException;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JavaCompilerToolExtension;
import org.jetbrains.jps.javac.JpsInfoDiagnostic;
import org.jetbrains.jps.javac.JpsJavacFileManager;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;

public final class JavacMain {
    private static final Set<String> FILTERED_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-d", "-classpath", "-cp", "--class-path", "-bootclasspath", "--boot-class-path")));
    private static final Set<String> FILTERED_SINGLE_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-verbose", "-implicit:class", "-implicit:none", "-Xprefer:newer", "-Xprefer:source")));
    private static final Set<String> FILE_MANAGER_EARLY_INIT_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("-encoding", "-extdirs", "-endorseddirs", "-processorpath", "--processor-path", "--processor-module-path", "-s", "-d", "-h")));
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    private static final boolean JAVA_RUNTIME_PRE_9 = JAVA_RUNTIME_VERSION.startsWith("1.8.") || JAVA_RUNTIME_VERSION.startsWith("8.") || JAVA_RUNTIME_VERSION.startsWith("1.7.") || JAVA_RUNTIME_VERSION.startsWith("7.") || JAVA_RUNTIME_VERSION.startsWith("1.6.") || JAVA_RUNTIME_VERSION.startsWith("6.");
    public static final String TRACK_AP_GENERATED_DEPENDENCIES_PROPERTY = "jps.track.ap.dependencies";
    public static final boolean TRACK_AP_GENERATED_DEPENDENCIES = Boolean.parseBoolean(System.getProperty("jps.track.ap.dependencies", "true"));
    private static volatile boolean zipCacheCleanupPossible = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compile(Iterable<? extends String> options, Iterable<? extends File> sources, Iterable<? extends File> classpath, Iterable<? extends File> platformClasspath, ModulePath modulePath, Iterable<? extends File> upgradeModulePath, Iterable<? extends File> sourcePath, final Map<File, Set<File>> outputDirToRoots, DiagnosticOutputConsumer diagnosticConsumer, OutputFileConsumer outputSink, CanceledStatus canceledStatus, @NotNull JavaCompilingTool compilingTool) {
        block55: {
            JavaCompiler compiler;
            if (compilingTool == null) {
                JavacMain.$$$reportNull$$$0(0);
            }
            try {
                compiler = compilingTool.createCompiler();
            }
            catch (CannotCreateJavaCompilerException e) {
                diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
                return false;
            }
            for (File outputDir : outputDirToRoots.keySet()) {
                outputDir.mkdirs();
            }
            final boolean usingJavac = compilingTool instanceof JavacCompilerTool;
            boolean javacBefore9 = usingJavac && JAVA_RUNTIME_PRE_9;
            JpsJavacFileManager fileManager = new JpsJavacFileManager(new ContextImpl(compiler, diagnosticConsumer, outputSink, modulePath, canceledStatus), javacBefore9, JavaSourceTransformer.getTransformers());
            if (javacBefore9 && !Iterators.isEmpty(platformClasspath)) {
                fileManager.handleOption("-bootclasspath", Collections.singleton("").iterator());
                fileManager.handleOption("-extdirs", Collections.singleton("").iterator());
                fileManager.handleOption("-endorseddirs", Collections.singleton("").iterator());
            }
            Iterable<String> _options = JavacMain.prepareOptions(options, compilingTool);
            try {
                Iterable<Processor> processors;
                DiagnosticOutputConsumer diagnosticListener;
                APIWrappers.ProcessingContext procContext;
                Iterator<String> iterator = _options.iterator();
                while (iterator.hasNext()) {
                    String option = iterator.next();
                    if (!FILE_MANAGER_EARLY_INIT_OPTIONS.contains(option)) continue;
                    fileManager.handleOption(option, iterator);
                }
                try {
                    fileManager.setOutputDirectories(outputDirToRoots);
                }
                catch (IOException e) {
                    fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                    boolean option = false;
                    fileManager.close();
                    if (usingJavac) {
                        JavacMain.cleanupJavacNameTable();
                    }
                    return option;
                }
                if (!Iterators.isEmpty(platformClasspath)) {
                    try {
                        fileManager.handleOption("-bootclasspath", Collections.singleton("").iterator());
                        fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, JavacMain.buildPlatformClasspath(platformClasspath, _options));
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                if (!Iterators.isEmpty(upgradeModulePath)) {
                    try {
                        JavacMain.setLocation(fileManager, "UPGRADE_MODULE_PATH", upgradeModulePath);
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean option = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return option;
                    }
                }
                boolean isAnnotationProcessingEnabled = JavacMain.isAnnotationProcessingEnabled(_options);
                if (!modulePath.isEmpty()) {
                    try {
                        JavacMain.setLocation(fileManager, "MODULE_PATH", modulePath.getPath());
                        if (isAnnotationProcessingEnabled && JavacMain.getLocation(fileManager, "ANNOTATION_PROCESSOR_MODULE_PATH") == null && fileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) == null) {
                            JavacMain.setLocation(fileManager, "ANNOTATION_PROCESSOR_MODULE_PATH", Iterators.filter(modulePath.getPath(), new BooleanFunction<File>(){

                                public boolean fun(File file) {
                                    return !outputDirToRoots.containsKey(file);
                                }
                            }));
                        }
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean bl = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return bl;
                    }
                }
                if (!Iterators.isEmpty(classpath)) {
                    try {
                        fileManager.setLocation(StandardLocation.CLASS_PATH, classpath);
                        if (!usingJavac && isAnnotationProcessingEnabled && !Iterators.contains(_options, "-processorpath") && !Iterators.contains(_options, "--processor-module-path") && JavacMain.getLocation(fileManager, "ANNOTATION_PROCESSOR_MODULE_PATH") == null) {
                            fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, classpath);
                        }
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean bl = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return bl;
                    }
                }
                if (javacBefore9 || !Iterators.isEmpty(sourcePath) || modulePath.isEmpty()) {
                    try {
                        fileManager.setLocation(StandardLocation.SOURCE_PATH, sourcePath);
                    }
                    catch (IOException e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.ERROR, e.getMessage());
                        boolean bl = false;
                        fileManager.close();
                        if (usingJavac) {
                            JavacMain.cleanupJavacNameTable();
                        }
                        return bl;
                    }
                }
                if (TRACK_AP_GENERATED_DEPENDENCIES && isAnnotationProcessingEnabled) {
                    procContext = new APIWrappers.ProcessingContext(fileManager);
                    diagnosticListener = APIWrappers.newDiagnosticListenerWrapper(procContext, diagnosticConsumer);
                } else {
                    procContext = null;
                    diagnosticListener = diagnosticConsumer;
                }
                LineOutputWriter out = new LineOutputWriter(){

                    @Override
                    protected void lineAvailable(String line) {
                        if (usingJavac) {
                            diagnosticListener.outputLineAvailable(line);
                        }
                    }
                };
                StandardJavaFileManager fm = APIWrappers.wrap(StandardJavaFileManager.class, fileManager, fileManager.getClass().getSuperclass(), fileManager.getStdManager());
                JavaCompiler.CompilationTask task = JavacMain.tryInstallClientCodeWrapperCallDispatcher(compiler.getTask(out, fm, diagnosticListener, _options, null, fileManager.setInputSources(sources)), fm);
                for (JavaCompilerToolExtension extension : JavaCompilerToolExtension.getExtensions()) {
                    try {
                        extension.beforeCompileTaskExecution(compilingTool, task, _options, diagnosticConsumer);
                    }
                    catch (Throwable e) {
                        fileManager.getContext().reportMessage(Diagnostic.Kind.MANDATORY_WARNING, extension.getClass() + " : " + e.getMessage());
                        e.printStackTrace(System.err);
                    }
                }
                if (TRACK_AP_GENERATED_DEPENDENCIES && isAnnotationProcessingEnabled && (processors = JavacMain.lookupAnnotationProcessors(procContext, JavacMain.getAnnotationProcessorNames(_options))) != null) {
                    task.setProcessors(processors);
                }
                boolean bl = task.call();
                return bl;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
            }
            catch (CompilationCanceledException e) {
                diagnosticConsumer.report(new JpsInfoDiagnostic(e.getMessage()));
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (cause instanceof CompilationCanceledException) {
                        diagnosticConsumer.report(new JpsInfoDiagnostic(cause.getMessage()));
                        break block55;
                    }
                    diagnosticConsumer.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, JavacMain.buildCompilerErrorMessage(e)));
                    throw e;
                }
                throw e;
            }
            finally {
                fileManager.close();
                if (usingJavac) {
                    JavacMain.cleanupJavacNameTable();
                }
            }
        }
        return false;
    }

    @Nullable
    private static Iterable<Processor> lookupAnnotationProcessors(APIWrappers.ProcessingContext procContext, @Nullable Iterable<String> processorNames) {
        try {
            Iterable<Object> processors = null;
            if (JavacMain.hasLocation(procContext.getFileManager(), "ANNOTATION_PROCESSOR_MODULE_PATH")) {
                processors = (ServiceLoader)JavaFileManager.class.getMethod("getServiceLoader", JavaFileManager.Location.class, Class.class).invoke((Object)procContext.getFileManager(), StandardLocation.locationFor("ANNOTATION_PROCESSOR_MODULE_PATH"), Processor.class);
                if (processorNames != null) {
                    processors = Iterators.filterWithOrder(processors, Iterators.map(processorNames, new Function<String, BooleanFunction<? super Processor>>(){

                        public BooleanFunction<? super Processor> fun(final String procName) {
                            return new BooleanFunction<Processor>(){

                                public boolean fun(Processor processor) {
                                    return procName.equals(processor.getClass().getName());
                                }
                            };
                        }
                    }));
                }
            } else {
                ClassLoader processorClassLoader = procContext.getFileManager().getClassLoader(procContext.getFileManager().hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? StandardLocation.ANNOTATION_PROCESSOR_PATH : StandardLocation.CLASS_PATH);
                if (processorClassLoader != null) {
                    if (processorNames != null) {
                        ArrayList<Processor> loaded = new ArrayList<Processor>();
                        for (String procName : processorNames) {
                            loaded.add((Processor)processorClassLoader.loadClass(procName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        processors = loaded;
                    } else {
                        processors = ServiceLoader.load(Processor.class, processorClassLoader);
                    }
                }
            }
            if (processors != null) {
                return procContext.wrapProcessors(processors);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Nullable
    private static Iterable<String> getAnnotationProcessorNames(Iterable<String> options) {
        Iterator<String> it = options.iterator();
        while (it.hasNext()) {
            String option = it.next();
            if (!"-processor".equals(option)) continue;
            return it.hasNext() ? Arrays.asList(it.next().split(",")) : null;
        }
        return null;
    }

    @Nls
    private static String buildCompilerErrorMessage(Throwable e) {
        return new Object(){
            @Nls
            final StringBuilder buf = new StringBuilder();

            @Nls
            String collectAllMessages(Throwable e, Set<Throwable> processed) {
                if (e != null && processed.add(e)) {
                    String msg = e.getMessage();
                    if (msg != null && !msg.trim().isEmpty() && this.buf.indexOf(msg) < 0) {
                        if (this.buf.length() > 0) {
                            this.buf.append("\n");
                        }
                        this.buf.append(msg);
                    }
                    return this.collectAllMessages(e.getCause(), processed);
                }
                return this.buf.toString();
            }
        }.collectAllMessages(e, new HashSet<Throwable>());
    }

    private static JavaCompiler.CompilationTask tryInstallClientCodeWrapperCallDispatcher(JavaCompiler.CompilationTask task, StandardJavaFileManager delegateTo) {
        try {
            final Class<?> taskClass = task.getClass();
            Field contextField = JavacMain.findField(taskClass, (BooleanFunction<? super Field>)new BooleanFunction<Field>(){
                private final Class<?> contextClass;
                {
                    this.contextClass = Class.forName("com.sun.tools.javac.util.Context", true, taskClass.getClassLoader());
                }

                public boolean fun(Field field) {
                    return this.contextClass.equals(field.getType());
                }
            });
            if (contextField != null) {
                Object contextObject = contextField.get(task);
                Method getMethod = contextObject.getClass().getMethod("get", Class.class);
                Object currentManager = getMethod.invoke(contextObject, JavaFileManager.class);
                if (JavacMain.isClientCodeWrapper(currentManager, delegateTo)) {
                    Method putMethod = contextObject.getClass().getMethod("put", Class.class, Object.class);
                    putMethod.invoke(contextObject, JavaFileManager.class, null);
                    putMethod.invoke(contextObject, JavaFileManager.class, APIWrappers.wrap(StandardJavaFileManager.class, currentManager, Object.class, delegateTo));
                } else {
                    JavacMain.installCallDispatcherRecursively(currentManager, delegateTo, new HashSet<Object>());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return task;
    }

    private static void installCallDispatcherRecursively(final Object obj, final StandardJavaFileManager delegateTo, final Set<Object> visited) {
        if (obj instanceof JavaFileManager && visited.add(obj)) {
            JavacMain.forEachField(obj.getClass(), (BooleanFunction<? super Field>)new BooleanFunction<Field>(){

                public boolean fun(Field field) {
                    try {
                        if (JavaFileManager.class.isAssignableFrom(field.getType())) {
                            Object value = field.get(obj);
                            if (JavacMain.isClientCodeWrapper(value, delegateTo)) {
                                field.set(obj, APIWrappers.wrap(StandardJavaFileManager.class, value, Object.class, delegateTo));
                            } else {
                                JavacMain.installCallDispatcherRecursively(value, delegateTo, visited);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return true;
                }
            });
        }
    }

    private static boolean isClientCodeWrapper(final Object obj, final StandardJavaFileManager delegateTo) {
        return obj instanceof StandardJavaFileManager && JavacMain.findField(obj.getClass(), (BooleanFunction<? super Field>)new BooleanFunction<Field>(){

            public boolean fun(Field f) {
                try {
                    return f.get(obj) == delegateTo;
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
        }) != null;
    }

    private static Field findField(Class<?> aClass, final BooleanFunction<? super Field> cond) {
        final Field[] res = new Field[]{null};
        JavacMain.forEachField(aClass, (BooleanFunction<? super Field>)new BooleanFunction<Field>(){

            public boolean fun(Field field) {
                if (!cond.fun((Object)field)) {
                    return true;
                }
                res[0] = field;
                return false;
            }
        });
        return res[0];
    }

    private static void forEachField(Class<?> aClass, BooleanFunction<? super Field> func) {
        for (Class<?> from = aClass; from != null && !Object.class.equals(from); from = from.getSuperclass()) {
            for (Field field : from.getDeclaredFields()) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (func.fun((Object)field)) continue;
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void setLocation(StandardJavaFileManager fileManager, String locationId, Iterable<? extends File> path) throws IOException {
        JavaFileManager.Location location = StandardLocation.locationFor(locationId);
        if (location != null) {
            fileManager.setLocation(location, path);
        }
    }

    private static Iterable<? extends File> getLocation(StandardJavaFileManager fileManager, String locationId) {
        JavaFileManager.Location location = StandardLocation.locationFor(locationId);
        return location != null ? fileManager.getLocation(location) : null;
    }

    private static boolean hasLocation(StandardJavaFileManager fileManager, String locationId) {
        JavaFileManager.Location location = StandardLocation.locationFor(locationId);
        return location != null && fileManager.hasLocation(location);
    }

    private static boolean isAnnotationProcessingEnabled(Iterable<String> options) {
        return !Iterators.contains(options, "-proc:none");
    }

    private static Iterable<String> prepareOptions(Iterable<? extends String> options, @NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            JavacMain.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>(compilingTool.getDefaultCompilerOptions());
        boolean skip = false;
        for (String string : options) {
            if (FILTERED_OPTIONS.contains(string)) {
                skip = true;
                continue;
            }
            if (!(skip || FILTERED_SINGLE_OPTIONS.contains(string) || compilingTool.getDefaultCompilerOptions().contains(string))) {
                result.add(string);
            }
            skip = false;
        }
        compilingTool.preprocessOptions(result);
        return result;
    }

    private static Iterable<? extends File> buildPlatformClasspath(Iterable<? extends File> platformClasspath, Iterable<String> options) {
        HashMap<PathOption, String> argsMap = new HashMap<PathOption, String>();
        Iterator<String> iterator = options.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            for (PathOption pathOption : PathOption.values()) {
                if (pathOption.parse(argsMap, arg, iterator)) break;
            }
        }
        if (argsMap.isEmpty()) {
            return platformClasspath;
        }
        ArrayList result = new ArrayList();
        JavacMain.appendFiles(argsMap, PathOption.PREPEND_CP, result, false);
        JavacMain.appendFiles(argsMap, PathOption.ENDORSED, result, true);
        JavacMain.appendFiles(argsMap, PathOption.D_ENDORSED, result, true);
        Iterators.collect(platformClasspath, result);
        JavacMain.appendFiles(argsMap, PathOption.APPEND_CP, result, false);
        JavacMain.appendFiles(argsMap, PathOption.EXTDIRS, result, true);
        JavacMain.appendFiles(argsMap, PathOption.D_EXTDIRS, result, true);
        return result;
    }

    private static void appendFiles(Map<PathOption, String> args, PathOption option, Collection<? super File> container, boolean listDir) {
        String path = args.get((Object)option);
        if (path == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (listDir) {
                File[] files = file.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    String fName = f.getName();
                    if (!fName.endsWith(".jar") && !fName.endsWith(".zip")) continue;
                    container.add(f);
                }
                continue;
            }
            container.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupJavacNameTable() {
        block5: {
            try {
                Field freelistField = NameTableCleanupDataHolder.freelistField;
                Object emptyList = NameTableCleanupDataHolder.emptyList;
                if (freelistField == null || emptyList == null) break block5;
                Class<?> clazz = freelistField.getDeclaringClass();
                synchronized (clazz) {
                    freelistField.set(null, emptyList);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void clearCompilerZipFileCache() {
        if (zipCacheCleanupPossible) {
            Method clearMethod = ZipFileIndexCleanupDataHolder.cacheClearMethod;
            if (clearMethod != null) {
                Method getter = ZipFileIndexCleanupDataHolder.cacheInstanceGetter;
                try {
                    Object instance = getter != null ? getter.invoke(null, new Object[0]) : null;
                    clearMethod.invoke(instance, new Object[0]);
                }
                catch (Throwable e) {
                    zipCacheCleanupPossible = false;
                }
            } else {
                zipCacheCleanupPossible = false;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "compilingTool";
        objectArray2[1] = "org/jetbrains/jps/javac/JavacMain";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ContextImpl
    implements JpsJavacFileManager.Context {
        private final StandardJavaFileManager myStdManager;
        private final DiagnosticOutputConsumer myOutConsumer;
        private final OutputFileConsumer myOutputFileSink;
        private final ModulePath myModulePath;
        private final CanceledStatus myCanceledStatus;

        ContextImpl(@NotNull JavaCompiler compiler, @NotNull DiagnosticOutputConsumer outConsumer, @NotNull OutputFileConsumer sink, @NotNull ModulePath modulePath, CanceledStatus canceledStatus) {
            if (compiler == null) {
                ContextImpl.$$$reportNull$$$0(0);
            }
            if (outConsumer == null) {
                ContextImpl.$$$reportNull$$$0(1);
            }
            if (sink == null) {
                ContextImpl.$$$reportNull$$$0(2);
            }
            if (modulePath == null) {
                ContextImpl.$$$reportNull$$$0(3);
            }
            this.myOutConsumer = outConsumer;
            this.myOutputFileSink = sink;
            this.myModulePath = modulePath;
            this.myCanceledStatus = canceledStatus;
            this.myStdManager = compiler.getStandardFileManager(outConsumer, Locale.US, null);
        }

        @Override
        @Nullable
        public String getExplodedAutomaticModuleName(File pathElement) {
            return this.myModulePath.getModuleName(pathElement);
        }

        @Override
        public boolean isCanceled() {
            return this.myCanceledStatus.isCanceled();
        }

        @Override
        @NotNull
        public StandardJavaFileManager getStandardFileManager() {
            StandardJavaFileManager standardJavaFileManager = this.myStdManager;
            if (standardJavaFileManager == null) {
                ContextImpl.$$$reportNull$$$0(4);
            }
            return standardJavaFileManager;
        }

        @Override
        public void reportMessage(Diagnostic.Kind kind, @Nls String message) {
            this.myOutConsumer.report(new PlainMessageDiagnostic(kind, message));
        }

        @Override
        public void consumeOutputFile(@NotNull OutputFileObject cls) {
            if (cls == null) {
                ContextImpl.$$$reportNull$$$0(5);
            }
            this.myOutputFileSink.save(cls);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compiler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outConsumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modulePath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/JavacMain$ContextImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/JavacMain$ContextImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStandardFileManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "consumeOutputFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum PathOption {
        PREPEND_CP("-Xbootclasspath/p:"),
        ENDORSED("-endorseddirs"),
        D_ENDORSED("-Djava.endorsed.dirs="),
        APPEND_CP("-Xbootclasspath/a:"),
        EXTDIRS("-extdirs"),
        D_EXTDIRS("-Djava.ext.dirs=");

        private final String myArgName;
        private final boolean myIsSuffix;

        private PathOption(String name) {
            this.myArgName = name;
            this.myIsSuffix = name.endsWith("=") || name.endsWith(":");
        }

        public boolean parse(Map<PathOption, String> container, String arg, Iterator<String> rest) {
            if (this.myIsSuffix) {
                if (arg.startsWith(this.myArgName)) {
                    container.put(this, arg.substring(this.myArgName.length()));
                    return true;
                }
            } else if (arg.equals(this.myArgName)) {
                if (rest.hasNext()) {
                    container.put(this, rest.next());
                }
                return true;
            }
            return false;
        }
    }

    private static final class NameTableCleanupDataHolder {
        static final Object emptyList;
        static final Field freelistField;

        private NameTableCleanupDataHolder() {
        }

        static {
            try {
                Field freelistRef;
                ClassLoader loader = ToolProvider.getSystemToolClassLoader();
                if (loader == null) {
                    throw new RuntimeException("no tools provided");
                }
                Class<?> listClass = Class.forName("com.sun.tools.javac.util.List", true, loader);
                Method nilMethod = listClass.getDeclaredMethod("nil", new Class[0]);
                emptyList = nilMethod.invoke(null, new Object[0]);
                try {
                    freelistRef = Class.forName("com.sun.tools.javac.util.Name$Table", true, loader).getDeclaredField("freelist");
                }
                catch (Exception e) {
                    freelistRef = Class.forName("com.sun.tools.javac.util.SharedNameTable", true, loader).getDeclaredField("freelist");
                }
                freelistRef.setAccessible(true);
                freelistField = freelistRef;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ZipFileIndexCleanupDataHolder {
        @Nullable
        static final Method cacheInstanceGetter;
        @Nullable
        static final Method cacheClearMethod;

        private ZipFileIndexCleanupDataHolder() {
        }

        static {
            Method getterMethod = null;
            Method clearMethod = null;
            try {
                clearMethod = Class.forName("com.sun.tools.javac.zip.ZipFileIndex").getDeclaredMethod("clearCache", new Class[0]);
                clearMethod.setAccessible(true);
            }
            catch (Throwable e) {
                try {
                    Class<?> cacheClass = Class.forName("com.sun.tools.javac.file.ZipFileIndexCache");
                    clearMethod = cacheClass.getDeclaredMethod("clearCache", new Class[0]);
                    getterMethod = cacheClass.getDeclaredMethod("getSharedInstance", new Class[0]);
                    clearMethod.setAccessible(true);
                    getterMethod.setAccessible(true);
                }
                catch (Throwable ignored2) {
                    clearMethod = null;
                    getterMethod = null;
                }
            }
            cacheInstanceGetter = getterMethod;
            cacheClearMethod = clearMethod;
        }
    }
}

