/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonPsiImplUtils;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorLineMarkerProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.DevKitThemesBundle;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeColorAnnotator
implements Annotator {
    private static final Pattern COLOR_HEX_PATTERN_RGB = Pattern.compile("^#([A-Fa-f0-9]{6})$");
    private static final Pattern COLOR_HEX_PATTERN_RGBA = Pattern.compile("^#([A-Fa-f0-9]{8})$");
    private static final int HEX_COLOR_LENGTH_RGB = 7;
    private static final int HEX_COLOR_LENGTH_RGBA = 9;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(1);
        }
        if (!ThemeColorAnnotator.isColorLineMarkerProviderEnabled() || !ThemeColorAnnotator.isTargetElement(element, holder.getCurrentAnnotationSession().getFile())) {
            return;
        }
        JsonStringLiteral literal = (JsonStringLiteral)element;
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).gutterIconRenderer((GutterIconRenderer)new MyRenderer(literal.getValue(), literal)).create();
    }

    private static boolean isColorLineMarkerProviderEnabled() {
        return LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)ColorLineMarkerProvider.INSTANCE);
    }

    static boolean isTargetElement(@NotNull PsiElement element) {
        if (element == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(2);
        }
        return ThemeColorAnnotator.isTargetElement(element, element.getContainingFile());
    }

    private static boolean isTargetElement(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(3);
        }
        if (containingFile == null) {
            ThemeColorAnnotator.$$$reportNull$$$0(4);
        }
        if (!(element instanceof JsonStringLiteral)) {
            return false;
        }
        if (!ThemeJsonUtil.isThemeFilename(containingFile.getName())) {
            return false;
        }
        if (JsonPsiImplUtils.isPropertyName((JsonStringLiteral)((JsonStringLiteral)element))) {
            return false;
        }
        String text = ((JsonStringLiteral)element).getValue();
        return ThemeColorAnnotator.isColorCode(text) || ThemeColorAnnotator.isNamedColor(text);
    }

    private static boolean isNamedColor(String text) {
        return StringUtil.isLatinAlphanumeric((CharSequence)text);
    }

    private static boolean isColorCode(@Nullable String text) {
        if (!StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
            return false;
        }
        if (text.length() != 7 && text.length() != 9) {
            return false;
        }
        return COLOR_HEX_PATTERN_RGB.matcher(text).matches() || COLOR_HEX_PATTERN_RGBA.matcher(text).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRenderer
    extends GutterIconRenderer {
        private static final int ICON_SIZE = 12;
        private final String myColorText;
        private JsonStringLiteral myLiteral;

        private MyRenderer(@NotNull String colorText, @NotNull JsonStringLiteral literal) {
            if (colorText == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (literal == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            this.myColorText = colorText;
            this.myLiteral = literal;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getColor(this.myColorText);
            if (color != null) {
                JBScalableIcon jBScalableIcon = JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(12, color));
                if (jBScalableIcon == null) {
                    MyRenderer.$$$reportNull$$$0(2);
                }
                return jBScalableIcon;
            }
            JBScalableIcon jBScalableIcon = JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)12));
            if (jBScalableIcon == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            return jBScalableIcon;
        }

        public boolean isNavigateAction() {
            return this.canChooseColor();
        }

        @Nullable
        public String getTooltipText() {
            return this.canChooseColor() ? DevKitThemesBundle.message("theme.choose.color.tooltip", new Object[0]) : null;
        }

        @Nullable
        public AnAction getClickAction() {
            if (!this.canChooseColor()) {
                return null;
            }
            return new AnAction(DevKitThemesBundle.messagePointer("action.Anonymous.text.choose.color", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
                        return;
                    }
                    Color currentColor = this.getColor(myColorText);
                    if (currentColor == null) {
                        return;
                    }
                    boolean withAlpha = MyRenderer.isRgbaColorHex(myColorText);
                    if (Registry.is((String)"ide.new.color.picker")) {
                        ColorChooserService.getInstance().showPopup(e.getProject(), currentColor, (c, l) -> this.applyColor(currentColor, withAlpha, c));
                    } else {
                        Color newColor = ColorChooserService.getInstance().showDialog(editor.getProject(), (Component)editor.getComponent(), DevKitThemesBundle.message("theme.choose.color.dialog.title", new Object[0]), currentColor, withAlpha);
                        this.applyColor(currentColor, withAlpha, newColor);
                    }
                }

                private void applyColor(Color currentColor, boolean withAlpha, Color newColor) {
                    if (newColor == null || newColor.equals(currentColor)) {
                        return;
                    }
                    String newColorHex = "#" + ColorUtil.toHex((Color)newColor, (boolean)withAlpha);
                    Project project = myLiteral.getProject();
                    JsonStringLiteral newLiteral = new JsonElementGenerator(project).createStringLiteral(newColorHex);
                    WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{myLiteral.getContainingFile()}).run(() -> {
                        myLiteral = (JsonStringLiteral)myLiteral.replace((PsiElement)newLiteral);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer$1", "actionPerformed"));
                }
            };
        }

        private boolean canChooseColor() {
            return ThemeColorAnnotator.isColorCode(this.myColorText);
        }

        @Nullable
        private Color getColor(@NotNull String colorText) {
            if (colorText == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            if (!ThemeColorAnnotator.isColorCode(colorText)) {
                return this.findNamedColor(colorText);
            }
            return MyRenderer.parseColor(colorText);
        }

        @Nullable
        private static Color parseColor(@NotNull String colorHex) {
            boolean isRgba;
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            if (!(isRgba = MyRenderer.isRgbaColorHex(colorHex)) && !MyRenderer.isRgbColorHex(colorHex)) {
                return null;
            }
            try {
                String alpha = isRgba ? colorHex.substring(7) : null;
                String colorHexWithoutAlpha = isRgba ? colorHex.substring(0, 7) : colorHex;
                Color color = Color.decode(colorHexWithoutAlpha);
                if (isRgba) {
                    color = ColorUtil.toAlpha((Color)color, (int)Integer.parseInt(alpha, 16));
                }
                return color;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }

        @Nullable
        private Color findNamedColor(String colorText) {
            PsiFile file = this.myLiteral.getContainingFile();
            if (!(file instanceof JsonFile)) {
                return null;
            }
            List<JsonProperty> colors = ThemeJsonUtil.getNamedColors((JsonFile)file);
            JsonProperty namedColor = (JsonProperty)ContainerUtil.find(colors, property -> property.getName().equals(colorText));
            if (namedColor == null) {
                return null;
            }
            JsonValue value = namedColor.getValue();
            if (!(value instanceof JsonStringLiteral)) {
                return null;
            }
            return MyRenderer.parseColor(((JsonStringLiteral)value).getValue());
        }

        private static boolean isRgbaColorHex(@NotNull String colorHex) {
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(6);
            }
            return colorHex.length() == 9;
        }

        private static boolean isRgbColorHex(@NotNull String colorHex) {
            if (colorHex == null) {
                MyRenderer.$$$reportNull$$$0(7);
            }
            return colorHex.length() == 7;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer renderer = (MyRenderer)((Object)o);
            return this.myColorText.equals(renderer.myColorText) && this.myLiteral.equals(renderer.myLiteral);
        }

        public int hashCode() {
            return Objects.hash(this.myColorText, this.myLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorHex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeColorAnnotator$MyRenderer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getColor";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseColor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isRgbaColorHex";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isRgbColorHex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

