/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class FileEqualsUsageInspection
extends DevKitUastInspectionBase {
    private static final String[] METHOD_NAMES = new String[]{"equals", "compareTo", "hashCode"};
    private static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileEqualsUsageInspection.inspectCallExpression(node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection$1", "visitCallExpression"));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void inspectCallExpression(@NotNull UCallExpression node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(3);
        }
        if (!node.isMethodNameOneOf(List.of(METHOD_NAMES))) {
            return;
        }
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"java.io.File".equals(containingClass.getQualifiedName())) {
            return;
        }
        if (!DevKitInspectionUtil.isClassAvailable(holder, FileUtil.class.getName())) {
            return;
        }
        ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UCallExpression)node, (String)DevKitBundle.message("inspections.file.equals.method", new Object[0]), (LocalQuickFix[])LocalQuickFix.notNullElements((LocalQuickFix[])new LocalQuickFix[0]), (ProblemHighlightType)ProblemHighlightType.LIKE_DEPRECATED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectCallExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

