/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationEnumFieldValue;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.JvmProviderKt;
import org.jetbrains.idea.devkit.inspections.LevelType;
import org.jetbrains.idea.devkit.inspections.ServiceLevelExtractor;
import org.jetbrains.idea.devkit.inspections.ServiceLevelExtractors;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u0017"}, d2={"getLevelType", "Lorg/jetbrains/idea/devkit/inspections/LevelType;", "annotation", "Lcom/intellij/lang/jvm/JvmAnnotation;", "language", "Lcom/intellij/lang/Language;", "project", "Lcom/intellij/openapi/project/Project;", "uClass", "Lorg/jetbrains/uast/UClass;", "Lorg/jetbrains/uast/UAnnotation;", "getLevels", "", "Lcom/intellij/openapi/components/Service$Level;", "attributeValue", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationEnumFieldValue;", "isLightService", "", "toLevel", "name", "", "toLevelType", "levels", "intellij.devkit.core"})
@JvmName(name="ServiceUtil")
@SourceDebugExtension(value={"SMAP\nServiceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceUtil.kt\norg/jetbrains/idea/devkit/inspections/ServiceUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1603#2,9:122\n1855#2:131\n1856#2:133\n1612#2:134\n800#2,11:135\n766#2:146\n857#2,2:147\n1603#2,9:149\n1855#2:158\n1856#2:160\n1612#2:161\n1#3:132\n1#3:159\n1#3:162\n*S KotlinDebug\n*F\n+ 1 ServiceUtil.kt\norg/jetbrains/idea/devkit/inspections/ServiceUtil\n*L\n80#1:122,9\n80#1:131\n80#1:133\n80#1:134\n81#1:135,11\n82#1:146\n82#1:147,2\n83#1:149,9\n83#1:158\n83#1:160\n83#1:161\n80#1:132\n83#1:159\n*E\n"})
public final class ServiceUtil {
    @NotNull
    public static final LevelType getLevelType(@NotNull JvmAnnotation annotation, @NotNull Language language) {
        Collection<Service.Level> collection;
        JvmAnnotationAttributeValue attributeValue;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        JvmAnnotationAttribute jvmAnnotationAttribute = annotation.findAttribute("value");
        Object object = attributeValue = jvmAnnotationAttribute != null ? jvmAnnotationAttribute.getAttributeValue() : null;
        if (attributeValue instanceof JvmAnnotationArrayValue) {
            ServiceLevelExtractor serviceLevelExtractor = (ServiceLevelExtractor)JvmProviderKt.getProvider(ServiceLevelExtractors.INSTANCE, language);
            if (serviceLevelExtractor == null) {
                return LevelType.NOT_SPECIFIED;
            }
            ServiceLevelExtractor serviceLevelExtractor2 = serviceLevelExtractor;
            collection = serviceLevelExtractor2.extractLevels((JvmAnnotationArrayValue)attributeValue);
        } else {
            collection = attributeValue instanceof JvmAnnotationEnumFieldValue ? ServiceUtil.getLevels((JvmAnnotationEnumFieldValue)attributeValue) : (Collection<Service.Level>)SetsKt.emptySet();
        }
        Collection<Service.Level> levels = collection;
        return ServiceUtil.toLevelType(levels);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final LevelType getLevelType(@NotNull Project project, @NotNull UClass uClass) {
        UAnnotation serviceAnnotation;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        String string = Service.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Service::class.java.canonicalName");
        UAnnotation uAnnotation = serviceAnnotation = uClass.findAnnotation(string);
        if (uAnnotation != null) {
            return ServiceUtil.getLevelType(uAnnotation);
        }
        PsiClass javaPsi = uClass.getJavaPsi();
        DomManager domManager = DomManager.getDomManager((Project)project);
        boolean isModuleService = false;
        HashSet<Service.Level> levels = new HashSet<Service.Level>();
        for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(javaPsi)) {
            block8: {
                block9: {
                    DomElement element;
                    XmlTag tag;
                    if ((XmlTag)candidate.pointer.getElement() == null || domManager.getDomElement(tag) == null || !(element instanceof Extension) || !ExtensionUtil.INSTANCE.hasServiceBeanFqn((Extension)element)) continue;
                    ExtensionPoint extensionPoint = ((Extension)element).getExtensionPoint();
                    String string2 = extensionPoint != null ? extensionPoint.getEffectiveQualifiedName() : null;
                    if (string2 == null) continue;
                    switch (string2.hashCode()) {
                        case -698444602: {
                            if (string2.equals("com.intellij.projectService")) break;
                            break block8;
                        }
                        case -1286155777: {
                            if (string2.equals("com.intellij.moduleService")) break block9;
                            break block8;
                        }
                        case -1947960913: {
                            if (string2.equals("com.intellij.applicationService")) {
                                levels.add(Service.Level.APP);
                            }
                            break block8;
                        }
                    }
                    levels.add(Service.Level.PROJECT);
                    continue;
                }
                isModuleService = true;
            }
        }
        if (!levels.isEmpty()) return ServiceUtil.toLevelType((Collection<? extends Service.Level>)levels);
        if (!isModuleService) return null;
        LevelType levelType = LevelType.MODULE;
        return levelType;
    }

    @NotNull
    public static final Collection<Service.Level> getLevels(@NotNull JvmAnnotationEnumFieldValue attributeValue) {
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        if (!Intrinsics.areEqual((Object)attributeValue.getContainingClassName(), (Object)Service.Level.class.getCanonicalName())) {
            return SetsKt.emptySet();
        }
        String string = attributeValue.getFieldName();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String fieldName = string;
        Service.Level level = ServiceUtil.toLevel(fieldName);
        if (level == null) {
            return SetsKt.emptySet();
        }
        Service.Level level2 = level;
        return SetsKt.setOf((Object)level2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final LevelType getLevelType(UAnnotation annotation) {
        block7: {
            block8: {
                block6: {
                    value = annotation.findAttributeValue("value");
                    if (!(value instanceof UCallExpression)) break block6;
                    $this$mapNotNull$iv = ((UCallExpression)value).getValueArguments();
                    $i$f$mapNotNull = false;
                    var5_4 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var10_15 = $this$forEach$iv$iv$iv.iterator();
                    while (var10_15.hasNext()) {
                        element$iv$iv /* !! */  = element$iv$iv$iv = var10_15.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (UExpression)element$iv$iv /* !! */ ;
                        $i$a$-mapNotNull-ServiceUtil$getLevelType$levels$1 = false;
                        if (UastUtils.tryResolve((UElement)((UElement)it)) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    $i$f$filterIsInstance = false;
                    $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PsiField)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (PsiField)element$iv$iv;
                        $i$a$-filter-ServiceUtil$getLevelType$levels$2 = false;
                        v0 = it.getContainingClass();
                        if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getQualifiedName() : null), (Object)Service.Level.class.getCanonicalName())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        element$iv$iv$iv = it.next();
                        element$iv$iv /* !! */  = element$iv$iv$iv;
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (PsiField)element$iv$iv /* !! */ ;
                        $i$a$-mapNotNull-ServiceUtil$getLevelType$levels$3 = false;
                        v1 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
                        if (ServiceUtil.toLevel(v1) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v2 = (List)destination$iv$iv;
                    break block7;
                }
                if (!(value instanceof UReferenceExpression)) break block8;
                var3_2 = UastUtils.tryResolve((UElement)((UElement)value));
                if (var3_2 == null) ** GOTO lbl-1000
                it = var3_2;
                $i$a$-let-ServiceUtil$getLevelType$levels$4 = false;
                it = var6_5 /* !! */  = (PsiField)it;
                $i$a$-takeIf-ServiceUtil$getLevelType$levels$5 = false;
                v3 = it.getContainingClass();
                v4 /* !! */  = var5_4 = Intrinsics.areEqual((Object)(v3 != null ? v3.getQualifiedName() : null), (Object)Service.Level.class.getCanonicalName()) != false ? var6_5 /* !! */  : null;
                if (var5_4 == null || (var6_5 /* !! */  = var5_4.getName()) == null) ** GOTO lbl-1000
                it /* !! */  = var6_5 /* !! */ ;
                $i$a$-let-ServiceUtil$getLevelType$levels$6 = false;
                v5 = level = ServiceUtil.toLevel((String)it /* !! */ );
                var7_8 = v5 == null ? SetsKt.emptySet() : SetsKt.setOf((Object)v5);
                if (var7_8 != null) {
                    v2 = var7_8;
                } else lbl-1000:
                // 3 sources

                {
                    v2 = SetsKt.emptySet();
                }
                break block7;
            }
            v2 = SetsKt.emptySet();
        }
        levels = v2;
        return ServiceUtil.toLevelType(levels);
    }

    private static final LevelType toLevelType(Collection<? extends Service.Level> levels) {
        Object[] objectArray = new Service.Level[]{Service.Level.APP, Service.Level.PROJECT};
        return levels.containsAll(SetsKt.setOf((Object[])objectArray)) ? LevelType.APP_AND_PROJECT : (levels.contains(Service.Level.APP) ? LevelType.APP : (levels.contains(Service.Level.PROJECT) ? LevelType.PROJECT : LevelType.NOT_SPECIFIED));
    }

    @Nullable
    public static final Service.Level toLevel(@NotNull String name) {
        Service.Level level;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            level = Service.Level.valueOf((String)name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            level = null;
        }
        return level;
    }

    public static final boolean isLightService(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        String string = Service.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Service::class.java.canonicalName");
        return uClass.findAnnotation(string) != null;
    }
}

