/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.ProjectProductionScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.ExtensionPointUsageAnalyzerKt;
import org.jetbrains.idea.devkit.inspections.Leak;
import org.jetbrains.idea.devkit.inspections.QualifiedCall;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010#\u001a\u00020\u0017H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010%\u001a\u00020\u0012H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0005H\u0002J \u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u0010.\u001a\u00020)2\b\b\u0001\u0010,\u001a\u00020\u0005H\u0002J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\b\u00100\u001a\u0004\u0018\u0001012\b\b\u0001\u0010,\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000fH\u0002J\u0010\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u00020\u00072\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020\u0007H\u0002R\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001f0\u001e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019\u00a8\u0006F"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LeakSearchContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "epName", "", "ignoreSafeClasses", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Z)V", "ANONYMOUS_PASS_THROUGH", "", "SAFE_CLASSES", "", "classSafe", "", "Lcom/intellij/psi/PsiClass;", "processedObjects", "", "Lorg/jetbrains/uast/UExpression;", "getProject", "()Lcom/intellij/openapi/project/Project;", "safeUsages", "", "Lcom/intellij/psi/PsiReference;", "getSafeUsages", "()Ljava/util/List;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "unsafeUsages", "Lkotlin/Pair;", "Lorg/jetbrains/idea/devkit/inspections/Leak;", "getUnsafeUsages", "analyzeEPUsage", "", "reference", "analyzeGetExtensionsCall", "fullExpression", "findEnclosingCall", "Lorg/jetbrains/uast/UCallExpression;", "expr", "Lorg/jetbrains/uast/UElement;", "findLeaksThroughCall", "call", "text", "findObjectLeaks", "e", "findVariableUsageLeaks", "variable", "Lorg/jetbrains/uast/UVariable;", "isConcreteExtension", "psiClass", "isSafeCall", "callee", "Lcom/intellij/psi/PsiMethod;", "isSafeClass", "resolveResult", "Lcom/intellij/psi/PsiClassType$ClassResolveResult;", "isSafeType", "type", "Lcom/intellij/psi/PsiType;", "processEPFieldUsages", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "resolveAnonymousClass", "Lorg/jetbrains/uast/UObjectLiteralExpression;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "tooManyObjects", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nExtensionPointUsageAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointUsageAnalyzer.kt\norg/jetbrains/idea/devkit/inspections/LeakSearchContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,683:1\n1855#2,2:684\n18#3:686\n18#3:687\n18#3:688\n18#3:691\n12744#4,2:689\n*S KotlinDebug\n*F\n+ 1 ExtensionPointUsageAnalyzer.kt\norg/jetbrains/idea/devkit/inspections/LeakSearchContext\n*L\n91#1:684,2\n151#1:686\n162#1:687\n164#1:688\n263#1:691\n220#1:689,2\n*E\n"})
public final class LeakSearchContext {
    @NotNull
    private final Project project;
    @Nullable
    private final String epName;
    private final boolean ignoreSafeClasses;
    @NonNls
    @NotNull
    private final Set<String> SAFE_CLASSES;
    @NonNls
    @NotNull
    private final Map<String, String> ANONYMOUS_PASS_THROUGH;
    @NotNull
    private final GlobalSearchScope searchScope;
    @NotNull
    private final Map<PsiClass, Boolean> classSafe;
    @NotNull
    private final Set<UExpression> processedObjects;
    @NotNull
    private final List<Pair<PsiReference, Leak>> unsafeUsages;
    @NotNull
    private final List<PsiReference> safeUsages;

    public LeakSearchContext(@NotNull Project project, @Nullable String epName, boolean ignoreSafeClasses) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.epName = epName;
        this.ignoreSafeClasses = ignoreSafeClasses;
        Object[] objectArray = new String[]{"java.lang.String", "javax.swing.Icon", "java.net.URL", "java.io.File", "java.net.URI", "com.intellij.openapi.vfs.pointers.VirtualFilePointer", "com.intellij.openapi.vfs.VirtualFile"};
        this.SAFE_CLASSES = SetsKt.setOf((Object[])objectArray);
        this.ANONYMOUS_PASS_THROUGH = MapsKt.mapOf((Pair)TuplesKt.to((Object)"com.intellij.openapi.util.NotNullLazyValue", (Object)"compute"));
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.filterScope((Project)this.project, (NamedScope)((NamedScope)ProjectProductionScope.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filterScope(project, Pro\u2026ProductionScope.INSTANCE)");
        this.searchScope = globalSearchScope;
        this.classSafe = new LinkedHashMap();
        this.processedObjects = new LinkedHashSet();
        this.unsafeUsages = new ArrayList();
        this.safeUsages = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Pair<PsiReference, Leak>> getUnsafeUsages() {
        return this.unsafeUsages;
    }

    @NotNull
    public final List<PsiReference> getSafeUsages() {
        return this.safeUsages;
    }

    public final void processEPFieldUsages(@NotNull PsiElement sourcePsi) {
        Intrinsics.checkNotNullParameter((Object)sourcePsi, (String)"sourcePsi");
        Query query = ReferencesSearch.search((PsiElement)sourcePsi);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(sourcePsi)");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiReference ref = (PsiReference)element$iv;
            boolean bl = false;
            List leaks2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends Leak>>(this, ref){
                final /* synthetic */ LeakSearchContext this$0;
                final /* synthetic */ PsiReference $ref;
                {
                    this.this$0 = $receiver;
                    this.$ref = $ref;
                    super(0);
                }

                @NotNull
                public final List<Leak> invoke() {
                    PsiReference psiReference = this.$ref;
                    Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"ref");
                    return LeakSearchContext.access$analyzeEPUsage(this.this$0, psiReference);
                }
            }));
            if (leaks2.isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
                this.safeUsages.add(ref);
                continue;
            }
            for (Leak leak : leaks2) {
                this.unsafeUsages.add((Pair<PsiReference, Leak>)TuplesKt.to((Object)ref, (Object)leak));
            }
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
        if (statusBar != null) {
            statusBar.setInfo("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Leak> analyzeEPUsage(PsiReference reference) {
        UElement parent;
        PsiFile containingFile = reference.getElement().getContainingFile();
        String string = FileUtil.getNameWithoutExtension((String)containingFile.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(containingFile.name)");
        String containingFileName = string;
        if (StringsKt.endsWith$default((String)containingFileName, (String)"CoreEnvironment", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)containingFileName, (String)"CoreApplicationEnvironment", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        if (ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex().isInTestSourceContent(containingFile.getVirtualFile())) {
            return CollectionsKt.emptyList();
        }
        Class[] classArray = new Class[]{PsiComment.class};
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)reference.getElement(), (Class[])classArray) != null) {
            return CollectionsKt.emptyList();
        }
        UElement element = UastContextKt.toUElement((PsiElement)reference.getElement());
        QualifiedCall qualifiedCall = ExtensionPointUsageAnalyzerKt.access$findQualifiedCall(element);
        if (qualifiedCall != null) {
            String methodName = qualifiedCall.getCallExpression().getMethodName();
            if (methodName != null) {
                switch (methodName.hashCode()) {
                    case -1077331232: {
                        if (methodName.equals("allForLanguage")) return this.analyzeGetExtensionsCall(qualifiedCall.getFullExpression());
                        break;
                    }
                    case -2107169782: {
                        if (methodName.equals("getExtensions")) return this.analyzeGetExtensionsCall(qualifiedCall.getFullExpression());
                        break;
                    }
                    case 545965511: {
                        if (!methodName.equals("getExtensionList")) break;
                        return this.analyzeGetExtensionsCall(qualifiedCall.getFullExpression());
                    }
                }
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"findExtension") || Intrinsics.areEqual((Object)methodName, (Object)"forLanguage")) {
                UElement uElement = (UElement)qualifiedCall.getCallExpression();
                String string2 = DevKitBundle.message("extension.point.analyzer.reason.extension.instance", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"extension.point\u2026ason.extension.instance\")");
                return this.findObjectLeaks(uElement, string2);
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"getName")) {
                return CollectionsKt.emptyList();
            }
        }
        UElement uElement = element;
        Object object = parent = uElement != null ? uElement.getUastParent() : null;
        while (parent instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)parent).getSelector(), (Object)element)) {
            parent = ((UQualifiedReferenceExpression)parent).getUastParent();
        }
        if (parent instanceof UQualifiedReferenceExpression) {
            String name;
            UElement uElement2 = ((UQualifiedReferenceExpression)parent).getReferenceNameElement();
            UIdentifier uIdentifier = uElement2 instanceof UIdentifier ? (UIdentifier)uElement2 : null;
            String string3 = name = uIdentifier != null ? uIdentifier.getName() : null;
            if (Intrinsics.areEqual((Object)name, (Object)"extensions") || Intrinsics.areEqual((Object)name, (Object)"extensionList")) {
                return this.analyzeGetExtensionsCall((UExpression)parent);
            }
        }
        String string4 = DevKitBundle.message("extension.point.analyzer.reason.unknown.usage", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"extension.point\u2026er.reason.unknown.usage\")");
        return CollectionsKt.listOf((Object)new Leak(string4, reference.getElement()));
    }

    private final List<Leak> analyzeGetExtensionsCall(UExpression fullExpression) {
        UElement $this$getParentOfType_u24default$iv = (UElement)fullExpression;
        boolean strict$iv = true;
        UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
        boolean $i$f$getParentOfType = false;
        UForEachExpression loop = (UForEachExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UForEachExpression.class, (boolean)strict$iv);
        if (loop != null) {
            if (!Intrinsics.areEqual((Object)fullExpression, (Object)loop.getIteratedValue())) {
                String string = DevKitBundle.message("extension.point.analyzer.reason.call.not.loop.value", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026son.call.not.loop.value\")");
                return CollectionsKt.listOf((Object)new Leak(string, fullExpression.getSourcePsi()));
            }
            UVariable uVariable = (UVariable)loop.getVariable();
            String string = DevKitBundle.message("extension.point.analyzer.reason.extension.instance", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026ason.extension.instance\")");
            return this.findVariableUsageLeaks(uVariable, string);
        }
        UElement uElement = (UElement)fullExpression;
        String string = DevKitBundle.message("extension.point.analyzer.reason.extension.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026r.reason.extension.list\")");
        return this.findObjectLeaks(uElement, string);
    }

    private final UCallExpression findEnclosingCall(UElement expr) {
        UQualifiedReferenceExpression qualifiedExpression;
        UCallExpression call;
        UElement uElement = expr;
        if (uElement != null) {
            UElement $this$getParentOfType_u24default$iv = uElement;
            boolean strict$iv = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            v1 = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UCallExpression.class, (boolean)strict$iv);
        } else {
            v1 = call = null;
        }
        if (call != null && CollectionsKt.contains((Iterable)call.getValueArguments(), (Object)expr)) {
            return call;
        }
        UElement uElement2 = expr;
        if (uElement2 != null) {
            UElement $this$getParentOfType_u24default$iv = uElement2;
            boolean strict$iv = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            v3 = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
        } else {
            v3 = qualifiedExpression = null;
        }
        if (qualifiedExpression != null && Intrinsics.areEqual((Object)qualifiedExpression.getReceiver(), (Object)expr)) {
            UExpression uExpression = qualifiedExpression.getSelector();
            return uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
        }
        return null;
    }

    private final List<Leak> findLeaksThroughCall(UCallExpression call, String text) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            String string = DevKitBundle.message("extension.point.analyzer.reason.unresolved.method.call", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026.unresolved.method.call\")");
            return CollectionsKt.listOf((Object)new Leak(string, call.getSourcePsi()));
        }
        PsiMethod callee = psiMethod;
        if (this.isSafeCall(callee)) {
            PsiType type = call.getReturnType();
            if (type == null || this.isSafeType(type)) {
                return CollectionsKt.emptyList();
            }
            UElement uElement = (UElement)call;
            Object[] objectArray = new Object[]{text, callee.getName(), type.getPresentableText()};
            String string = DevKitBundle.message("extension.point.analyzer.reason.return.value", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026me, type.presentableText)");
            return this.findObjectLeaks(uElement, string);
        }
        Object[] objectArray = new Object[]{text};
        String string = DevKitBundle.message("extension.point.analyzer.reason.impure.method", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026son.impure.method\", text)");
        return CollectionsKt.listOf((Object)new Leak(string, call.getSourcePsi()));
    }

    private final boolean isSafeCall(PsiMethod callee) {
        if (JavaMethodContractUtil.isPure((PsiMethod)callee)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)callee.getName(), (Object)"getValue")) {
            PsiClass psiClass = callee.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"com.intellij.openapi.util.NotNullLazyValue")) {
                return true;
            }
        }
        if (Intrinsics.areEqual((Object)callee.getName(), (Object)"get")) {
            PsiClass psiClass = callee.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.util.Map")) {
                return true;
            }
        }
        return false;
    }

    private final boolean isSafeType(PsiType type) {
        boolean bl;
        if (!this.ignoreSafeClasses) {
            return false;
        }
        PsiType psiType = type;
        if (psiType == null) {
            bl = false;
        } else if (psiType instanceof PsiPrimitiveType) {
            bl = true;
        } else if (psiType instanceof PsiArrayType) {
            bl = this.isSafeType(((PsiArrayType)type).getDeepComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
            Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"type.resolveGenerics()");
            PsiClassType.ClassResolveResult resolveResult = classResolveResult;
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            Boolean safe = this.classSafe.putIfAbsent(psiClass2, true);
            if (safe == null) {
                safe = this.isSafeClass(resolveResult);
                this.classSafe.put(psiClass2, safe);
            }
            bl = safe;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isSafeClass(PsiClassType.ClassResolveResult resolveResult) {
        boolean bl;
        block12: {
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"resolveResult.substitutor");
            PsiSubstitutor substitutor = psiSubstitutor;
            if (CollectionsKt.contains((Iterable)this.SAFE_CLASSES, (Object)psiClass2.getQualifiedName())) {
                bl = true;
            } else if (psiClass2.isEnum()) {
                bl = true;
            } else if (InheritanceUtil.isInheritor((PsiClass)psiClass2, (String)"com.intellij.psi.PsiElement")) {
                bl = true;
            } else if (this.isConcreteExtension(psiClass2)) {
                bl = true;
            } else if (psiClass2.hasModifierProperty("final")) {
                PsiField[] psiFieldArray = psiClass2.getAllFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"psiClass.allFields");
                Object[] $this$any$iv = psiFieldArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiField f = (PsiField)element$iv;
                    boolean bl2 = false;
                    if (!this.isSafeType(substitutor.substitute(f.getType()))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isConcreteExtension(PsiClass psiClass) {
        if (this.epName == null) {
            return false;
        }
        ExtensionCandidate extensionCandidate = (ExtensionCandidate)ContainerUtil.getOnlyItem((Collection)ExtensionLocatorKt.locateExtensionsByPsiClass(psiClass));
        if (extensionCandidate == null || (extensionCandidate = extensionCandidate.pointer) == null || (extensionCandidate = (XmlTag)extensionCandidate.getElement()) == null) {
            return false;
        }
        ExtensionCandidate extension = extensionCandidate;
        DomElement domElement = DomManager.getDomManager((Project)this.project).getDomElement((XmlTag)extension);
        Extension extensionTag = domElement instanceof Extension ? (Extension)domElement : null;
        Object object = extensionTag;
        if (object == null || (object = object.getExtensionPoint()) == null) {
            return false;
        }
        Object extensionPoint = object;
        if (!Intrinsics.areEqual((Object)extensionPoint.getEffectiveQualifiedName(), (Object)this.epName)) {
            return false;
        }
        PsiClass effectiveClass = extensionPoint.getEffectiveClass();
        return effectiveClass != null && psiClass.isInheritor(effectiveClass, true);
    }

    private final List<Leak> findObjectLeaks(UElement e, @Nls String text) {
        Object[] objectArray;
        PsiElement targetElement = e.getSourcePsi();
        if (e instanceof UExpression && targetElement != null) {
            UElement jumpTarget;
            UElement target;
            UElement target2;
            UExpression leftOperand;
            UCallExpression call;
            if (!this.processedObjects.add((UExpression)e)) {
                return CollectionsKt.emptyList();
            }
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.project);
            if (statusBar != null) {
                objectArray = new Object[]{StringUtil.shortenTextWithEllipsis((String)targetElement.getText(), (int)50, (int)5), this.processedObjects.size()};
                statusBar.setInfo(DevKitBundle.message("extension.point.analyzer.analyze.status.bar.info", objectArray));
            }
            if (this.tooManyObjects()) {
                String string = DevKitBundle.message("extension.point.analyzer.reason.too.many.visited.objects", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026oo.many.visited.objects\")");
                return CollectionsKt.listOf((Object)new Leak(string, targetElement));
            }
            PsiType type = ((UExpression)e).getExpressionType();
            if (this.isSafeType(type)) {
                return CollectionsKt.emptyList();
            }
            UElement parent = e.getUastParent();
            if (parent instanceof UParenthesizedExpression || parent instanceof UIfExpression || parent instanceof UBinaryExpressionWithType || parent instanceof UUnaryExpression || e instanceof UCallExpression && parent instanceof UQualifiedReferenceExpression) {
                return this.findObjectLeaks(parent, text);
            }
            if (parent instanceof UPolyadicExpression && !Intrinsics.areEqual((Object)((UPolyadicExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                return CollectionsKt.emptyList();
            }
            if (parent instanceof UForEachExpression && Intrinsics.areEqual((Object)((UForEachExpression)parent).getIteratedValue(), (Object)e)) {
                UVariable uVariable = (UVariable)((UForEachExpression)parent).getVariable();
                Object[] objectArray2 = new Object[]{text};
                String string = DevKitBundle.message("extension.point.analyzer.reason.element.of", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026reason.element.of\", text)");
                return this.findVariableUsageLeaks(uVariable, string);
            }
            if (parent instanceof USwitchClauseExpression) {
                UElement $this$getParentOfType_u24default$iv = parent;
                boolean strict$iv = true;
                UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
                boolean $i$f$getParentOfType = false;
                USwitchExpression switchExpr = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, USwitchExpression.class, (boolean)strict$iv);
                if (switchExpr != null) {
                    return this.findObjectLeaks((UElement)switchExpr, text);
                }
            }
            if ((call = this.findEnclosingCall(e)) != null) {
                return this.findLeaksThroughCall(call, text);
            }
            if (parent instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN) && (leftOperand = ((UBinaryExpression)parent).getLeftOperand()) instanceof USimpleNameReferenceExpression && (target2 = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)leftOperand))) instanceof ULocalVariable) {
                return this.findVariableUsageLeaks((UVariable)target2, text);
            }
            if (parent instanceof ULocalVariable) {
                return this.findVariableUsageLeaks((UVariable)parent, text);
            }
            if (parent instanceof UQualifiedReferenceExpression && (target = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)parent))) instanceof UField) {
                return this.findObjectLeaks(parent, text);
            }
            if (parent instanceof UReturnExpression && (jumpTarget = ((UReturnExpression)parent).getJumpTarget()) instanceof UMethod) {
                UObjectLiteralExpression target3 = this.resolveAnonymousClass((UMethod)jumpTarget);
                if (target3 != null) {
                    return this.findObjectLeaks((UElement)target3, text);
                }
                PsiMethod psiMethod = ((UMethod)jumpTarget).getJavaPsi();
                if (Intrinsics.areEqual((Object)psiMethod.getName(), (Object)"getInstance")) {
                    String string = DevKitBundle.message("extension.point.analyzer.reason.get.instance.method.skipped", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026instance.method.skipped\")");
                    return CollectionsKt.listOf((Object)new Leak(string, ((UReturnExpression)parent).getSourcePsi()));
                }
                Set methodsToFind = new LinkedHashSet();
                methodsToFind.add(psiMethod);
                PsiMethod[] psiMethodArray = psiMethod.findDeepestSuperMethods();
                ContainerUtil.addAll((Collection)methodsToFind, (Object[])Arrays.copyOf(psiMethodArray, psiMethodArray.length));
                List result = new ArrayList();
                for (PsiMethod methodToFind : methodsToFind) {
                    MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)((SearchScope)this.searchScope), (boolean)true).forEach(arg_0 -> LeakSearchContext.findObjectLeaks$lambda$2(result, this, text, psiMethod, arg_0));
                }
                if (!((Collection)result).isEmpty()) {
                    Object[] objectArray3 = new Object[]{text, psiMethod.getName()};
                    String string = DevKitBundle.message("extension.point.analyzer.reason.leak.returned.from.method", objectArray3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026d\", text, psiMethod.name)");
                    result.add(0, new Leak(string, ((UReturnExpression)parent).getSourcePsi()));
                }
                return result;
            }
        }
        objectArray = new Object[]{text};
        String string = DevKitBundle.message("extension.point.analyzer.reason.unknown.usage.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026nknown.usage.text\", text)");
        PsiElement psiElement = targetElement;
        return CollectionsKt.listOf((Object)new Leak(string, (PsiElement)(psiElement != null ? psiElement.getParent() : null)));
    }

    private final UObjectLiteralExpression resolveAnonymousClass(UMethod uMethod) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
        if (uClass == null) {
            return null;
        }
        UClass uClass2 = uClass;
        UElement uElement = uClass2.getUastParent();
        UObjectLiteralExpression uObjectLiteralExpression = uElement instanceof UObjectLiteralExpression ? (UObjectLiteralExpression)uElement : null;
        if (uObjectLiteralExpression == null) {
            return null;
        }
        UObjectLiteralExpression anonymous = uObjectLiteralExpression;
        UTypeReferenceExpression uTypeReferenceExpression = (UTypeReferenceExpression)ContainerUtil.getOnlyItem((Collection)uClass2.getUastSuperTypes());
        if (uTypeReferenceExpression == null) {
            return null;
        }
        UTypeReferenceExpression onlySuperType = uTypeReferenceExpression;
        String methodName = this.ANONYMOUS_PASS_THROUGH.get(onlySuperType.getQualifiedName());
        return Intrinsics.areEqual((Object)uMethod.getName(), (Object)methodName) ? anonymous : null;
    }

    private final boolean tooManyObjects() {
        return this.processedObjects.size() > 500;
    }

    private final List<Leak> findVariableUsageLeaks(UVariable variable, @Nls String text) {
        if (variable == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement sourcePsi = variable.getSourcePsi();
        if (sourcePsi == null) {
            Object[] objectArray = new Object[]{text};
            String string = DevKitBundle.message("extension.point.analyzer.reason.uast.no.source.psi", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026ast.no.source.psi\", text)");
            return CollectionsKt.listOf((Object)new Leak(string, null));
        }
        List leaks2 = new ArrayList();
        ReferencesSearch.search((PsiElement)sourcePsi, (SearchScope)sourcePsi.getUseScope()).forEach(arg_0 -> LeakSearchContext.findVariableUsageLeaks$lambda$3(leaks2, this, text, arg_0));
        return leaks2;
    }

    private static final boolean findObjectLeaks$lambda$2(List $result, LeakSearchContext this$0, String $text, PsiMethod $psiMethod, PsiReference ref) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$psiMethod, (String)"$psiMethod");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        PsiElement psiElement = ref.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ref.element");
        PsiElement element = psiElement;
        UElement uElement = UastContextKt.toUElement((PsiElement)element);
        if (uElement instanceof UReferenceExpression) {
            UElement uParent;
            PsiElement psiElement2 = element.getParent();
            Object object = uParent = psiElement2 != null ? UastContextKt.toUElement((PsiElement)psiElement2) : null;
            if (uParent instanceof UCallExpression) {
                uElement = uParent;
            } else {
                UCallExpression maybeCall;
                UQualifiedReferenceExpression uQualifiedReferenceExpression = uParent instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uParent : null;
                UExpression uExpression = uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getSelector() : null;
                UCallExpression uCallExpression = maybeCall = uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
                if (maybeCall != null) {
                    uElement = (UElement)maybeCall;
                }
            }
        }
        if (uElement != null) {
            Object[] objectArray = new Object[]{$text, $psiMethod.getName()};
            String string = DevKitBundle.message("extension.point.analyzer.reason.returned.from.method", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"extension.point\u2026d\", text, psiMethod.name)");
            $result.addAll((Collection)this$0.findObjectLeaks(uElement, string));
        }
        return !this$0.tooManyObjects();
    }

    private static final boolean findVariableUsageLeaks$lambda$3(List $leaks, LeakSearchContext this$0, String $text, PsiReference psiReference) {
        Intrinsics.checkNotNullParameter((Object)$leaks, (String)"$leaks");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        UElement ref = UastContextKt.toUElement((PsiElement)psiReference.getElement());
        if (ref != null) {
            $leaks.addAll((Collection)this$0.findObjectLeaks(ref, $text));
        }
        return !this$0.tooManyObjects();
    }

    public static final /* synthetic */ List access$analyzeEPUsage(LeakSearchContext $this, PsiReference reference) {
        return $this.analyzeEPUsage(reference);
    }
}

