/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.commit;

import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitSharedSettings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.commit.DevKitGitBundle;
import org.jetbrains.idea.devkit.commit.IssueIDPrePushHandler;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\tH\u0016J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u000fH&J\u0014\u0010&\u001a\u00020\u000f*\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\u000f*\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006+"}, d2={"Lorg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler;", "Lcom/intellij/dvcs/push/PrePushHandler;", "()V", "commitMessageRegex", "Lkotlin/text/Regex;", "getCommitMessageRegex", "()Lkotlin/text/Regex;", "paths", "", "", "getPaths", "()Ljava/util/List;", "pathsToIgnore", "getPathsToIgnore", "breaksKotlinPluginMessageRules", "", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "commitMessageIsCorrect", "message", "commitMessageIsCorrect$intellij_devkit_git", "containSources", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "containSources$intellij_devkit_git", "getPresentableName", "handle", "Lcom/intellij/dvcs/push/PrePushHandler$Result;", "project", "Lcom/intellij/openapi/project/Project;", "pushDetails", "", "Lcom/intellij/dvcs/push/PushInfo;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handlerIsApplicable", "isAvailable", "hasCommitsToEdit", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "isTargetBranchProtected", "Companion", "intellij.devkit.git"})
@SourceDebugExtension(value={"SMAP\nIssueIDPrePushHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueIDPrePushHandler.kt\norg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1229#2:92\n1230#2:99\n1747#3,3:93\n2624#3,3:96\n1747#3,3:100\n1603#3,9:103\n1855#3:112\n1856#3:114\n1612#3:115\n1#4:113\n*S KotlinDebug\n*F\n+ 1 IssueIDPrePushHandler.kt\norg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler\n*L\n30#1:92\n30#1:99\n33#1:93,3\n34#1:96,3\n55#1:100,3\n90#1:103,9\n90#1:112\n90#1:114\n90#1:115\n90#1:113\n*E\n"})
public abstract class IssueIDPrePushHandler
implements PrePushHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> pathsToIgnore;
    @NotNull
    private static final Set<String> fileExtensionsNotToTrack;

    public IssueIDPrePushHandler() {
        Object[] objectArray = new String[]{"/test/", "/testData/"};
        this.pathsToIgnore = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public abstract List<String> getPaths();

    @NotNull
    public List<String> getPathsToIgnore() {
        return this.pathsToIgnore;
    }

    @NotNull
    public abstract Regex getCommitMessageRegex();

    public abstract boolean isAvailable();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containSources$intellij_devkit_git(@NotNull Collection<? extends VirtualFile> files) {
        boolean bl;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Sequence $this$any$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)containSources.1.INSTANCE);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Path path = (Path)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            String siPath = PathKt.getSystemIndependentPath((Path)path);
            if (!fileExtensionsNotToTrack.contains(PathsKt.getExtension((Path)path))) {
                String it;
                boolean bl3;
                block9: {
                    Iterable $this$any$iv2 = this.getPaths();
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv2) {
                            it = (String)element$iv2;
                            boolean bl4 = false;
                            if (!StringsKt.contains$default((CharSequence)siPath, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    Iterable $this$none$iv = this.getPathsToIgnore();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        return true;
                    }
                    Iterator iterator2 = $this$none$iv.iterator();
                    do {
                        Object element$iv2;
                        if (!iterator2.hasNext()) return true;
                        element$iv2 = iterator2.next();
                        it = (String)element$iv2;
                        boolean bl5 = false;
                    } while (!StringsKt.contains$default((CharSequence)siPath, (CharSequence)it, (boolean)false, (int)2, null));
                    boolean bl6 = false;
                    if (bl6) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean commitMessageIsCorrect$intellij_devkit_git(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CharSequence charSequence = message;
        return this.getCommitMessageRegex().matches(charSequence);
    }

    private final boolean handlerIsApplicable(Project project) {
        return this.isAvailable() && PsiUtil.isIdeaProject(project);
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitGitBundle.message("push.commit.handler.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"push.commit.handler.name\")");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public PrePushHandler.Result handle(@NotNull Project project, @NotNull List<PushInfo> pushDetails, @NotNull ProgressIndicator indicator) {
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(pushDetails, (String)"pushDetails");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!this.handlerIsApplicable(project)) {
                    return PrePushHandler.Result.OK;
                }
                $this$any$iv = pushDetails;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block5;
                v0 = false;
                break block4;
            }
            for (T element$iv : $this$any$iv) {
                it = (PushInfo)element$iv;
                $i$a$-any-IssueIDPrePushHandler$handle$1 = false;
                if (!this.isTargetBranchProtected(it, project)) ** GOTO lbl-1000
                v1 = indicator.getModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"indicator.modalityState");
                if (this.hasCommitsToEdit(it, v1)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v0 = true;
                break block4;
            }
            v0 = false;
        }
        return v0 != false ? PrePushHandler.Result.ABORT_AND_CLOSE : PrePushHandler.Result.OK;
    }

    private final boolean isTargetBranchProtected(PushInfo $this$isTargetBranchProtected, Project project) {
        return GitSharedSettings.getInstance((Project)project).isBranchProtected($this$isTargetBranchProtected.getPushSpec().getTarget().getPresentation());
    }

    private final boolean hasCommitsToEdit(PushInfo $this$hasCommitsToEdit, ModalityState modalityState) {
        List list = $this$hasCommitsToEdit.getCommits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commits");
        List commitsToWarnAbout2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VcsFullCommitDetails, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull VcsFullCommitDetails p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return IssueIDPrePushHandler.access$breaksKotlinPluginMessageRules((IssueIDPrePushHandler)this.receiver, p0);
            }
        })), (Function1)hasCommitsToEdit.commitsToWarnAbout.2.INSTANCE));
        if (commitsToWarnAbout2.isEmpty()) {
            return false;
        }
        String commitsInfo2 = CollectionsKt.joinToString$default((Iterable)commitsToWarnAbout2, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)hasCommitsToEdit.commitsInfo.1.INSTANCE, (int)30, null);
        boolean commitAsIs2 = (Boolean)IssueIDPrePushHandler.Companion.invokeAndWait(modalityState, (Function0)new Function0<Boolean>(commitsInfo2){
            final /* synthetic */ String $commitsInfo;
            {
                this.$commitsInfo = $commitsInfo;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String string = DevKitGitBundle.message("push.commit.message.lacks.issue.reference.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"push.commit.mes\u2026s.issue.reference.title\")");
                Object[] objectArray = new Object[]{this.$commitsInfo};
                String string2 = DevKitGitBundle.message("push.commit.message.lacks.issue.reference.body", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"push.commit.mes\u2026rence.body\", commitsInfo)");
                MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, string2);
                String string3 = DevKitGitBundle.message("push.commit.message.lacks.issue.reference.commit", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"push.commit.mes\u2026.issue.reference.commit\")");
                MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
                String string4 = DevKitGitBundle.message("push.commit.message.lacks.issue.reference.edit", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"push.commit.mes\u2026ks.issue.reference.edit\")");
                return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).asWarning()).ask(null);
            }
        });
        return !commitAsIs2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean breaksKotlinPluginMessageRules(VcsFullCommitDetails commit) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection = commit.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"commit.changes");
        Iterable iterable = collection;
        IssueIDPrePushHandler issueIDPrePushHandler = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Change it = (Change)element$iv$iv;
            boolean bl2 = false;
            if (it.getVirtualFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        if (!issueIDPrePushHandler.containSources$intellij_devkit_git((List)destination$iv$iv)) return false;
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.fullMessage");
        if (this.commitMessageIsCorrect$intellij_devkit_git(string)) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$breaksKotlinPluginMessageRules(IssueIDPrePushHandler $this, VcsFullCommitDetails commit) {
        return $this.breaksKotlinPluginMessageRules(commit);
    }

    static {
        Object[] objectArray = new String[]{"iml", "md"};
        fileExtensionsNotToTrack = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/commit/IssueIDPrePushHandler$Companion;", "", "()V", "fileExtensionsNotToTrack", "", "", "invokeAndWait", "T", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "computable", "Lkotlin/Function0;", "(Lcom/intellij/openapi/application/ModalityState;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.devkit.git"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T invokeAndWait(ModalityState modalityState, Function0<? extends T> computable) {
            AtomicReference ref = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> Companion.invokeAndWait$lambda$0(ref, computable), modalityState);
            return (T)ref.get();
        }

        private static final void invokeAndWait$lambda$0(AtomicReference $ref, Function0 $computable) {
            Intrinsics.checkNotNullParameter((Object)$ref, (String)"$ref");
            Intrinsics.checkNotNullParameter((Object)$computable, (String)"$computable");
            $ref.set($computable.invoke());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

