/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.io.Compressor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginDescriptorConstants;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PrepareToDeployAction
extends AnAction {
    @NonNls
    private static final String ZIP_EXTENSION = ".zip";
    @NonNls
    private static final String JAR_EXTENSION = ".jar";
    @NonNls
    private static final String TEMP_PREFIX = "temp";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            PrepareToDeployAction.$$$reportNull$$$0(0);
        }
        if ((module = (Module)e.getData(PlatformCoreDataKeys.MODULE)) != null && PluginModuleType.isOfType(module)) {
            this.doPrepare(Collections.singletonList(module), e.getProject());
        }
    }

    public void doPrepare(final List<Module> pluginModules, final Project project) {
        final ArrayList errorMessages = new ArrayList();
        final ArrayList successMessages = new ArrayList();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(pluginModules.toArray(Module.EMPTY_ARRAY), true);
        compilerManager.make(scope, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                if (compileContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (aborted || errors != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (Module module : pluginModules) {
                        if (PrepareToDeployAction.doPrepare(module, errorMessages, successMessages)) continue;
                        return;
                    }
                    if (!errorMessages.isEmpty()) {
                        @NlsSafe String errorMessage = (String)errorMessages.iterator().next();
                        Messages.showErrorDialog((String)errorMessage, (String)DevKitBundle.message("error.occurred", new Object[0]));
                    } else if (!successMessages.isEmpty()) {
                        String title = pluginModules.size() == 1 ? DevKitBundle.message("success.deployment.message", ((Module)pluginModules.get(0)).getName()) : DevKitBundle.message("success.deployment.message.all", new Object[0]);
                        @NlsSafe String successMessage = StringUtil.join((Collection)successMessages, (String)"\n");
                        Holder.NOTIFICATION_GROUP.createNotification(title, successMessage, NotificationType.INFORMATION).notify(project);
                    }
                }, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "org/jetbrains/idea/devkit/build/PrepareToDeployAction$1", "finished"));
            }
        });
    }

    public static boolean doPrepare(Module module, List<String> errorMessages, List<String> successMessages) {
        String pluginName = module.getName();
        String defaultPath = new File(module.getModuleFilePath()).getParent() + File.separator + pluginName;
        HashSet<Module> modules = new HashSet<Module>();
        PluginBuildUtil.getDependencies(module, modules);
        modules.add(module);
        HashSet libs = new HashSet();
        for (Module dep : modules) {
            PluginBuildUtil.getLibraries(dep, libs);
        }
        Map<Module, String> jpsModules = PrepareToDeployAction.collectJpsPluginModules(module);
        modules.removeAll(jpsModules.keySet());
        boolean isZip = !libs.isEmpty() || !jpsModules.isEmpty();
        String oldPath = defaultPath + (isZip ? JAR_EXTENSION : ZIP_EXTENSION);
        File oldFile = new File(oldPath);
        if (oldFile.exists()) {
            String message = DevKitBundle.message("suggest.to.delete", oldPath);
            String title = DevKitBundle.message("info.message", new Object[0]);
            if (Messages.showYesNoDialog((Project)module.getProject(), (String)message, (String)title, (Icon)Messages.getInformationIcon()) == 0) {
                FileUtil.delete((File)oldFile);
            }
        }
        String dstPath = defaultPath + (isZip ? ZIP_EXTENSION : JAR_EXTENSION);
        File dstFile = new File(dstPath);
        return PrepareToDeployAction.clearReadOnly(module.getProject(), dstFile) && ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setText(DevKitBundle.message("prepare.for.deployment.task.progress", new Object[0]));
                progressIndicator.setIndeterminate(true);
            }
            try {
                File jarFile = PrepareToDeployAction.preparePluginsJar(module, modules);
                if (isZip) {
                    try {
                        PrepareToDeployAction.processLibrariesAndJpsPlugins(jarFile, dstFile, pluginName, libs, jpsModules);
                    }
                    finally {
                        FileUtil.delete((File)jarFile);
                    }
                } else {
                    FileUtil.rename((File)jarFile, (File)dstFile);
                }
                LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(dstFile), true, false, null);
                successMessages.add(DevKitBundle.message("saved.message", isZip ? 1 : 2, pluginName, dstPath));
            }
            catch (IOException e) {
                errorMessages.add(e.getMessage() + "\n(" + dstPath + ")");
            }
        }, DevKitBundle.message("prepare.for.deployment.task", pluginName), true, module.getProject());
    }

    @NotNull
    private static Map<Module, String> collectJpsPluginModules(@NotNull Module module) {
        XmlFile pluginXml;
        if (module == null) {
            PrepareToDeployAction.$$$reportNull$$$0(1);
        }
        if ((pluginXml = PluginModuleType.getPluginXml(module)) == null) {
            Map<Module, String> map = Collections.emptyMap();
            if (map == null) {
                PrepareToDeployAction.$$$reportNull$$$0(2);
            }
            return map;
        }
        IdeaPlugin plugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (plugin == null) {
            Map<Module, String> map = Collections.emptyMap();
            if (map == null) {
                PrepareToDeployAction.$$$reportNull$$$0(3);
            }
            return map;
        }
        HashMap<Module, String> jpsPluginToOutputPath = new HashMap<Module, String>();
        for (Extensions extensions : plugin.getExtensions()) {
            XmlTag extensionsTag = extensions.getXmlTag();
            String defaultExtensionNs = extensionsTag.getAttributeValue("defaultExtensionNs");
            for (XmlTag tag : extensionsTag.getSubTags()) {
                String classpath;
                String qualifiedName;
                String name = tag.getLocalName();
                String string = qualifiedName = defaultExtensionNs != null ? defaultExtensionNs + "." + name : name;
                if (!CompileServerPlugin.EP_NAME.getName().equals(qualifiedName) || (classpath = tag.getAttributeValue("classpath")) == null) continue;
                for (String path : StringUtil.split((String)classpath, (String)";")) {
                    String moduleName = FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)path));
                    Module jpsModule = ModuleManager.getInstance((Project)module.getProject()).findModuleByName(moduleName);
                    if (jpsModule == null) continue;
                    jpsPluginToOutputPath.put(jpsModule, path);
                }
            }
        }
        HashMap<Module, String> hashMap = jpsPluginToOutputPath;
        if (hashMap == null) {
            PrepareToDeployAction.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static boolean clearReadOnly(Project project, File dstFile) {
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)dstFile, (boolean)true);
        return vfile == null || !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singleton(vfile)).hasReadonlyFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLibrariesAndJpsPlugins(File jarFile, File zipFile, String pluginName, Set<Library> libs, Map<Module, String> jpsModules) throws IOException {
        if (FileUtil.ensureCanCreateFile((File)zipFile)) {
            try (Compressor.Zip zip = new Compressor.Zip(zipFile);){
                zip.addDirectory(PrepareToDeployAction.getZipPath(pluginName, ""));
                HashSet<String> usedFileNames = new HashSet<String>();
                String entryName = pluginName + JAR_EXTENSION;
                zip.addFile(PrepareToDeployAction.getZipPath(pluginName, entryName), jarFile);
                usedFileNames.add(entryName);
                for (Map.Entry<Module, String> entry : jpsModules.entrySet()) {
                    File jpsPluginJar = PrepareToDeployAction.jarModulesOutput(Collections.singleton(entry.getKey()), null, null);
                    try {
                        zip.addFile(PrepareToDeployAction.getZipPath(pluginName, entry.getValue()), jpsPluginJar);
                    }
                    finally {
                        FileUtil.delete((File)jpsPluginJar);
                    }
                }
                HashSet<VirtualFile> jarredVirtualFiles = new HashSet<VirtualFile>();
                for (Library library : libs) {
                    VirtualFile[] nativeRoots;
                    VirtualFile[] roots2;
                    for (VirtualFile libRoot : roots2 = library.getFiles(OrderRootType.CLASSES)) {
                        if (!jarredVirtualFiles.add(libRoot)) continue;
                        if (libRoot.getFileSystem() instanceof JarFileSystem) {
                            PrepareToDeployAction.addLibraryFile(libRoot, pluginName, (Compressor)zip, usedFileNames);
                            continue;
                        }
                        PrepareToDeployAction.makeAndAddLibraryJar(libRoot, pluginName, (Compressor)zip, usedFileNames, library.getName());
                    }
                    for (VirtualFile root : nativeRoots = library.getFiles(NativeLibraryOrderRootType.getInstance())) {
                        if (root.isDirectory()) continue;
                        PrepareToDeployAction.addLibraryFile(root, pluginName, (Compressor)zip, usedFileNames);
                    }
                }
            }
        }
    }

    @NonNls
    private static String getZipPath(String pluginName, String entryName) {
        return pluginName + "/lib/" + entryName;
    }

    private static void addLibraryFile(VirtualFile root, String pluginName, Compressor zip, Set<String> usedFileNames) throws IOException {
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
        String fileName = PrepareToDeployAction.getLibraryFileName(ioFile.getName(), usedFileNames, null);
        zip.addFile(PrepareToDeployAction.getZipPath(pluginName, fileName), ioFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeAndAddLibraryJar(VirtualFile root, String pluginName, Compressor zip, Set<String> usedJarNames, @Nullable String preferredName) throws IOException {
        File tempFile = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        try {
            try (Compressor.Zip tempZip = new Compressor.Zip(tempFile);){
                FileTypeManager manager = FileTypeManager.getInstance();
                tempZip.filter((entryName, file) -> !manager.isFileIgnored(PathUtil.getFileName((String)entryName)));
                tempZip.addDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            }
            String jarName = PrepareToDeployAction.getLibraryFileName(root.getName() + JAR_EXTENSION, usedJarNames, preferredName == null ? null : preferredName + JAR_EXTENSION);
            zip.addFile(PrepareToDeployAction.getZipPath(pluginName, jarName), tempFile);
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    private static String getLibraryFileName(String fileName, Set<String> usedFileNames, @Nullable String preferredName) {
        Object uniqueName;
        if (preferredName != null && !usedFileNames.contains(preferredName)) {
            uniqueName = preferredName;
        } else {
            uniqueName = fileName;
            if (usedFileNames.contains(uniqueName)) {
                int dotPos = ((String)uniqueName).lastIndexOf(46);
                String name = dotPos < 0 ? uniqueName : ((String)uniqueName).substring(0, dotPos);
                String ext = dotPos < 0 ? "" : ((String)uniqueName).substring(dotPos);
                int i = 0;
                while (usedFileNames.contains(uniqueName = name + ++i + ext)) {
                }
            }
        }
        usedFileNames.add((String)uniqueName);
        return uniqueName;
    }

    private static File preparePluginsJar(Module module, Set<Module> modules) throws IOException {
        PluginBuildConfiguration configuration = PluginBuildConfiguration.getInstance(module);
        Manifest manifest = PrepareToDeployAction.createOrFindManifest(configuration);
        return PrepareToDeployAction.jarModulesOutput(modules, manifest, configuration != null ? configuration.getPluginXmlPath() : null);
    }

    private static File jarModulesOutput(Set<Module> modules, @Nullable Manifest manifest, @Nullable String pluginXmlPath) throws IOException {
        File tempFile = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        try (Compressor.Jar jar = new Compressor.Jar(tempFile);){
            FileTypeManager manager = FileTypeManager.getInstance();
            HashSet uniqueEntries = new HashSet();
            jar.filter((entryName, file) -> !manager.isFileIgnored(PathUtil.getFileName((String)entryName)) && uniqueEntries.add(entryName));
            if (manifest != null) {
                jar.addManifest(manifest);
            }
            for (Module module : modules) {
                VirtualFile outputPath;
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                if (extension == null || (outputPath = extension.getCompilerOutputPath()) == null) continue;
                jar.addDirectory(outputPath.toNioPath());
            }
            if (pluginXmlPath != null) {
                jar.addFile(PluginDescriptorConstants.PLUGIN_XML_PATH, new File(pluginXmlPath));
            }
        }
        return tempFile;
    }

    public static Manifest createOrFindManifest(@Nullable PluginBuildConfiguration configuration) throws IOException {
        VirtualFile vManifest;
        Manifest manifest = new Manifest();
        if (configuration != null && configuration.isUseUserManifest() && (vManifest = configuration.getManifest()) != null) {
            try (BufferedInputStream in = new BufferedInputStream(vManifest.getInputStream());){
                manifest.read(in);
            }
        } else {
            ManifestBuilder.setGlobalAttributes((Attributes)manifest.getMainAttributes());
        }
        return manifest;
    }

    public void update(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            PrepareToDeployAction.$$$reportNull$$$0(5);
        }
        boolean enabled = (module = (Module)e.getData(PlatformCoreDataKeys.MODULE)) != null && PluginModuleType.isOfType(module);
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.messagePointer("prepare.for.deployment", module.getName()));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PrepareToDeployAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/build/PrepareToDeployAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/build/PrepareToDeployAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectJpsPluginModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectJpsPluginModules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Plugin DevKit Deployment");

        private Holder() {
        }
    }
}

