/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.common;

import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.IfBranch;
import com.intellij.debugger.streams.trace.dsl.Statement;
import com.intellij.debugger.streams.trace.dsl.StatementFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0013\u001a\u00020\u00142\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0016J)\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\u0002\b\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/common/IfBranchBase;", "Lcom/intellij/debugger/streams/trace/dsl/IfBranch;", "condition", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "thenBlock", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "statementFactory", "Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;", "(Lcom/intellij/debugger/streams/trace/dsl/Expression;Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;)V", "getCondition", "()Lcom/intellij/debugger/streams/trace/dsl/Expression;", "elseBlock", "Lcom/intellij/debugger/streams/trace/dsl/Statement;", "getElseBlock", "()Lcom/intellij/debugger/streams/trace/dsl/Statement;", "setElseBlock", "(Lcom/intellij/debugger/streams/trace/dsl/Statement;)V", "getThenBlock", "()Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "elseBranch", "", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "elseIfBranch", "intellij.java.debugger.streams"})
public abstract class IfBranchBase
implements IfBranch {
    @NotNull
    private final Expression condition;
    @NotNull
    private final CodeBlock thenBlock;
    @NotNull
    private final StatementFactory statementFactory;
    @Nullable
    private Statement elseBlock;

    public IfBranchBase(@NotNull Expression condition, @NotNull CodeBlock thenBlock, @NotNull StatementFactory statementFactory) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)thenBlock, (String)"thenBlock");
        Intrinsics.checkNotNullParameter((Object)statementFactory, (String)"statementFactory");
        this.condition = condition;
        this.thenBlock = thenBlock;
        this.statementFactory = statementFactory;
    }

    @NotNull
    protected final Expression getCondition() {
        return this.condition;
    }

    @NotNull
    protected final CodeBlock getThenBlock() {
        return this.thenBlock;
    }

    @Nullable
    protected final Statement getElseBlock() {
        return this.elseBlock;
    }

    protected final void setElseBlock(@Nullable Statement statement) {
        this.elseBlock = statement;
    }

    @Override
    public void elseBranch(@NotNull Function1<? super CodeBlock, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CodeBlock block = this.statementFactory.createEmptyCodeBlock();
        init.invoke((Object)block);
        this.elseBlock = block;
    }

    @Override
    @NotNull
    public IfBranch elseIfBranch(@NotNull Expression condition, @NotNull Function1<? super CodeBlock, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CodeBlock block = this.statementFactory.createEmptyCodeBlock();
        init.invoke((Object)block);
        IfBranch elseIfStatement = this.statementFactory.createIfBranch(condition, block);
        CompositeCodeBlock codeBlock = this.statementFactory.createEmptyCompositeCodeBlock();
        codeBlock.addStatement(elseIfStatement);
        this.elseBlock = codeBlock;
        return elseIfStatement;
    }
}

