/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GithubSettings;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J$\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "()V", "findLocalBranch", "", "repository", "Lgit4idea/repo/GitRepository;", "prRemote", "Lgit4idea/repo/GitRemote;", "isFork", "", "possibleBranchName", "findRemote", "httpUrl", "sshUrl", "getRemoteUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubGitHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubGitHelper.kt\norg/jetbrains/plugins/github/util/GithubGitHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n766#2:82\n857#2,2:83\n766#2:86\n857#2,2:87\n1#3:85\n*S KotlinDebug\n*F\n+ 1 GithubGitHelper.kt\norg/jetbrains/plugins/github/util/GithubGitHelper\n*L\n44#1:82\n44#1:83,2\n48#1:86\n48#1:87,2\n*E\n"})
public final class GithubGitHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        return this.getRemoteUrl(server, repoPath.getOwner(), repoPath.getRepository());
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        if (GithubSettings.getInstance().isCloneGitUsingSsh()) {
            String string2;
            String string3;
            String string4 = server.getHost();
            String string5 = server.getSuffix();
            if (string5 != null) {
                String string6 = string5.substring(1);
                string3 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string3 = string2 = null;
            }
            if (string3 == null) {
                string2 = "";
            }
            string = "git@" + string4 + ":" + string2 + "/" + user + "/" + repo + ".git";
        } else {
            String string7 = server.getHost();
            String string8 = server.getSuffix();
            if (string8 == null) {
                string8 = "";
            }
            string = "https://" + string7 + string8 + "/" + user + "/" + repo + ".git";
        }
        return string;
    }

    @Nullable
    public final GitRemote findRemote(@NotNull GitRepository repository, @Nullable String httpUrl, @Nullable String sshUrl) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Collection collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
            Iterable iterable = collection;
            for (Object t : iterable) {
                GitRemote it = (GitRemote)t;
                boolean bl = false;
                boolean bl2 = it.getFirstUrl() != null && (Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)httpUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)(httpUrl + ".git")) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)sshUrl) || Intrinsics.areEqual((Object)it.getFirstUrl(), (Object)(sshUrl + ".git")));
                if (!bl2) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String findLocalBranch(@NotNull GitRepository repository, @NotNull GitRemote prRemote, boolean isFork, @Nullable String possibleBranchName) {
        Object object;
        Object v7;
        List localBranchesWithTracking;
        block11: {
            List list;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)prRemote, (String)"prRemote");
            GitBranchesCollection $this$findLocalBranch_u24lambda_u244 = repository.getBranches();
            boolean bl = false;
            if (isFork) {
                void $this$filterTo$iv$iv;
                Collection collection = $this$findLocalBranch_u24lambda_u244.getLocalBranches();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"localBranches");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GitLocalBranch it = (GitLocalBranch)element$iv$iv;
                    boolean bl2 = false;
                    GitRemoteBranch gitRemoteBranch = it.findTrackedBranch(repository);
                    if (!Intrinsics.areEqual((Object)(gitRemoteBranch != null ? gitRemoteBranch.getRemote() : null), (Object)prRemote)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                void $this$filterTo$iv$iv;
                Object v4;
                block10: {
                    Collection collection = $this$findLocalBranch_u24lambda_u244.getRemoteBranches();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"remoteBranches");
                    destination$iv$iv = collection;
                    for (Object t : destination$iv$iv) {
                        GitRemoteBranch it = (GitRemoteBranch)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getNameForRemoteOperations(), (Object)possibleBranchName)) continue;
                        v4 = t;
                        break block10;
                    }
                    v4 = null;
                }
                GitRemoteBranch gitRemoteBranch = v4;
                if (gitRemoteBranch == null) {
                    return null;
                }
                GitRemoteBranch prRemoteBranch = gitRemoteBranch;
                Collection collection = $this$findLocalBranch_u24lambda_u244.getLocalBranches();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"localBranches");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GitLocalBranch it = (GitLocalBranch)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.findTrackedBranch(repository), (Object)prRemoteBranch)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            localBranchesWithTracking = list;
            Iterable iterable = localBranchesWithTracking;
            for (Object t : iterable) {
                GitLocalBranch it = (GitLocalBranch)t;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)possibleBranchName)) continue;
                v7 = t;
                break block11;
            }
            v7 = null;
        }
        if ((object = (GitLocalBranch)v7) == null || (object = object.getName()) == null) {
            if (!isFork) {
                GitLocalBranch gitLocalBranch = (GitLocalBranch)CollectionsKt.firstOrNull((List)localBranchesWithTracking);
                object = gitLocalBranch != null ? gitLocalBranch.getName() : null;
            } else {
                object = null;
            }
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubGitHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubGitHelper.kt\norg/jetbrains/plugins/github/util/GithubGitHelper$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,81:1\n43#2,3:82\n*S KotlinDebug\n*F\n+ 1 GithubGitHelper.kt\norg/jetbrains/plugins/github/util/GithubGitHelper$Companion\n*L\n78#1:82,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list = manager.getRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manager.repositories");
            List repositories = list;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            Class<GithubGitHelper> serviceClass$iv = GithubGitHelper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GithubGitHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

