/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.util.CollectionDelta;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRMetadataModel;
import org.jetbrains.plugins.github.ui.component.LabeledListPanelHandle;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory;", "", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRMetadataModel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRMetadataModel;Lcom/intellij/collaboration/ui/icon/IconsProvider;)V", "panel", "Ljavax/swing/JPanel;", "create", "Ljavax/swing/JComponent;", "createLabelLabel", "Lcom/intellij/ui/components/panels/Wrapper;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "createUserLabel", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "AssigneesListPanelHandle", "Companion", "LabelsListPanelHandle", "ReviewersListPanelHandle", "intellij.vcs.github"})
public final class GHPRMetadataPanelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GHPRMetadataModel model;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final JPanel panel;

    public GHPRMetadataPanelFactory(@NotNull GHPRMetadataModel model2, @NotNull IconsProvider<String> avatarIconsProvider) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        this.model = model2;
        this.avatarIconsProvider = avatarIconsProvider;
        this.panel = new JPanel(null);
    }

    @NotNull
    public final JComponent create() {
        JPanel jPanel;
        ReviewersListPanelHandle reviewersHandle = new ReviewersListPanelHandle();
        AssigneesListPanelHandle assigneesHandle = new AssigneesListPanelHandle();
        LabelsListPanelHandle labelsHandle = new LabelsListPanelHandle();
        JPanel $this$create_u24lambda_u240 = jPanel = this.panel;
        boolean bl = false;
        $this$create_u24lambda_u240.setOpaque(false);
        $this$create_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().fillX().gridGap("0", "0").insets("0", "0", "0", "0")));
        GHPRMetadataPanelFactory.Companion.addListPanel($this$create_u24lambda_u240, reviewersHandle);
        GHPRMetadataPanelFactory.Companion.addListPanel($this$create_u24lambda_u240, assigneesHandle);
        GHPRMetadataPanelFactory.Companion.addListPanel($this$create_u24lambda_u240, labelsHandle);
        return jPanel;
    }

    private final JLabel createUserLabel(GHPullRequestRequestedReviewer user) {
        JLabel jLabel;
        JLabel $this$createUserLabel_u24lambda_u241 = jLabel = new JLabel(user.getShortName(), this.avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 20), 2);
        boolean bl = false;
        $this$createUserLabel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)4, (int)5, (int)4, (int)5));
        return jLabel;
    }

    private final Wrapper createLabelLabel(GHLabel label) {
        Wrapper wrapper;
        Wrapper $this$createLabelLabel_u24lambda_u242 = wrapper = new Wrapper((JComponent)GHUIUtil.INSTANCE.createIssueLabelLabel(label));
        boolean bl = false;
        $this$createLabelLabel_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)6, (int)5));
        return wrapper;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory$AssigneesListPanelHandle;", "Lorg/jetbrains/plugins/github/ui/component/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory;)V", "adjust", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "delta", "Lcom/intellij/collaboration/util/CollectionDelta;", "getItemComponent", "Ljavax/swing/JLabel;", "item", "getItems", "", "showEditPopup", "parentComponent", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    private final class AssigneesListPanelHandle
    extends LabeledListPanelHandle<GHUser> {
        public AssigneesListPanelHandle() {
            GHPRMetadataModel gHPRMetadataModel = GHPRMetadataPanelFactory.this.model;
            String string = GithubBundle.message("pull.request.unassigned", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.unassigned\")");
            super(gHPRMetadataModel, string, GithubBundle.message("pull.request.assignees", new Object[0]) + ":");
        }

        @Override
        @NotNull
        public List<GHUser> getItems() {
            return this.getModel().getAssignees();
        }

        @NotNull
        public JLabel getItemComponent(@NotNull GHUser item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return GHPRMetadataPanelFactory.this.createUserLabel(item);
        }

        @Override
        @NotNull
        public CompletableFuture<CollectionDelta<GHUser>> showEditPopup(@NotNull JComponent parentComponent) {
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            return GHUIUtil.INSTANCE.showChooserPopup(parentComponent, GHUIUtil.SelectionPresenters.INSTANCE.Users((IconsProvider<String>)GHPRMetadataPanelFactory.this.avatarIconsProvider), this.getModel().getAssignees(), this.getModel().loadPotentialAssignees());
        }

        @Override
        @NotNull
        public CompletableFuture<Unit> adjust(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<GHUser> delta) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(delta, (String)"delta");
            return this.getModel().adjustAssignees(indicator, delta);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory$Companion;", "", "()V", "addListPanel", "", "panel", "Ljavax/swing/JPanel;", "handle", "Lorg/jetbrains/plugins/github/ui/component/LabeledListPanelHandle;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final void addListPanel(JPanel panel, LabeledListPanelHandle<?> handle) {
            panel.add((Component)handle.getLabel(), new CC().alignY("top").width(":" + handle.getPreferredLabelWidth() + "px:"));
            panel.add((Component)handle.getPanel(), new CC().minWidth("0").growX().pushX().wrap());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory$LabelsListPanelHandle;", "Lorg/jetbrains/plugins/github/ui/component/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory;)V", "adjust", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "delta", "Lcom/intellij/collaboration/util/CollectionDelta;", "getItemComponent", "Lcom/intellij/ui/components/panels/Wrapper;", "item", "getItems", "", "showEditPopup", "parentComponent", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    private final class LabelsListPanelHandle
    extends LabeledListPanelHandle<GHLabel> {
        public LabelsListPanelHandle() {
            GHPRMetadataModel gHPRMetadataModel = GHPRMetadataPanelFactory.this.model;
            String string = GithubBundle.message("pull.request.no.labels", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.no.labels\")");
            super(gHPRMetadataModel, string, GithubBundle.message("pull.request.labels", new Object[0]) + ":");
        }

        @Override
        @NotNull
        public List<GHLabel> getItems() {
            return this.getModel().getLabels();
        }

        @NotNull
        public Wrapper getItemComponent(@NotNull GHLabel item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return GHPRMetadataPanelFactory.this.createLabelLabel(item);
        }

        @Override
        @NotNull
        public CompletableFuture<CollectionDelta<GHLabel>> showEditPopup(@NotNull JComponent parentComponent) {
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            return GHUIUtil.INSTANCE.showChooserPopup(parentComponent, GHUIUtil.SelectionPresenters.INSTANCE.Labels(), this.getModel().getLabels(), this.getModel().loadAssignableLabels());
        }

        @Override
        @NotNull
        public CompletableFuture<Unit> adjust(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<GHLabel> delta) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(delta, (String)"delta");
            return this.getModel().adjustLabels(indicator, delta);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory$ReviewersListPanelHandle;", "Lorg/jetbrains/plugins/github/ui/component/LabeledListPanelHandle;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRMetadataPanelFactory;)V", "adjust", "Ljava/util/concurrent/CompletableFuture;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "delta", "Lcom/intellij/collaboration/util/CollectionDelta;", "getItemComponent", "Ljavax/swing/JLabel;", "item", "getItems", "", "showEditPopup", "parentComponent", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    private final class ReviewersListPanelHandle
    extends LabeledListPanelHandle<GHPullRequestRequestedReviewer> {
        public ReviewersListPanelHandle() {
            GHPRMetadataModel gHPRMetadataModel = GHPRMetadataPanelFactory.this.model;
            String string = GithubBundle.message("pull.request.no.reviewers", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.no.reviewers\")");
            super(gHPRMetadataModel, string, GithubBundle.message("pull.request.reviewers", new Object[0]) + ":");
        }

        @Override
        @NotNull
        public List<GHPullRequestRequestedReviewer> getItems() {
            return this.getModel().getReviewers();
        }

        @NotNull
        public JLabel getItemComponent(@NotNull GHPullRequestRequestedReviewer item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return GHPRMetadataPanelFactory.this.createUserLabel(item);
        }

        @Override
        @NotNull
        public CompletableFuture<CollectionDelta<GHPullRequestRequestedReviewer>> showEditPopup(@NotNull JComponent parentComponent) {
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            return GHUIUtil.INSTANCE.showChooserPopup(parentComponent, GHUIUtil.SelectionPresenters.INSTANCE.PRReviewers((IconsProvider<String>)GHPRMetadataPanelFactory.this.avatarIconsProvider), this.getModel().getReviewers(), this.getModel().loadPotentialReviewers());
        }

        @Override
        @NotNull
        public CompletableFuture<Unit> adjust(@NotNull ProgressIndicator indicator, @NotNull CollectionDelta<? extends GHPullRequestRequestedReviewer> delta) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(delta, (String)"delta");
            return this.getModel().adjustReviewers(indicator, delta);
        }
    }
}

