/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntShortAssociativeContainer;
import com.carrotsearch.hppc.IntShortHashMap;
import com.carrotsearch.hppc.IntShortMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.comparators.IntComparator;
import com.carrotsearch.hppc.comparators.IntShortComparator;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.IntShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.IntShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationIntShortHashMap
implements IntShortMap {
    public final IntShortHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntShortHashMap(IntShortHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntShortHashMap(IntShortHashMap delegate, IntShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntShortComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final short[] values;
            {
                this.keys = SortedIterationIntShortHashMap.this.delegate.keys;
                this.values = SortedIterationIntShortHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntShortCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntShortPredicate predicate) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public <T extends IntShortProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntShortPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public short get(int key2) {
        return this.delegate.get(key2);
    }

    @Override
    public short getOrDefault(int key2, short defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public short put(int key2, short value) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntShortAssociativeContainer container) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntShortCursor> iterable) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public short putOrAdd(int key2, short putValue, short incrementValue) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public short addTo(int key2, short additionValue) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public short remove(int key2) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public short indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public short indexReplace(int index, short newValue) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key2, short value) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public short indexRemove(int index) {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntShortHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntShortCursor> {
        private final IntShortCursor cursor = new IntShortCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntShortCursor fetch() {
            if (this.index < SortedIterationIntShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntShortHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntShortHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntShortCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntShortHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntShortHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final SortedIterationIntShortHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (IntShortCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntShortHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationIntShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntShortHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

