/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction;
import org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeFoldingSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J&\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeFoldingSettings;", "getSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCodeFoldingSettings;", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "processTableOfContents", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "Companion", "HeaderRegionsBuildingVisitor", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFoldingBuilder.kt\norg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class MarkdownFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<IElementType, String> foldedElementsPresentations;

    private final MarkdownCodeFoldingSettings getSettings() {
        return MarkdownCodeFoldingSettings.Companion.getInstance();
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (root.getLanguage() != root.getContainingFile().getViewProvider().getBaseLanguage()) {
            return;
        }
        root.accept((PsiElementVisitor)new MarkdownElementVisitor(descriptors, document){
            final /* synthetic */ List<FoldingDescriptor> $descriptors;
            final /* synthetic */ Document $document;
            {
                this.$descriptors = $descriptors;
                this.$document = $document;
            }

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                super.visitElement(element2);
                IElementType iElementType = MarkdownElementTypes.FRONT_MATTER_HEADER;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FRONT_MATTER_HEADER");
                if (PsiUtilsKt.hasType(element2, iElementType)) {
                    this.addDescriptors(element2);
                }
                element2.acceptChildren((PsiElementVisitor)this);
            }

            public void visitList(@NotNull MarkdownList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                PsiElement parent = list2.getParent();
                this.addDescriptors((PsiElement)(parent instanceof MarkdownListItem ? (MarkdownCompositePsiElementBase)parent : (MarkdownCompositePsiElementBase)list2));
                super.visitList(list2);
            }

            public void visitLinkDestination(@NotNull MarkdownLinkDestination linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                ASTNode aSTNode = linkDestination.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"linkDestination.node");
                ASTNode node = aSTNode;
                FoldingDescriptor descriptor = new FoldingDescriptor(node, node.getTextRange(), null, "...", Boolean.valueOf(node.getTextLength() > 10), SetsKt.emptySet());
                this.$descriptors.add(descriptor);
                super.visitLinkDestination(linkDestination);
            }

            public void visitParagraph(@NotNull MarkdownParagraph paragraph) {
                Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
                PsiElement parent = paragraph.getParent();
                if (parent instanceof MarkdownBlockQuote) {
                    PsiElement $this$childrenOfType$iv = parent;
                    boolean $i$f$childrenOfType = false;
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, MarkdownParagraph.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(this, T::class.java)");
                    if (list2.size() <= 1) {
                        return;
                    }
                }
                this.addDescriptors((PsiElement)paragraph);
                super.visitParagraph(paragraph);
            }

            public void visitTable(@NotNull MarkdownTable table) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                this.addDescriptors((PsiElement)table);
                super.visitTable(table);
            }

            public void visitBlockQuote(@NotNull MarkdownBlockQuote blockQuote) {
                Intrinsics.checkNotNullParameter((Object)blockQuote, (String)"blockQuote");
                this.addDescriptors((PsiElement)blockQuote);
                super.visitBlockQuote(blockQuote);
            }

            public void visitCodeFence(@NotNull MarkdownCodeFence codeFence) {
                Intrinsics.checkNotNullParameter((Object)codeFence, (String)"codeFence");
                this.addDescriptors((PsiElement)codeFence);
                super.visitCodeFence(codeFence);
            }

            private final void addDescriptors(PsiElement element2) {
                TextRange textRange = element2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
                org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$Companion.access$addDescriptors(MarkdownFoldingBuilder.Companion, element2, textRange, this.$descriptors, this.$document);
            }
        });
        HeaderRegionsBuildingVisitor headerVisitor2 = new HeaderRegionsBuildingVisitor((Function2<? super PsiElement, ? super TextRange, Unit>)((Function2)new Function2<PsiElement, TextRange, Unit>(descriptors, document){
            final /* synthetic */ List<FoldingDescriptor> $descriptors;
            final /* synthetic */ Document $document;
            {
                this.$descriptors = $descriptors;
                this.$document = $document;
                super(2);
            }

            public final void invoke(@NotNull PsiElement header, @NotNull TextRange range) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$Companion.access$addDescriptors(MarkdownFoldingBuilder.Companion, header, range, this.$descriptors, this.$document);
            }
        }));
        root.accept((PsiElementVisitor)headerVisitor2);
        headerVisitor2.processLastHeaderIfNeeded();
        if (root instanceof MarkdownFile) {
            this.processTableOfContents((MarkdownFile)root, document, descriptors);
        }
    }

    private final void processTableOfContents(MarkdownFile file, Document document, List<FoldingDescriptor> descriptors) {
        Sequence<TextRange> ranges2 = GenerateTableOfContentsAction.Companion.findExistingTocs(file);
        FoldingGroup group = FoldingGroup.newGroup((String)"Table of contents");
        boolean shouldCollapse = ((MarkdownCodeFoldingSettings.State)MarkdownCodeFoldingSettings.Companion.getInstance().getState()).getCollapseTableOfContents();
        for (TextRange range : ranges2) {
            FoldingDescriptor descriptor = new FoldingDescriptor((ASTNode)file.getNode(), range, group, MarkdownBundle.message("markdown.folding.table.of.contents.name", new Object[0]), Boolean.valueOf(shouldCollapse), SetsKt.emptySet());
            descriptors.add(descriptor);
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Object object;
        block3: {
            String elementText;
            block2: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                IElementType elementType = PsiUtilCore.getElementType((ASTNode)node);
                String explicitName = foldedElementsPresentations.get(elementType);
                String string = StringUtil.shortenTextWithEllipsis((String)node.getText(), (int)30, (int)5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(node.text, 30, 5)");
                elementText = string;
                object = explicitName;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string2 = it + ": " + elementText;
                object = string2;
                if (string2 != null) break block3;
            }
            object = elementText;
        }
        return object;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DESTINATION) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseLinks() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FRONT_MATTER_HEADER) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseFrontMatter() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.TABLE) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseTables() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseCodeFences() : false)));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.ATX_1, (Object)MarkdownBundle.message("markdown.folding.atx.1.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_2, (Object)MarkdownBundle.message("markdown.folding.atx.2.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_3, (Object)MarkdownBundle.message("markdown.folding.atx.3.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_4, (Object)MarkdownBundle.message("markdown.folding.atx.4.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_5, (Object)MarkdownBundle.message("markdown.folding.atx.5.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ATX_6, (Object)MarkdownBundle.message("markdown.folding.atx.6.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.ORDERED_LIST, (Object)MarkdownBundle.message("markdown.folding.ordered.list.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.UNORDERED_LIST, (Object)MarkdownBundle.message("markdown.folding.unordered.list.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.BLOCK_QUOTE, (Object)MarkdownBundle.message("markdown.folding.block.quote.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.TABLE, (Object)MarkdownBundle.message("markdown.folding.table.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)MarkdownBundle.message("markdown.folding.code.fence.name", new Object[0])), TuplesKt.to((Object)MarkdownElementTypes.FRONT_MATTER_HEADER, (Object)MarkdownBundle.message("markdown.folding.front.matter.name", new Object[0]))};
        foldedElementsPresentations = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t0\u0004j \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$Companion;", "", "()V", "foldedElementsPresentations", "Ljava/util/HashMap;", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/collections/HashMap;", "addDescriptors", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "document", "Lcom/intellij/openapi/editor/Document;", "skipNewLinesBackward", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nMarkdownFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFoldingBuilder.kt\norg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,213:1\n179#2,2:214\n*S KotlinDebug\n*F\n+ 1 MarkdownFoldingBuilder.kt\norg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$Companion\n*L\n209#1:214,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void addDescriptors(PsiElement element2, TextRange range, List<? super FoldingDescriptor> descriptors, Document document) {
            if (document.getLineNumber(range.getStartOffset()) != document.getLineNumber(range.getEndOffset() - 1)) {
                descriptors.add((FoldingDescriptor)new FoldingDescriptor(element2, range));
            }
        }

        private final PsiElement skipNewLinesBackward(PsiElement element2) {
            PsiElement psiElement;
            PsiElement psiElement2 = element2;
            if (psiElement2 != null && (psiElement2 = PsiTreeUtilKt.siblings((PsiElement)psiElement2, (boolean)false, (boolean)false)) != null) {
                Object v1;
                block3: {
                    PsiElement $this$firstOrNull$iv = psiElement2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!MarkdownPsiUtil.WhiteSpaces.isNewLine(it))) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                psiElement = v1;
            } else {
                psiElement = null;
            }
            return psiElement;
        }

        public static final /* synthetic */ void access$addDescriptors(Companion $this, PsiElement element2, TextRange range, List descriptors, Document document) {
            $this.addDescriptors(element2, range, descriptors, document);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011*\u00020\u0004H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownRecursiveElementVisitor;", "regionConsumer", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "", "(Lkotlin/jvm/functions/Function2;)V", "lastProcessedHeader", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "createRegionIfNeeded", "currentHeader", "regionEnd", "processLastHeaderIfNeeded", "visitHeader", "header", "headersHierarchy", "Lkotlin/sequences/Sequence;", "intellij.markdown.core"})
    private static final class HeaderRegionsBuildingVisitor
    extends MarkdownRecursiveElementVisitor {
        @NotNull
        private final Function2<PsiElement, TextRange, Unit> regionConsumer;
        @Nullable
        private MarkdownHeader lastProcessedHeader;

        public HeaderRegionsBuildingVisitor(@NotNull Function2<? super PsiElement, ? super TextRange, Unit> regionConsumer) {
            Intrinsics.checkNotNullParameter(regionConsumer, (String)"regionConsumer");
            this.regionConsumer = regionConsumer;
        }

        @Override
        public void visitHeader(@NotNull MarkdownHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            MarkdownPsiStructureUtil.processContainer((PsiElement)header, (Consumer<PsiElement>)((Consumer)HeaderRegionsBuildingVisitor::visitHeader$lambda$0), (Consumer<PsiElement>)((Consumer)arg_0 -> HeaderRegionsBuildingVisitor.visitHeader$lambda$1(this, header, arg_0)));
            this.lastProcessedHeader = header;
            super.visitHeader(header);
        }

        public final void processLastHeaderIfNeeded() {
            MarkdownHeader lastHeader = this.lastProcessedHeader;
            if (lastHeader != null) {
                PsiElement lastFileChild = lastHeader.getContainingFile().getLastChild();
                PsiElement regionEnd = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)lastFileChild), (Object)MarkdownTokenTypes.EOL) ? Companion.skipNewLinesBackward(lastFileChild) : lastFileChild;
                Sequence<MarkdownHeader> headers2 = this.headersHierarchy((PsiElement)lastHeader);
                for (MarkdownHeader header : headers2) {
                    this.createRegionIfNeeded(header, regionEnd);
                }
            }
        }

        private final Sequence<MarkdownHeader> headersHierarchy(PsiElement $this$headersHierarchy) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MarkdownHeader>, Continuation<? super Unit>, Object>($this$headersHierarchy, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ PsiElement $this_headersHierarchy;
                {
                    this.$this_headersHierarchy = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    Iterator iterator;
                    int nextMaxLevel;
                    SequenceScope $this$sequence;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)this.$this_headersHierarchy, (boolean)false, (boolean)true);
                            boolean $i$f$filterIsInstance = false;
                            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$$inlined$filterIsInstance$1.INSTANCE);
                            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                            Sequence headers2 = sequence;
                            nextMaxLevel = Integer.MAX_VALUE;
                            iterator = headers2.iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            nextMaxLevel = this.I$0;
                            iterator = (Iterator)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator.hasNext()) {
                        MarkdownHeader header = (MarkdownHeader)iterator.next();
                        if (nextMaxLevel <= 1) {
                            return Unit.INSTANCE;
                        }
                        int level = header.getLevel();
                        if (level >= nextMaxLevel) continue;
                        nextMaxLevel = level;
                        this.L$0 = $this$sequence;
                        this.L$1 = iterator;
                        this.I$0 = nextMaxLevel;
                        this.label = 1;
                        object2 = $this$sequence.yield((Object)header, (Continuation)this);
                        if (object2 == object3) return object3;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super MarkdownHeader> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void createRegionIfNeeded(MarkdownHeader currentHeader, PsiElement regionEnd) {
            if (regionEnd != null) {
                TextRange textRange = TextRange.create((int)currentHeader.getTextRange().getStartOffset(), (int)regionEnd.getTextRange().getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(currentHeader.tex\u2026nEnd.textRange.endOffset)");
                TextRange range = textRange;
                this.regionConsumer.invoke((Object)currentHeader, (Object)range);
            }
        }

        private static final void visitHeader$lambda$0(PsiElement it) {
        }

        private static final void visitHeader$lambda$1(HeaderRegionsBuildingVisitor this$0, MarkdownHeader $header, PsiElement nextHeader) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
            PsiElement regionEnd = Companion.skipNewLinesBackward(nextHeader);
            this$0.createRegionIfNeeded($header, regionEnd);
        }
    }
}

