/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.row.RowBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "insertAbove", "", "(Z)V", "findRowOrSeparator", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "obtainCellWidths", "", "element", "performAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "rowElement", "InsertAbove", "InsertBelow", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nInsertRowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertRowAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1549#2:53\n1620#2,3:54\n1549#2:57\n1620#2,3:58\n*S KotlinDebug\n*F\n+ 1 InsertRowAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction\n*L\n33#1:53\n33#1:54,3\n34#1:57\n34#1:58,3\n*E\n"})
public abstract class InsertRowAction
extends RowBasedTableAction {
    private final boolean insertAbove;

    public InsertRowAction(boolean insertAbove) {
        super(true);
        this.insertAbove = insertAbove;
    }

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTable table, @NotNull PsiElement rowElement) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)rowElement, (String)"rowElement");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this, rowElement, table){
            final /* synthetic */ InsertRowAction this$0;
            final /* synthetic */ PsiElement $rowElement;
            final /* synthetic */ MarkdownTable $table;
            {
                this.this$0 = $receiver;
                this.$rowElement = $rowElement;
                this.$table = $table;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void project$iv;
                Collection widths = InsertRowAction.access$obtainCellWidths(this.this$0, this.$rowElement);
                MarkdownTableRow markdownTableRow = MarkdownPsiElementFactory.createTableEmptyRow(this.$table.getProject(), widths);
                Intrinsics.checkNotNullExpressionValue((Object)markdownTableRow, (String)"createTableEmptyRow(table.project, widths)");
                MarkdownTableRow newRow = markdownTableRow;
                if (!Intrinsics.areEqual((Object)this.$rowElement.getParent(), (Object)this.$table)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Project project = this.$rowElement.getProject();
                InsertRowAction insertRowAction = this.this$0;
                MarkdownTable markdownTable = this.$table;
                PsiElement psiElement = this.$rowElement;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(insertRowAction, markdownTable, newRow, psiElement){
                    final /* synthetic */ InsertRowAction this$0;
                    final /* synthetic */ MarkdownTable $table$inlined;
                    final /* synthetic */ MarkdownTableRow $newRow$inlined;
                    final /* synthetic */ PsiElement $rowElement$inlined;
                    {
                        this.this$0 = insertRowAction;
                        this.$table$inlined = markdownTable;
                        this.$newRow$inlined = markdownTableRow;
                        this.$rowElement$inlined = psiElement;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (InsertRowAction.access$getInsertAbove$p(this.this$0)) {
                            this.$table$inlined.addRangeBefore((PsiElement)this.$newRow$inlined, this.$newRow$inlined.getNextSibling(), this.$rowElement$inlined);
                        } else {
                            this.$table$inlined.addRangeAfter(this.$newRow$inlined.getPrevSibling(), (PsiElement)this.$newRow$inlined, this.$rowElement$inlined);
                        }
                    }
                }, name$iv, groupId$iv);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Integer> obtainCellWidths(PsiElement element2) {
        Collection collection;
        PsiElement psiElement = element2;
        if (psiElement instanceof MarkdownTableRow) {
            void $this$mapTo$iv$iv;
            List<MarkdownTableCell> list2 = ((MarkdownTableRow)element2).getCells();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"element.cells");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getTextLength());
            }
            collection = (List)destination$iv$iv;
        } else if (psiElement instanceof MarkdownTableSeparatorRow) {
            Iterable $this$map$iv = ((MarkdownTableSeparatorRow)element2).getCellsRanges();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextRange it = (TextRange)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getLength());
            }
            collection = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException("element should be either MarkdownTableRow or MarkdownTableSeparatorRow".toString());
        }
        return collection;
    }

    @Override
    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement psiElement = super.findRowOrSeparator(file, document, offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        MarkdownTableRow markdownTableRow = element2 instanceof MarkdownTableRow ? (MarkdownTableRow)element2 : null;
        return (markdownTableRow != null ? TableUtils.INSTANCE.isHeaderRow(markdownTableRow) : false) ? null : (this.insertAbove && element2 instanceof MarkdownTableSeparatorRow ? null : element2);
    }

    public static final /* synthetic */ Collection access$obtainCellWidths(InsertRowAction $this, PsiElement element2) {
        return $this.obtainCellWidths(element2);
    }

    public static final /* synthetic */ boolean access$getInsertAbove$p(InsertRowAction $this) {
        return $this.insertAbove;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertAbove;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "()V", "intellij.markdown.core"})
    public static final class InsertAbove
    extends InsertRowAction {
        public InsertAbove() {
            super(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertBelow;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "()V", "intellij.markdown.core"})
    public static final class InsertBelow
    extends InsertRowAction {
        public InsertBelow() {
            super(false);
        }
    }
}

