/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListItemInfo;", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "indentInfo", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "getIndentInfo", "()Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "setIndentInfo", "(Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;)V", "lines", "Lkotlin/ranges/IntRange;", "getLines", "()Lkotlin/ranges/IntRange;", "changeIndent", "", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "newIndent", "", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nListItemInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListItemInfo.kt\norg/intellij/plugins/markdown/editor/lists/ListItemInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1603#2,9:32\n1855#2:41\n1856#2:43\n1612#2:44\n1#3:42\n*S KotlinDebug\n*F\n+ 1 ListItemInfo.kt\norg/intellij/plugins/markdown/editor/lists/ListItemInfo\n*L\n25#1:32,9\n25#1:41\n25#1:43\n25#1:44\n25#1:42\n*E\n"})
public final class ListItemInfo {
    @NotNull
    private final Document document;
    private final PsiFile file;
    @NotNull
    private final IntRange lines;
    @NotNull
    private ListItemIndentInfo indentInfo;

    /*
     * WARNING - void declaration
     */
    public ListItemInfo(@NotNull MarkdownListItem item, @NotNull Document document) {
        void $this$indentInfo_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.file = item.getContainingFile();
        this.lines = new IntRange(this.document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item))), this.document.getLineNumber(UtilsKt.getEndOffset((PsiElement)((PsiElement)item))));
        ListItemInfo listItemInfo = this;
        ListItemInfo listItemInfo2 = this;
        boolean bl = false;
        Integer n = ListUtils.INSTANCE.getLineIndentInnerSpacesLength($this$indentInfo_u24lambda_u240.document, $this$indentInfo_u24lambda_u240.lines.getFirst(), $this$indentInfo_u24lambda_u240.file);
        Intrinsics.checkNotNull((Object)n);
        int indent = n;
        listItemInfo2.indentInfo = new ListItemIndentInfo(indent, ListUtils.INSTANCE.getNormalizedMarker(item).length());
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final IntRange getLines() {
        return this.lines;
    }

    @NotNull
    public final ListItemIndentInfo getIndentInfo() {
        return this.indentInfo;
    }

    public final void setIndentInfo(@NotNull ListItemIndentInfo listItemIndentInfo) {
        Intrinsics.checkNotNullParameter((Object)listItemIndentInfo, (String)"<set-?>");
        this.indentInfo = listItemIndentInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Replacement> changeIndent(int newIndent) {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)this.lines;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Replacement it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            if (this.indentInfo.changeLineIndent(it, newIndent, this.document, this.file) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list2 = (List)destination$iv$iv;
        boolean bl = false;
        this.indentInfo = ListItemIndentInfo.with$default(this.indentInfo, newIndent, 0, 2, null);
        return list2;
    }
}

