/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.SerializationHelper;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequestJsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "()V", "createLogEventRecord", "Lcom/intellij/internal/statistic/eventLog/LogEventRecord;", "record", "Lcom/fasterxml/jackson/databind/JsonNode;", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.platform.statistics.uploader"})
@SourceDebugExtension(value={"SMAP\nLogEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventRecordRequestJsonDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n1855#2,2:261\n1855#2,2:263\n*S KotlinDebug\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventRecordRequestJsonDeserializer\n*L\n105#1:261,2\n114#1:263,2\n*E\n"})
public final class LogEventRecordRequestJsonDeserializer
extends JsonDeserializer<LogEventRecordRequest> {
    @NotNull
    public LogEventRecordRequest deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext context) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"jsonParser.codec.readTree(jsonParser)");
        JsonNode node = (JsonNode)treeNode;
        String recorder = node.get("recorder").asText();
        String product = node.get("product").asText();
        String device = node.get("device").asText();
        boolean internal = false;
        if (node.has("internal")) {
            internal = node.get("internal").asBoolean();
        }
        JsonNode records = node.get("records");
        List logEventRecordList = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)records, (String)"records");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode record = (JsonNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)record, (String)"record");
            logEventRecordList.add(this.createLogEventRecord(record));
        }
        Intrinsics.checkNotNullExpressionValue((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullExpressionValue((Object)product, (String)"product");
        Intrinsics.checkNotNullExpressionValue((Object)device, (String)"device");
        return new LogEventRecordRequest(recorder, product, device, logEventRecordList, internal);
    }

    private final LogEventRecord createLogEventRecord(JsonNode record) {
        List logEventList = new ArrayList();
        JsonNode events = record.get("events");
        Intrinsics.checkNotNullExpressionValue((Object)events, (String)"events");
        Iterable $this$forEach$iv = (Iterable)events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonNode event = (JsonNode)element$iv;
            boolean bl = false;
            String string = event.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.toString()");
            LogEvent logEvent = SerializationHelper.Companion.deserializeLogEvent(string);
            logEventList.add(logEvent);
        }
        return new LogEventRecord(logEventList);
    }
}

