/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.fixtures.SdkTestFixture;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0004J\b\u0010\u0010\u001a\u00020\u0006H$J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0004J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH$J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/fixtures/impl/AbstractSdkTestFixture;", "Lcom/intellij/testFramework/fixtures/SdkTestFixture;", "()V", "fixtureDisposable", "Lcom/intellij/openapi/Disposable;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkType;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkType;", "createAndAddSdk", "sdkHome", "", "parentDisposable", "findAndAddSdk", "findOrCreateSdk", "findSdkInTable", "getSdk", "isSdkSupported", "", "versionString", "setUp", "", "tearDown", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nAbstractSdkTestFixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSdkTestFixture.kt\ncom/intellij/testFramework/fixtures/impl/AbstractSdkTestFixture\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 EdtTestUtil.kt\ncom/intellij/testFramework/EdtTestUtilKt\n+ 4 readWriteActionsInTests.kt\ncom/intellij/openapi/application/ReadWriteActionsInTestsKt\n*L\n1#1,73:1\n603#2:74\n603#2:75\n14#3:76\n11#4:77\n*S KotlinDebug\n*F\n+ 1 AbstractSdkTestFixture.kt\ncom/intellij/testFramework/fixtures/impl/AbstractSdkTestFixture\n*L\n45#1:74\n54#1:75\n61#1:76\n66#1:77\n*E\n"})
public abstract class AbstractSdkTestFixture
implements SdkTestFixture {
    private Disposable fixtureDisposable;
    private Sdk sdk;

    @NotNull
    protected abstract SdkType getSdkType();

    protected abstract boolean isSdkSupported(@NotNull String var1);

    @NotNull
    protected abstract Sdk findOrCreateSdk();

    @Override
    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.sdk;
        if (sdk == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdk");
            sdk = null;
        }
        return sdk;
    }

    @Override
    public void setUp() {
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        this.fixtureDisposable = disposable;
        this.sdk = this.findOrCreateSdk();
    }

    @Override
    public void tearDown() {
        Disposable disposable = this.fixtureDisposable;
        if (disposable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
            disposable = null;
        }
        Disposer.dispose((Disposable)disposable);
    }

    @Nullable
    protected final Sdk findSdkInTable() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<Sdk[]>(table){
            final /* synthetic */ ProjectJdkTable $table;
            {
                this.$table = $table;
                super(0);
            }

            @NotNull
            public final Sdk[] invoke() {
                return this.$table.getAllJdks();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"table = ProjectJdkTable.\u2026dAction { table.allJdks }");
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])((Object[])object)), (Function1)((Function1)new Function1<Sdk, Boolean>(this){
            final /* synthetic */ AbstractSdkTestFixture this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(Sdk it) {
                boolean bl;
                if (it.getVersionString() != null) {
                    String string = it.getVersionString();
                    Intrinsics.checkNotNull((Object)string);
                    if (this.this$0.isSdkSupported(string)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$sortedBy = false;
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Sdk it = (Sdk)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getVersionString());
                it = (Sdk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getVersionString())));
            }
        }));
    }

    @Nullable
    protected final Sdk findAndAddSdk() {
        Collection collection = this.getSdkType().suggestHomePaths();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sdkType.suggestHomePaths()");
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AbstractSdkTestFixture this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.this$0.getSdkType().isValidSdkHome(it);
            }
        })), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ AbstractSdkTestFixture this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<String, String> invoke(String it) {
                return TuplesKt.to((Object)this.this$0.getSdkType().getVersionString(it), (Object)it);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(this){
            final /* synthetic */ AbstractSdkTestFixture this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Pair<String, String> it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.getFirst() != null) {
                    Object object = it.getFirst();
                    Intrinsics.checkNotNull((Object)object);
                    if (this.this$0.isSdkSupported((String)object)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$sortedBy = false;
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        }), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Sdk>(this){
            final /* synthetic */ AbstractSdkTestFixture this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Sdk invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object object = it.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.second");
                String string = (String)object;
                SdkType sdkType = this.this$0.getSdkType();
                Disposable disposable = AbstractSdkTestFixture.access$getFixtureDisposable$p(this.this$0);
                if (disposable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDisposable");
                    disposable = null;
                }
                return AbstractSdkTestFixture.access$createAndAddSdk(this.this$0, string, sdkType, disposable);
            }
        })));
    }

    private final Sdk createAndAddSdk(String sdkHome, SdkType sdkType, Disposable parentDisposable) {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        boolean $i$f$runInEdtAndGet = false;
        Sdk sdk = (Sdk)EdtTestUtil.runInEdtAndGet((ThrowableComputable)new ThrowableComputable(sdkHome, sdkType){
            final /* synthetic */ String $sdkHome$inlined;
            final /* synthetic */ SdkType $sdkType$inlined;
            {
                this.$sdkHome$inlined = string;
                this.$sdkType$inlined = sdkType;
            }

            public final Sdk compute() {
                boolean bl = false;
                return SdkConfigurationUtil.createAndAddSDK((String)this.$sdkHome$inlined, (SdkType)this.$sdkType$inlined);
            }
        });
        if (sdk != null) {
            Disposer.register((Disposable)parentDisposable, () -> AbstractSdkTestFixture.createAndAddSdk$lambda$4(table, sdk));
        }
        return sdk;
    }

    private static final void createAndAddSdk$lambda$4(ProjectJdkTable $table, Sdk $sdk) {
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable($table, $sdk){
            final /* synthetic */ ProjectJdkTable $table$inlined;
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$table$inlined = projectJdkTable;
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                this.$table$inlined.removeJdk(this.$sdk$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    public static final /* synthetic */ Sdk access$createAndAddSdk(AbstractSdkTestFixture $this, String sdkHome, SdkType sdkType, Disposable parentDisposable) {
        return $this.createAndAddSdk(sdkHome, sdkType, parentDisposable);
    }

    public static final /* synthetic */ Disposable access$getFixtureDisposable$p(AbstractSdkTestFixture $this) {
        return $this.fixtureDisposable;
    }
}

