/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLightProjectDescriptor
extends LightProjectDescriptor {
    @Nullable
    private Supplier<? extends Sdk> customSdk;
    private final List<RequiredLibrary> mavenLibraries;

    public DefaultLightProjectDescriptor() {
        this.mavenLibraries = new ArrayList<RequiredLibrary>();
    }

    public DefaultLightProjectDescriptor(@NotNull Supplier<? extends Sdk> customSdk) {
        if (customSdk == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(0);
        }
        this.mavenLibraries = new ArrayList<RequiredLibrary>();
        this.customSdk = customSdk;
    }

    public DefaultLightProjectDescriptor(@NotNull Supplier<? extends Sdk> customSdk, @NotNull List<String> mavenLibraries) {
        if (customSdk == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(1);
        }
        if (mavenLibraries == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(2);
        }
        this.mavenLibraries = new ArrayList<RequiredLibrary>();
        this.customSdk = customSdk;
        for (String library : mavenLibraries) {
            this.withRepositoryLibrary(library);
        }
    }

    @Override
    @NotNull
    public String getModuleTypeId() {
        return "JAVA_MODULE";
    }

    @Override
    public Sdk getSdk() {
        return this.customSdk == null ? IdeaTestUtil.getMockJdk17() : this.customSdk.get();
    }

    @Override
    public void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model2, @NotNull ContentEntry contentEntry) {
        LanguageLevelModuleExtension extension;
        if (module2 == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(3);
        }
        if (model2 == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(4);
        }
        if (contentEntry == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(5);
        }
        if ((extension = (LanguageLevelModuleExtension)model2.getModuleExtension(LanguageLevelModuleExtension.class)) != null) {
            extension.setLanguageLevel(LanguageLevel.HIGHEST);
            for (RequiredLibrary library : this.mavenLibraries) {
                MavenDependencyUtil.addFromMaven(model2, library.mavenCoordinates, library.includeTransitive);
            }
        }
    }

    public DefaultLightProjectDescriptor withRepositoryLibrary(@NotNull String library) {
        if (library == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(6);
        }
        return this.withRepositoryLibrary(library, true);
    }

    public DefaultLightProjectDescriptor withRepositoryLibrary(@NotNull String library, boolean includeTransitive) {
        if (library == null) {
            DefaultLightProjectDescriptor.$$$reportNull$$$0(7);
        }
        this.mavenLibraries.add(new RequiredLibrary(library, includeTransitive));
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenLibraries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/fixtures/DefaultLightProjectDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configureModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withRepositoryLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RequiredLibrary {
        public final String mavenCoordinates;
        public final boolean includeTransitive;

        private RequiredLibrary(String coordinates, boolean transitive) {
            this.mavenCoordinates = coordinates;
            this.includeTransitive = transitive;
        }
    }
}

