/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.nastradamus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.NastradamusClient;
import com.intellij.nastradamus.model.BuildInfo;
import com.intellij.nastradamus.model.ChangeEntity;
import com.intellij.nastradamus.model.SortRequestEntity;
import com.intellij.nastradamus.model.TestCaseEntity;
import com.intellij.nastradamus.model.TestClassResultEntity;
import com.intellij.nastradamus.model.TestResultEntity;
import com.intellij.nastradamus.model.TestResultRequestEntity;
import com.intellij.nastradamus.model.TestStatus;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.tool.ErrorThresholdKt;
import com.intellij.tool.HttpClient;
import com.intellij.tool.RetryKt;
import com.intellij.tool.TaskKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0005J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001d0 J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u001dR\u001e\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lcom/intellij/nastradamus/NastradamusClient;", "", "baseUrl", "Ljava/net/URI;", "unsortedClasses", "", "Ljava/lang/Class;", "teamCityClient", "Lcom/intellij/teamcity/TeamCityClient;", "(Ljava/net/URI;Ljava/util/List;Lcom/intellij/teamcity/TeamCityClient;)V", "allSortedClasses", "", "", "getBaseUrl", "()Ljava/net/URI;", "sortedClassesInCurrentBucket", "", "getUnsortedClasses", "()Ljava/util/List;", "collectTestRunResults", "Lcom/intellij/nastradamus/model/TestResultRequestEntity;", "getBuildInfo", "Lcom/intellij/nastradamus/model/BuildInfo;", "getRankedClasses", "getTeamCityChangesDetails", "Lcom/intellij/nastradamus/model/ChangeEntity;", "getTeamCityChangesetPatch", "", "isClassInBucket", "", "testIdentifier", "fallbackFunc", "Lkotlin/Function1;", "sendSortingRequest", "Lcom/intellij/nastradamus/model/TestCaseEntity;", "sortRequestEntity", "Lcom/intellij/nastradamus/model/SortRequestEntity;", "bucketsCount", "currentBucketIndex", "wasNastradamusDataUsed", "sendTestRunResults", "", "testResultRequestEntity", "Companion", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nNastradamusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NastradamusClient.kt\ncom/intellij/nastradamus/NastradamusClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n288#2,2:301\n288#2,2:303\n1549#2:305\n1620#2,3:306\n1045#2:309\n1271#2,2:310\n1285#2,4:312\n*S KotlinDebug\n*F\n+ 1 NastradamusClient.kt\ncom/intellij/nastradamus/NastradamusClient\n*L\n41#1:301,2\n43#1:303,2\n48#1:305\n48#1:306,3\n244#1:309\n244#1:310,2\n244#1:312,4\n*E\n"})
public final class NastradamusClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI baseUrl;
    @NotNull
    private final List<Class<?>> unsortedClasses;
    @NotNull
    private final TeamCityClient teamCityClient;
    private Set<? extends Class<?>> sortedClassesInCurrentBucket;
    private Map<Class<?>, Integer> allSortedClasses;
    @NotNull
    private static final ObjectMapper jacksonMapper = ExtensionsKt.jacksonObjectMapper();

    public NastradamusClient(@NotNull URI baseUrl, @NotNull List<? extends Class<?>> unsortedClasses, @NotNull TeamCityClient teamCityClient) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(unsortedClasses, (String)"unsortedClasses");
        Intrinsics.checkNotNullParameter((Object)teamCityClient, (String)"teamCityClient");
        this.baseUrl = baseUrl;
        this.unsortedClasses = unsortedClasses;
        this.teamCityClient = teamCityClient;
    }

    public /* synthetic */ NastradamusClient(URI uRI, List list, TeamCityClient teamCityClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = new URI(System.getProperty("idea.nastradamus.url")).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"URI(System.getProperty(\"\u2026adamus.url\")).normalize()");
            uRI = uRI2;
        }
        if ((n & 4) != 0) {
            teamCityClient = new TeamCityClient(null, null, 3, null);
        }
        this(uRI, list, teamCityClient);
    }

    @NotNull
    public final URI getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final List<Class<?>> getUnsortedClasses() {
        return this.unsortedClasses;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestResultRequestEntity collectTestRunResults() {
        void $this$mapTo$iv$iv;
        Object v7;
        Iterable $this$firstOrNull$iv;
        int bucketId;
        Object element$iv2;
        Iterable $this$firstOrNull$iv2;
        List<JsonNode> tests;
        block8: {
            Object object;
            List buildProperties;
            JsonNode jsonNode;
            block7: {
                Object object2;
                Sequence sequence;
                Iterator iterator;
                tests = this.teamCityClient.getTestRunInfo();
                JsonNode build2 = this.teamCityClient.getBuildInfo();
                JsonNode jsonNode2 = build2.findValue("properties");
                buildProperties = jsonNode2 != null && (jsonNode = jsonNode2.findValue("property")) != null && (iterator = jsonNode.elements()) != null && (sequence = SequencesKt.asSequence((Iterator)iterator)) != null && (object2 = SequencesKt.toList((Sequence)sequence)) != null ? object2 : CollectionsKt.emptyList();
                $this$firstOrNull$iv2 = buildProperties;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv2) {
                    String string;
                    String string2;
                    JsonNode it = (JsonNode)element$iv2;
                    boolean bl = false;
                    JsonNode jsonNode3 = it.findValue("name");
                    String string3 = string2 = jsonNode3 != null ? jsonNode3.asText() : null;
                    if (string3 == null) {
                        string = "";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.findValue(\"name\")?.asText() ?: \"\"");
                        string = string2;
                    }
                    if (!Intrinsics.areEqual((Object)string, (Object)"system.pass.idea.test.runner.index")) continue;
                    object = element$iv2;
                    break block7;
                }
                object = null;
            }
            jsonNode = (JsonNode)object;
            bucketId = jsonNode != null && ($this$firstOrNull$iv2 = jsonNode.findValue("value")) != null ? $this$firstOrNull$iv2.asInt() : 0;
            $this$firstOrNull$iv = buildProperties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                String string;
                String string4;
                JsonNode it = (JsonNode)element$iv3;
                boolean bl = false;
                JsonNode jsonNode4 = it.findValue("name");
                String string5 = string4 = jsonNode4 != null ? jsonNode4.asText() : null;
                if (string5 == null) {
                    string = "";
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.findValue(\"name\")?.asText() ?: \"\"");
                    string = string4;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"system.pass.idea.test.runners.count")) continue;
                v7 = element$iv3;
                break block8;
            }
            v7 = null;
        }
        $this$firstOrNull$iv2 = v7;
        int bucketsNumber = $this$firstOrNull$iv2 != null && ($this$firstOrNull$iv = $this$firstOrNull$iv2.findValue("value")) != null ? $this$firstOrNull$iv.asInt() : 0;
        Map testResultEntities = new LinkedHashMap();
        Iterable $this$map$iv = tests;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void json;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = json.findValue("name").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.findValue(\"name\").asText()");
            String string6 = json.findValue("status").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"json.findValue(\"status\").asText()");
            JsonNode jsonNode5 = json.findValue("duration");
            JsonNode jsonNode6 = json.findValue("currentlyInvestigated");
            JsonNode jsonNode7 = json.findValue("currentlyMuted");
            TestResultEntity testResult = new TestResultEntity(string, TestStatus.Companion.fromString(string6), json.findValue("runOrder").asInt(), jsonNode5 != null ? jsonNode5.asLong() : 0L, jsonNode6 != null ? jsonNode6.asBoolean() : false, jsonNode7 != null ? jsonNode7.asBoolean() : false);
            JsonNode parsedTestName = json.findValue("test").findValue("parsedTestName");
            String packageName = parsedTestName.findValue("testPackage").asText();
            String shortClassName = parsedTestName.findValue("testClass").asText();
            String fullClassName = packageName + "." + shortClassName;
            testResultEntities.computeIfPresent(fullClassName, (arg_0, arg_1) -> NastradamusClient.collectTestRunResults$lambda$4$lambda$2((Function2)new Function2<String, TestClassResultEntity, TestClassResultEntity>(testResult){
                final /* synthetic */ TestResultEntity $testResult;
                {
                    this.$testResult = $testResult;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final TestClassResultEntity invoke(@NotNull String string, @NotNull TestClassResultEntity oldClassResult) {
                    void $this$invoke_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)oldClassResult, (String)"oldClassResult");
                    Set set = CollectionsKt.toMutableSet((Iterable)oldClassResult.getTestResults());
                    TestResultEntity testResultEntity = this.$testResult;
                    Set set2 = set;
                    long l = oldClassResult.getDurationMs() + this.$testResult.getDurationMs();
                    String string2 = null;
                    TestClassResultEntity testClassResultEntity = oldClassResult;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.add(testResultEntity);
                    Unit unit = Unit.INSTANCE;
                    return TestClassResultEntity.copy$default(testClassResultEntity, string2, l, set, 0, 0, 25, null);
                }
            }, arg_0, arg_1));
            collection.add(testResultEntities.computeIfAbsent(fullClassName, arg_0 -> NastradamusClient.collectTestRunResults$lambda$4$lambda$3((Function1)new Function1<String, TestClassResultEntity>(fullClassName, testResult, bucketId, bucketsNumber){
                final /* synthetic */ String $fullClassName;
                final /* synthetic */ TestResultEntity $testResult;
                final /* synthetic */ int $bucketId;
                final /* synthetic */ int $bucketsNumber;
                {
                    this.$fullClassName = $fullClassName;
                    this.$testResult = $testResult;
                    this.$bucketId = $bucketId;
                    this.$bucketsNumber = $bucketsNumber;
                    super(1);
                }

                @NotNull
                public final TestClassResultEntity invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object[] objectArray = new TestResultEntity[]{this.$testResult};
                    return new TestClassResultEntity(this.$fullClassName, this.$testResult.getDurationMs(), SetsKt.mutableSetOf((Object[])objectArray), this.$bucketId, this.$bucketsNumber);
                }
            }, arg_0)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return new TestResultRequestEntity(this.getBuildInfo(), CollectionsKt.toList((Iterable)testResultEntities.values()), this.getTeamCityChangesDetails());
    }

    public final void sendTestRunResults(@NotNull TestResultRequestEntity testResultRequestEntity, boolean wasNastradamusDataUsed) {
        HttpPost httpPost;
        Intrinsics.checkNotNullParameter((Object)testResultRequestEntity, (String)"testResultRequestEntity");
        URI uri = new URIBuilder(this.baseUrl.resolve("/result/").normalize()).addParameter("was_nastradamus_data_used", String.valueOf(wasNastradamusDataUsed)).build();
        String stringJson = jacksonMapper.writeValueAsString((Object)testResultRequestEntity);
        HttpPost $this$sendTestRunResults_u24lambda_u245 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendTestRunResults_u24lambda_u245.addHeader("Content-Type", "application/json");
        $this$sendTestRunResults_u24lambda_u245.addHeader("Accept", "application/json");
        $this$sendTestRunResults_u24lambda_u245.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Sending test run results to Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        ErrorThresholdKt.withErrorThreshold$default("NastradamusClient-sendTestRunResults", 0, (Function0)new Function0<Unit>(httpPost2){
            final /* synthetic */ HttpPost $httpPost;
            {
                this.$httpPost = $httpPost;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                return (Unit)RetryKt.withRetry-exY8QGI$default(0, null, 0L, (Function0)new Function0<Unit>(this.$httpPost){
                    final /* synthetic */ HttpPost $httpPost;
                    {
                        this.$httpPost = $httpPost;
                        super(0);
                    }

                    public final void invoke() {
                        HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$httpPost, sendTestRunResults.1.INSTANCE);
                    }
                }, 7, null);
            }
        }, sendTestRunResults.2.INSTANCE, 2, null);
    }

    @NotNull
    public final List<TestCaseEntity> sendSortingRequest(@NotNull SortRequestEntity sortRequestEntity, int bucketsCount, int currentBucketIndex, boolean wasNastradamusDataUsed) {
        HttpPost httpPost;
        Intrinsics.checkNotNullParameter((Object)sortRequestEntity, (String)"sortRequestEntity");
        URI uri = new URIBuilder(this.baseUrl.resolve("/sort/").normalize()).addParameter("buckets", String.valueOf(bucketsCount)).addParameter("was_nastradamus_data_used", String.valueOf(wasNastradamusDataUsed)).build();
        String stringJson = jacksonMapper.writeValueAsString((Object)sortRequestEntity);
        HttpPost $this$sendSortingRequest_u24lambda_u246 = httpPost = new HttpPost(uri);
        boolean bl = false;
        $this$sendSortingRequest_u24lambda_u246.addHeader("Content-Type", "application/json");
        $this$sendSortingRequest_u24lambda_u246.addHeader("Accept", "application/json");
        $this$sendSortingRequest_u24lambda_u246.setEntity((HttpEntity)new StringEntity(stringJson, ContentType.APPLICATION_JSON));
        HttpPost httpPost2 = httpPost;
        System.out.println((Object)"Fetching sorted test classes from Nastradamus ...");
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Requesting " + uri + " with payload " + stringJson));
        }
        return (List)ErrorThresholdKt.withErrorThreshold$default("NastradamusClient-sendSortingRequest", 0, (Function0)new Function0<List<? extends TestCaseEntity>>(uri, currentBucketIndex, httpPost2){
            final /* synthetic */ URI $uri;
            final /* synthetic */ int $currentBucketIndex;
            final /* synthetic */ HttpPost $httpPost;
            {
                this.$uri = $uri;
                this.$currentBucketIndex = $currentBucketIndex;
                this.$httpPost = $httpPost;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TestCaseEntity> invoke() {
                JsonNode jsonTree2 = (JsonNode)RetryKt.withRetry-exY8QGI$default(0, null, 0L, (Function0)new Function0<JsonNode>(this.$httpPost){
                    final /* synthetic */ HttpPost $httpPost;
                    {
                        this.$httpPost = $httpPost;
                        super(0);
                    }

                    public final JsonNode invoke() {
                        return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$httpPost, sendSortingRequest.jsonTree.1.INSTANCE);
                    }
                }, 7, null);
                Object object = this.$uri;
                if (jsonTree2 == null) {
                    boolean $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = false;
                    String $i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22 = "Received data from " + (URI)object + " must not be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-NastradamusClient$sendSortingRequest$1$22.toString());
                }
                if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
                    System.out.println((Object)("Received data from " + this.$uri + ": " + jsonTree2));
                }
                try {
                    void $this$mapTo$iv$iv;
                    Map.Entry it;
                    Iterator iterator = jsonTree2.fields();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonTree.fields()");
                    Sequence $this$single$iv = SequencesKt.asSequence((Iterator)iterator);
                    boolean $i$f$single22 = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (E element$iv : $this$single$iv) {
                        it = (Map.Entry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getKey(), (Object)"sorted_tests")) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    object = ((JsonNode)((Map.Entry)single$iv).getValue()).get(String.valueOf(this.$currentBucketIndex));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonTree.fields().asSequ\u2026ntBucketIndex.toString())");
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable $i$f$single22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (JsonNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.findValue("name").asText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.findValue(\"name\").asText()");
                        collection.add(new TestCaseEntity(string));
                    }
                    object = (List)destination$iv$iv;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Response from " + this.$uri + " with failure: " + jsonTree2, e);
                }
                return object;
            }
        }, sendSortingRequest.2.INSTANCE, 2, null);
    }

    private final List<String> getTeamCityChangesetPatch() {
        System.out.println((Object)"Fetching changesets patches from TeamCity ...");
        List changesets2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(this, null){
            int label;
            final /* synthetic */ NastradamusClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TaskKt.mapConcurrently((Iterable)NastradamusClient.access$getTeamCityClient$p(this.this$0).getChanges(), 5, (Function2)new Function2<JsonNode, Continuation<? super String>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ NastradamusClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        JsonNode change = (JsonNode)this.L$0;
                                        String modificationId = change.findValue("id").asText();
                                        JsonNode jsonNode = change.findValue("personal");
                                        boolean isPersonal = jsonNode != null ? jsonNode.asBoolean(false) : false;
                                        TeamCityClient teamCityClient = NastradamusClient.access$getTeamCityClient$p(this.this$0);
                                        Intrinsics.checkNotNullExpressionValue((Object)modificationId, (String)"modificationId");
                                        return teamCityClient.downloadChangesPatch(modificationId, isPersonal);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull JsonNode p1, @Nullable Continuation<? super String> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        System.out.println((Object)"Fetching changesets patches completed");
        return changesets2;
    }

    @NotNull
    public final List<ChangeEntity> getTeamCityChangesDetails() {
        System.out.println((Object)"Getting changes details from TeamCity ...");
        List changeDetails2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ChangeEntity>>, Object>(this, null){
            int label;
            final /* synthetic */ NastradamusClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List<JsonNode> changes = NastradamusClient.access$getTeamCityClient$p(this.this$0).getChanges();
                        this.label = 1;
                        Object object3 = TaskKt.mapConcurrently((Iterable)changes, 5, (Function2)new Function2<JsonNode, Continuation<? super List<? extends ChangeEntity>>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ NastradamusClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        JsonNode change = (JsonNode)this.L$0;
                                        TeamCityClient teamCityClient = NastradamusClient.access$getTeamCityClient$p(this.this$0);
                                        String string = change.findValue("id").asText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"change.findValue(\"id\").asText()");
                                        return teamCityClient.getChangeDetails(string);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull JsonNode p1, @Nullable Continuation<? super List<ChangeEntity>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return CollectionsKt.flatten((Iterable)((Iterable)object3));
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return CollectionsKt.flatten((Iterable)((Iterable)object3));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<ChangeEntity>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        System.out.println((Object)"Fetching changes details completed");
        return changeDetails2;
    }

    @NotNull
    public final BuildInfo getBuildInfo() {
        String string;
        JsonNode triggeredByInfo = this.teamCityClient.getTriggeredByInfo();
        JsonNode triggeredByBuild = triggeredByInfo.findValue("build");
        if (triggeredByBuild == null) {
            string = this.teamCityClient.getBuildId();
        } else {
            String string2 = triggeredByBuild.findValue("id").asText(this.teamCityClient.getBuildId());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"triggeredByBuild.findVal\u2026t(teamCityClient.buildId)");
        }
        String aggregatorBuildId = string;
        JsonNode buildInfo = this.teamCityClient.getBuildInfo();
        JsonNode jsonNode = buildInfo.findValue("branchName");
        String string3 = jsonNode != null ? jsonNode.asText("") : null;
        if (string3 == null) {
            string3 = "";
        }
        String branchName = string3;
        String string4 = this.teamCityClient.getBuildId();
        String string5 = this.teamCityClient.getOs();
        String string6 = this.teamCityClient.getBuildTypeId();
        JsonNode jsonNode2 = buildInfo.findValue("status");
        String string7 = jsonNode2 != null ? jsonNode2.asText("") : null;
        if (string7 == null) {
            string7 = "";
        }
        JsonNode jsonNode3 = buildInfo.findValue("statusText");
        String string8 = jsonNode3 != null ? jsonNode3.asText("") : null;
        if (string8 == null) {
            string8 = "";
        }
        return new BuildInfo(string4, aggregatorBuildId, branchName, string5, string6, string7, string8);
    }

    @NotNull
    public final Map<Class<?>, Integer> getRankedClasses() {
        Map map;
        System.out.println((Object)"Getting sorted (& bucketed) test classes from Nastradamus ...");
        try {
            map = (Map)ErrorThresholdKt.withErrorThreshold("NastradamusClient-getRankedClasses", 1, (Function0)new Function0<Map<Class<?>, ? extends Integer>>(this){
                final /* synthetic */ NastradamusClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<Class<?>, Integer> invoke() {
                    void $this$associateWith$iv;
                    Class it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    void $this$associateTo$iv$iv;
                    Object object;
                    Object item$iv$iv2;
                    void $this$mapTo$iv$iv;
                    List<ChangeEntity> changesets2 = this.this$0.getTeamCityChangesDetails();
                    Iterable $this$map$iv = this.this$0.getUnsortedClasses();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it2;
                        Class clazz = (Class)item$iv$iv2;
                        object = destination$iv$iv;
                        boolean bl = false;
                        String string = it2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        object.add(new TestCaseEntity(string));
                    }
                    List cases = (List)destination$iv$iv;
                    List<TestCaseEntity> sortedCases = this.this$0.sendSortingRequest(new SortRequestEntity(this.this$0.getBuildInfo(), changesets2, cases), TestCaseLoader.TEST_RUNNERS_COUNT, TestCaseLoader.TEST_RUNNER_INDEX, TestCaseLoader.IS_NASTRADAMUS_TEST_DISTRIBUTOR_ENABLED);
                    int rank = 0;
                    rank = 1;
                    Iterable $this$associate$iv = sortedCases;
                    boolean $i$f$associate = false;
                    int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    item$iv$iv2 = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv22);
                    boolean $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        Map map = destination$iv$iv2;
                        TestCaseEntity testCaseEntity = (TestCaseEntity)element$iv$iv;
                        boolean bl = false;
                        int n = rank;
                        rank = n + 1;
                        Pair pair = TuplesKt.to((Object)testCaseEntity.getName(), (Object)n);
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                    Map rankedTestClassesForCurrentBucket = destination$iv$iv2;
                    $this$associate$iv = this.this$0.getUnsortedClasses();
                    object = this.this$0;
                    boolean $i$f$filter = false;
                    void capacity$iv22 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Class)element$iv$iv;
                        boolean bl = false;
                        if (!rankedTestClassesForCurrentBucket.keySet().contains(it.getName())) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    NastradamusClient.access$setSortedClassesInCurrentBucket$p((NastradamusClient)object, CollectionsKt.toSet((Iterable)((List)destination$iv$iv3)));
                    $this$filter$iv = this.this$0.getUnsortedClasses();
                    object = this.this$0;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                    void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                        void clazz;
                        it = (Class)element$iv$iv;
                        T t = element$iv$iv;
                        Map map = result$iv;
                        boolean bl = false;
                        Integer n = (Integer)rankedTestClassesForCurrentBucket.get(clazz.getName());
                        Integer n2 = n != null ? n : Integer.MAX_VALUE;
                        map.put(t, n2);
                    }
                    NastradamusClient.access$setAllSortedClasses$p((NastradamusClient)object, result$iv);
                    System.out.println((Object)"Fetching sorted test classes from Nastradamus completed");
                    Map map = NastradamusClient.access$getAllSortedClasses$p(this.this$0);
                    if (map == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"allSortedClasses");
                        map = null;
                    }
                    return map;
                }
            }, (Function0)new Function0<Map<Class<?>, ? extends Integer>>(this){
                final /* synthetic */ NastradamusClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<Class<?>, Integer> invoke() {
                    return NastradamusClient.access$getRankedClasses$fallback(this.this$0);
                }
            });
        }
        catch (Throwable e) {
            System.err.println("Failure during sorting test classes via Nastradamus. Fallback to simple natural sorting.");
            this.allSortedClasses = NastradamusClient.getRankedClasses$fallback(this);
            Map map2 = this.allSortedClasses;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"allSortedClasses");
                map2 = null;
            }
            map = map2;
        }
        return map;
    }

    public final boolean isClassInBucket(@NotNull String testIdentifier, @NotNull Function1<? super String, Boolean> fallbackFunc) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter(fallbackFunc, (String)"fallbackFunc");
        if (this.allSortedClasses == null) {
            this.getRankedClasses();
        }
        boolean isMatch2 = (Boolean)ErrorThresholdKt.withErrorThreshold("NastradamusClient-isClassInBucket", 1, (Function0)new Function0<Boolean>(this, testIdentifier){
            final /* synthetic */ NastradamusClient this$0;
            final /* synthetic */ String $testIdentifier;
            {
                this.this$0 = $receiver;
                this.$testIdentifier = $testIdentifier;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block4: {
                    void $this$any$iv;
                    Set set = NastradamusClient.access$getSortedClassesInCurrentBucket$p(this.this$0);
                    if (set == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"sortedClassesInCurrentBucket");
                        set = null;
                    }
                    Iterable iterable = set;
                    String string = this.$testIdentifier;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Class it = (Class)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)string)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }, (Function0)new Function0<Boolean>(testIdentifier, fallbackFunc){
            final /* synthetic */ String $testIdentifier;
            final /* synthetic */ Function1<String, Boolean> $fallbackFunc;
            {
                this.$testIdentifier = $testIdentifier;
                this.$fallbackFunc = $fallbackFunc;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                System.err.println("Couldn't find appropriate bucket for " + this.$testIdentifier + " via Nastradamus");
                return (Boolean)this.$fallbackFunc.invoke((Object)this.$testIdentifier);
            }
        });
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Nastradamus. Class " + testIdentifier + " matches current bucket " + TestCaseLoader.TEST_RUNNER_INDEX + " - " + isMatch2));
        }
        return isMatch2;
    }

    private static final TestClassResultEntity collectTestRunResults$lambda$4$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TestClassResultEntity)$tmp0.invoke(p0, p1);
    }

    private static final TestClassResultEntity collectTestRunResults$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TestClassResultEntity)$tmp0.invoke(p0);
    }

    private static final Map<Class<?>, Integer> getRankedClasses$fallback(NastradamusClient this$0) {
        int rank = 0;
        rank = 1;
        Iterable $this$sortedBy$iv = this$0.unsortedClasses;
        boolean $i$f$sortedBy = false;
        Iterable $this$associateWith$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Class it = (Class)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Class)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Class clazz = (Class)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            int n = rank;
            rank = n + 1;
            Integer n2 = n;
            map.put(t, n2);
        }
        return result$iv;
    }

    public static final /* synthetic */ ObjectMapper access$getJacksonMapper$cp() {
        return jacksonMapper;
    }

    public static final /* synthetic */ TeamCityClient access$getTeamCityClient$p(NastradamusClient $this) {
        return $this.teamCityClient;
    }

    public static final /* synthetic */ void access$setSortedClassesInCurrentBucket$p(NastradamusClient $this, Set set) {
        $this.sortedClassesInCurrentBucket = set;
    }

    public static final /* synthetic */ void access$setAllSortedClasses$p(NastradamusClient $this, Map map) {
        $this.allSortedClasses = map;
    }

    public static final /* synthetic */ Map access$getAllSortedClasses$p(NastradamusClient $this) {
        return $this.allSortedClasses;
    }

    public static final /* synthetic */ Map access$getRankedClasses$fallback(NastradamusClient this$0) {
        return NastradamusClient.getRankedClasses$fallback(this$0);
    }

    public static final /* synthetic */ Set access$getSortedClassesInCurrentBucket$p(NastradamusClient $this) {
        return $this.sortedClassesInCurrentBucket;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/nastradamus/NastradamusClient$Companion;", "", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "intellij.platform.testFramework.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

