/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrackingIOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveTestResults(File tracesDirectory, String name, Map<Object, boolean[]> trace) throws IOException {
        File traceFile = new File(tracesDirectory, name + ".tr");
        if (!traceFile.exists()) {
            traceFile.createNewFile();
        }
        DataOutputStream os = null;
        try {
            os = new DataOutputStream(new FileOutputStream(traceFile));
            int size = trace.size();
            os.writeInt(size);
            int entries = 0;
            for (Map.Entry<Object, boolean[]> entry : trace.entrySet()) {
                int idx;
                if (entries >= size) break;
                ++entries;
                os.writeUTF(entry.getKey().toString());
                boolean[] oldLines = entry.getValue();
                boolean[] lines = new boolean[oldLines.length];
                System.arraycopy(oldLines, 0, lines, 0, lines.length);
                int numberOfTraces = 0;
                for (idx = 1; idx < lines.length; ++idx) {
                    if (!lines[idx]) continue;
                    ++numberOfTraces;
                }
                os.writeInt(numberOfTraces);
                for (idx = 1; idx < lines.length; ++idx) {
                    boolean incl = lines[idx];
                    if (!incl) continue;
                    os.writeInt(idx);
                }
            }
            Object var15_14 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (os == null) throw throwable;
            os.close();
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Map<String, int[]>> loadTestTrackingData(File tracesDirectory) throws IOException {
        File[] traces = tracesDirectory.listFiles();
        HashMap<String, Map<String, int[]>> result = new HashMap<String, Map<String, int[]>>();
        if (traces == null) {
            return result;
        }
        File[] fileArray = traces;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            HashMap<String, int[]> classes;
            String name;
            block8: {
                Object var18_17;
                if (n2 >= n) {
                    return result;
                }
                File traceFile = fileArray[n2];
                String fileName = traceFile.getName();
                name = fileName.substring(0, fileName.length() - ".tr".length());
                classes = new HashMap<String, int[]>();
                DataInputStream is = null;
                try {
                    is = new DataInputStream(new FileInputStream(traceFile));
                    int size = is.readInt();
                    for (int i = 0; i < size; ++i) {
                        String className = is.readUTF();
                        int lines = is.readInt();
                        int[] coveredLines = new int[lines];
                        for (int j = 0; j < lines; ++j) {
                            coveredLines[j] = is.readInt();
                        }
                        classes.put(className, coveredLines);
                    }
                    var18_17 = null;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    var18_17 = null;
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            result.put(name, classes);
            ++n2;
        }
    }
}

