/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LineMapper<T extends CoverageData> {
    protected abstract T createNewLine(T var1, int var2);

    protected abstract T[] createArray(int var1);

    protected abstract T[] getLines(ClassData var1);

    public T[] mapLines(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        CoverageData[] oldLines = this.getLines(sourceClassData);
        if (linesMap == null) {
            return oldLines;
        }
        if (sourceClassData == targetClassData && oldLines == null) {
            return null;
        }
        try {
            CoverageData[] sourceLines = this.getSourceLinesArray(linesMap, sourceClassData, targetClassData);
            CoverageData[] targetLines = this.getLines(targetClassData);
            for (LineMapData mapData : linesMap) {
                for (int index = 0; index < mapData.getCount(); ++index) {
                    CoverageData source;
                    CoverageData targetLineData;
                    int sourceLineNumber = mapData.getSourceLine(index);
                    if (!sourceClassData.isIgnoredLine(sourceLineNumber) && ArrayUtil.safeLoad(sourceLines, sourceLineNumber) == null && (targetLineData = ArrayUtil.safeLoad(targetLines, mapData.getMappingStart(index))) != null) {
                        source = this.createNewLine(targetLineData, sourceLineNumber);
                        ArrayUtil.safeStore(sourceLines, sourceLineNumber, source);
                    }
                    for (int targetLineNumber = mapData.getMappingStart(index); targetLineNumber < mapData.getMappingEnd(index); ++targetLineNumber) {
                        source = ArrayUtil.safeLoad(sourceLines, sourceLineNumber);
                        CoverageData target = ArrayUtil.safeLoad(targetLines, targetLineNumber);
                        if (target == null) continue;
                        if (source != null) {
                            source.merge(target);
                        }
                        if (sourceClassData == targetClassData && targetLineNumber == sourceLineNumber) continue;
                        targetLines[targetLineNumber] = null;
                    }
                }
            }
            return sourceLines;
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Error creating line mappings for " + targetClassData.getName(), e);
            return oldLines;
        }
    }

    private T[] getSourceLinesArray(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        int maxMappedSourceLineNumber = LineMapper.maxSourceLineNumber(linesMap);
        CoverageData[] currentLines = this.getLines(sourceClassData);
        if (targetClassData == sourceClassData) {
            return currentLines;
        }
        if (currentLines == null) {
            return this.createArray(1 + maxMappedSourceLineNumber);
        }
        if (currentLines.length >= 1 + maxMappedSourceLineNumber) {
            return currentLines;
        }
        CoverageData[] sourceLines = this.createArray(1 + maxMappedSourceLineNumber);
        System.arraycopy(currentLines, 0, sourceLines, 0, currentLines.length);
        return sourceLines;
    }

    public static <T> void dropMappedLines(FileMapData[] mappings, T[] lines, String className) {
        for (FileMapData mapData : mappings) {
            boolean isThisClass = className.equals(mapData.getClassName());
            for (LineMapData lineMapData : mapData.getLines()) {
                for (int index = 0; index < lineMapData.getCount(); ++index) {
                    int sourceLineNumber = lineMapData.getSourceLine(index);
                    for (int i = lineMapData.getMappingStart(index); i < lineMapData.getMappingEnd(index) && i < lines.length; ++i) {
                        if (isThisClass && i == sourceLineNumber) continue;
                        lines[i] = null;
                    }
                }
            }
        }
    }

    private static int maxSourceLineNumber(LineMapData[] linesMap) {
        int max = 0;
        for (LineMapData mapData : linesMap) {
            for (int index = 0; index < mapData.getCount(); ++index) {
                max = Math.max(max, mapData.getSourceLine(index));
            }
        }
        return max;
    }
}

