/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.offline;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.offline.ClassLengthAnalyser;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineCoverageTransformer
extends CoverageTransformer {
    public OfflineCoverageTransformer(ProjectData data, boolean shouldSaveSource, List<Pattern> excludePatterns, List<Pattern> includePatterns) {
        super(data, shouldSaveSource, excludePatterns, includePatterns);
    }

    @Override
    protected CoverageDataAccess.Init createInit(String className, ClassReader cr, boolean branchCoverage) {
        int length = OfflineCoverageTransformer.getRequiredArrayLength(cr, branchCoverage);
        return new CoverageDataAccess.Init("__$hits$__", "[I", "com/intellij/rt/coverage/offline/RawProjectInit", "getOrCreateHitsMask", "(Ljava/lang/String;I)[I", new Object[]{className, length});
    }

    @Override
    protected CoverageDataAccess.Init createCondyInit(String className, ClassReader cr, boolean branchCoverage) {
        int length = OfflineCoverageTransformer.getRequiredArrayLength(cr, branchCoverage);
        return new CoverageDataAccess.Init("__$hits$__", "[I", "com/intellij/rt/coverage/util/CondyUtils", "getOrCreateHitsMask", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;I)[I", new Object[]{className, length});
    }

    private static int getRequiredArrayLength(ClassReader cr, boolean branchCoverage) {
        ClassLengthAnalyser analyser = OfflineCoverageTransformer.analyseClassLength(cr);
        return branchCoverage ? analyser.getHits() : analyser.getMaxLine() + 1;
    }

    private static ClassLengthAnalyser analyseClassLength(ClassReader cr) {
        ClassLengthAnalyser analyser = new ClassLengthAnalyser();
        cr.accept(analyser, 4);
        return analyser;
    }
}

