/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR45Util {
    private static final String FILE_SECTION = "*F\n";
    private static final String LINE_SECTION = "*L\n";
    private static final String SECTION_SEPARATOR = "*";
    private static final LineMapData[] EMPTY_LINE_MAP = new LineMapData[0];

    private static boolean isSmap(String debug) {
        return debug.startsWith("SMAP");
    }

    public static FileMapData[] extractLineMapping(String debug, String className) {
        if (!JSR45Util.isSmap(debug)) {
            return null;
        }
        TIntObjectHashMap<ArrayList<LineMapData>> linesMap = new TIntObjectHashMap<ArrayList<LineMapData>>();
        int fileSectionIdx = debug.indexOf(FILE_SECTION);
        int lineInfoIdx = debug.indexOf(LINE_SECTION);
        List<FileInfo> fileNames = JSR45Util.parseFileNames(debug, fileSectionIdx, lineInfoIdx, className);
        int lineInfoStart = lineInfoIdx + LINE_SECTION.length();
        int lineInfoEnd = debug.indexOf(SECTION_SEPARATOR, lineInfoStart);
        String lineInfo = debug.substring(lineInfoStart, lineInfoEnd);
        String[] lines = lineInfo.split("\n");
        int fileId = 1;
        for (String line : lines) {
            int startOutLine;
            int startSrcLine;
            int repeat = 1;
            int outLineInc = 1;
            int idx = line.indexOf(58);
            String srcLine = line.substring(0, idx);
            String outLine = line.substring(idx + 1);
            int srcCommaIdx = srcLine.indexOf(44);
            int sharpIdx = srcLine.indexOf(35);
            if (sharpIdx > -1) {
                startSrcLine = Integer.parseInt(srcLine.substring(0, sharpIdx));
                if (srcCommaIdx > -1) {
                    repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                    fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1, srcCommaIdx));
                } else {
                    fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1));
                }
            } else if (srcCommaIdx > -1) {
                repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                startSrcLine = Integer.parseInt(srcLine.substring(0, srcCommaIdx));
            } else {
                startSrcLine = Integer.parseInt(srcLine);
            }
            int outCommaIdx = outLine.indexOf(44);
            if (outCommaIdx > -1) {
                outLineInc = Integer.parseInt(outLine.substring(outCommaIdx + 1));
                startOutLine = Integer.parseInt(outLine.substring(0, outCommaIdx));
            } else {
                startOutLine = Integer.parseInt(outLine);
            }
            ArrayList<LineMapData> currentFile = (ArrayList<LineMapData>)linesMap.get(fileId);
            if (currentFile == null) {
                currentFile = new ArrayList<LineMapData>();
                linesMap.put(fileId, currentFile);
            }
            currentFile.add(new LineMapData(startSrcLine, repeat, startOutLine, outLineInc));
        }
        FileMapData[] result = new FileMapData[fileNames.size()];
        for (int i = 0; i < result.length; ++i) {
            FileInfo fileInfo = fileNames.get(i);
            List mappings = (List)linesMap.get(fileInfo.myIndex);
            LineMapData[] array = mappings == null ? EMPTY_LINE_MAP : mappings.toArray(EMPTY_LINE_MAP);
            result[i] = new FileMapData(fileInfo.myPath, fileInfo.myName, array);
        }
        return result;
    }

    private static String[] getFileSectionLines(String debug, int fileSectionIdx, int lineInfoIdx) {
        String fileSection = debug.substring(fileSectionIdx + FILE_SECTION.length(), lineInfoIdx);
        if ((fileSection = fileSection.trim()).endsWith("\n")) {
            fileSection = fileSection.substring(0, fileSection.length() - 1);
        }
        return fileSection.split("\n");
    }

    private static List<FileInfo> parseFileNames(String debug, int fileSectionIdx, int lineInfoIdx, String className) {
        int i;
        String defaultPrefix = JSR45Util.getClassPackageName(className);
        String[] fileLines = JSR45Util.getFileSectionLines(debug, fileSectionIdx, lineInfoIdx);
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        boolean generatedPrefix = true;
        for (i = 0; i < fileLines.length; ++i) {
            String fileInfoLine;
            String idAndName = fileInfoLine = fileLines[i];
            String path = null;
            if (fileInfoLine.startsWith("+ ")) {
                idAndName = fileInfoLine.substring(2);
                path = fileLines[++i];
            }
            int idx = idAndName.indexOf(" ");
            int key = Integer.parseInt(idAndName.substring(0, idx));
            String fileName = idAndName.substring(idx + 1);
            path = path == null ? fileName : JSR45Util.processRelative(path);
            int lastDot = path.lastIndexOf(".");
            String pathWithDots = ClassNameUtil.convertToFQName(lastDot < 0 ? path : path.substring(0, lastDot) + "_" + path.substring(lastDot + 1));
            generatedPrefix &= !pathWithDots.startsWith(defaultPrefix);
            result.add(new FileInfo(fileName, pathWithDots, key));
        }
        if (generatedPrefix) {
            for (i = 0; i < result.size(); ++i) {
                FileInfo fileInfo = (FileInfo)result.get(i);
                result.set(i, new FileInfo(fileInfo.myName, defaultPrefix + fileInfo.myPath, fileInfo.myIndex));
            }
        }
        return result;
    }

    public static String processRelative(String fileName) {
        int idx;
        while ((idx = fileName.indexOf("..")) > -1) {
            String rest = fileName.substring(idx + "..".length());
            String start = fileName.substring(0, idx);
            if (!start.endsWith("/")) {
                return fileName;
            }
            int endIndex = (start = start.substring(0, start.length() - 1)).lastIndexOf(47);
            if (endIndex > -1) {
                fileName = start.substring(0, endIndex) + rest;
                continue;
            }
            fileName = rest.startsWith("/") ? rest.substring(1) : rest;
        }
        return fileName;
    }

    public static String getClassPackageName(String className) {
        String generatePrefix = "";
        int fqnLastDotIdx = className.lastIndexOf(".");
        if (fqnLastDotIdx > -1) {
            generatePrefix = className.substring(0, fqnLastDotIdx + 1);
        }
        return generatePrefix;
    }

    public static List<String> parseSourcePaths(String debug) {
        if (!JSR45Util.isSmap(debug)) {
            return Collections.emptyList();
        }
        String[] fileNameIdx = JSR45Util.getFileSectionLines(debug, debug.indexOf(FILE_SECTION), debug.indexOf(LINE_SECTION));
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < fileNameIdx.length; ++i) {
            String fileName;
            String idAndName = fileName = fileNameIdx[i];
            String path = null;
            if (fileName.startsWith("+ ")) {
                idAndName = fileName.substring(2);
                path = fileNameIdx[++i];
            }
            int idx = idAndName.indexOf(" ");
            String currentClassName = idAndName.substring(idx + 1);
            if (path == null) {
                path = currentClassName;
            } else {
                int lastSlashIdx = (path = JSR45Util.processRelative(path)).lastIndexOf("/");
                if (lastSlashIdx > 0) {
                    path = path.substring(0, ++lastSlashIdx) + currentClassName;
                }
            }
            paths.add(path);
        }
        return paths;
    }

    private static class FileInfo {
        private final String myName;
        private final String myPath;
        private final int myIndex;

        public FileInfo(String name, String path, int index) {
            this.myName = name;
            this.myPath = path;
            this.myIndex = index;
        }
    }
}

