/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxBuiltInTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;

public class JavaFxPropertyTagDescriptor
implements XmlElementDescriptor {
    private final PsiClass myPsiClass;
    private final String myName;
    private final boolean myStatic;

    public JavaFxPropertyTagDescriptor(PsiClass psiClass, String name, boolean isStatic) {
        this.myPsiClass = psiClass;
        this.myName = name;
        this.myStatic = isStatic;
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        PsiElement declaration = this.getDeclaration();
        PsiType propertyType = JavaFxPsiUtil.getWritablePropertyType(this.myPsiClass, declaration);
        if (propertyType != null) {
            ArrayList<XmlElementDescriptor> descriptors = new ArrayList<XmlElementDescriptor>();
            for (String name : FxmlConstants.FX_BUILT_IN_TAGS) {
                descriptors.add(new JavaFxBuiltInTagDescriptor(name, null));
            }
            PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)propertyType, (GlobalSearchScope)declaration.getResolveScope());
            if (collectionItemType != null) {
                JavaFxPropertyTagDescriptor.collectSubclassesDescriptors(collectionItemType, descriptors, (PsiElement)context);
            } else if (!JavaFxPsiUtil.isPrimitiveOrBoxed(propertyType)) {
                JavaFxPropertyTagDescriptor.collectSubclassesDescriptors(propertyType, descriptors, (PsiElement)context);
            }
            if (!descriptors.isEmpty()) {
                return descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
            }
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    private static void collectSubclassesDescriptors(@Nullable PsiType psiType, @NotNull List<XmlElementDescriptor> descriptors, @NotNull PsiElement context) {
        PsiClass aClass;
        if (descriptors == null) {
            JavaFxPropertyTagDescriptor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaFxPropertyTagDescriptor.$$$reportNull$$$0(1);
        }
        if ((aClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null) {
            if ("java.lang.Object".equals(aClass.getQualifiedName())) {
                JavaFxPropertyTagDescriptor.collectRawPropertyDescriptors(descriptors, context);
                return;
            }
            ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, psiClass);
                return true;
            });
            JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, aClass);
        }
    }

    private static void collectRawPropertyDescriptors(@NotNull List<XmlElementDescriptor> descriptors, @NotNull PsiElement context) {
        if (descriptors == null) {
            JavaFxPropertyTagDescriptor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JavaFxPropertyTagDescriptor.$$$reportNull$$$0(3);
        }
        Project project = context.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, facade.findClass("java.lang.String", scope));
        JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, facade.findClass("java.lang.Double", scope));
        JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, facade.findClass("java.lang.Integer", scope));
        JavaFxPropertyTagDescriptor.addElementDescriptor(descriptors, facade.findClass("java.lang.Boolean", scope));
    }

    private static void addElementDescriptor(@NotNull List<XmlElementDescriptor> descriptors, @Nullable PsiClass aClass) {
        if (descriptors == null) {
            JavaFxPropertyTagDescriptor.$$$reportNull$$$0(4);
        }
        if (!(aClass == null || "java.lang.Object".equals(aClass.getQualifiedName()) || aClass.isInterface() || PsiUtil.isAbstractClass((PsiClass)aClass) || PsiUtil.isInnerClass((PsiClass)aClass) || !JavaFxPsiUtil.isAbleToInstantiate(aClass))) {
            descriptors.add(new JavaFxClassTagDescriptor(aClass.getName(), aClass));
        }
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        return JavaFxClassTagDescriptorBase.createTagDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        PsiElement declaration = this.getDeclaration();
        PsiType propertyType = JavaFxPsiUtil.getWritablePropertyType(this.myPsiClass, declaration);
        if (InheritanceUtil.isInheritor((PsiType)propertyType, (String)"java.util.Map")) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        if (this.myPsiClass == null) {
            return null;
        }
        if (this.myStatic) {
            return JavaFxPsiUtil.findStaticPropertySetter(this.myName, this.myPsiClass);
        }
        return (PsiElement)JavaFxPsiUtil.getWritableProperties(this.myPsiClass).get(this.myName);
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        if (this.myPsiClass != null && this.myStatic) {
            return StringUtil.getQualifiedName((String)this.myPsiClass.getName(), (String)StringUtil.notNullize((String)this.myName));
        }
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public String toString() {
        return "<" + (this.myStatic ? "static " : "") + (String)(this.myPsiClass != null ? this.myPsiClass.getName() + "#" : "?#") + this.myName + ">";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxPropertyTagDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSubclassesDescriptors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectRawPropertyDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

