/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.rt.testng.TestNGXmlSuiteHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.execution.ParametersListUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.SuiteGenerator;
import org.testng.xml.XmlSuite;

public class SearchingForTestsTask
extends SearchForTestsTask {
    private static final Logger LOG = Logger.getInstance(SearchingForTestsTask.class);
    protected final Map<PsiClass, Map<PsiMethod, List<String>>> myClasses;
    private final TestData myData;
    private final TestNGConfiguration myConfig;
    private final File myTempFile;

    public SearchingForTestsTask(ServerSocket serverSocket, TestNGConfiguration config, File tempFile) {
        super(config.getProject(), serverSocket);
        this.myData = config.getPersistantData();
        this.myConfig = config;
        this.myTempFile = tempFile;
        this.myClasses = new LinkedHashMap<PsiClass, Map<PsiMethod, List<String>>>();
    }

    protected void onFound() {
        if (!this.myClasses.isEmpty()) {
            this.composeTestSuiteFromClasses();
        } else if (TestType.SUITE.getType().equals(this.myData.TEST_OBJECT)) {
            try {
                this.composeTestSuiteFromXml();
            }
            catch (CantRunException e) {
                this.logCantRunException((ExecutionException)e);
            }
        }
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])"end".getBytes(StandardCharsets.UTF_8), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void search() throws CantRunException {
        this.myClasses.clear();
        this.fillTestObjects(this.myClasses);
    }

    protected void logCantRunException(ExecutionException e) {
        try {
            String message = "CantRunException" + e.getMessage() + "\n";
            FileUtil.writeToFile((File)this.myTempFile, (byte[])message.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
    }

    private void composeTestSuiteFromClasses() {
        File xmlFile;
        LinkedHashMap map = new LinkedHashMap();
        boolean findTestMethodsForClass = this.shouldSearchForTestMethods();
        for (Map.Entry<PsiClass, Map<PsiMethod, List<String>>> entry : this.myClasses.entrySet()) {
            String className;
            Map<PsiMethod, List<String>> depMethods = entry.getValue();
            LinkedHashMap<String, List<String>> methods = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<PsiMethod, List<String>> method : depMethods.entrySet()) {
                methods.put(method.getKey().getName(), method.getValue());
            }
            if (findTestMethodsForClass && depMethods.isEmpty()) {
                for (PsiMethod method : entry.getKey().getMethods()) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) continue;
                    methods.put(method.getName(), Collections.emptyList());
                }
            }
            if ((className = (String)ReadAction.compute(() -> ClassUtil.getJVMClassName((PsiClass)((PsiClass)entry.getKey())))) == null) continue;
            map.put(className, methods);
        }
        Set<String> groupNames = this.myConfig.calculateGroupNames();
        Map<String, String> testParams = this.buildTestParameters();
        int logLevel = 1;
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(this.myConfig.getVMParameters().getBytes(StandardCharsets.UTF_8)));
            String verbose = properties.getProperty("-Dtestng.verbose");
            if (verbose != null) {
                logLevel = Integer.parseInt(verbose);
            }
        }
        catch (Exception properties) {
            // empty catch block
        }
        if (groupNames != null) {
            LinkedHashMap<String, Collection<String>> methodNames = new LinkedHashMap<String, Collection<String>>();
            for (Map.Entry entry : map.entrySet()) {
                methodNames.put((String)entry.getKey(), ((Map)entry.getValue()).keySet());
            }
            LaunchSuite suite = SuiteGenerator.createSuite(this.myProject.getName(), null, methodNames, groupNames, testParams, "jdk", logLevel);
            xmlFile = suite.save(new File(PathManager.getSystemPath()));
        } else {
            XmlSuite suite = new XmlSuite();
            suite.setParameters(testParams);
            String programParameters = this.myConfig.getProgramParameters();
            if (programParameters != null && ParametersListUtil.parse((String)programParameters).contains("-threadcount")) {
                suite.setThreadCount(-1);
            }
            xmlFile = TestNGXmlSuiteHelper.writeSuite(map, (String)this.myProject.getName(), (String)PathManager.getSystemPath(), (TestNGXmlSuiteHelper.Logger)new TestNGXmlSuiteHelper.Logger(){

                public void log(Throwable e) {
                    LOG.error(e);
                }
            }, (boolean)this.requireToDowngradeToHttp(), (XmlSuite)suite);
        }
        String path = xmlFile.getAbsolutePath() + "\n";
        try {
            FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(StandardCharsets.UTF_8), (boolean)true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean requireToDowngradeToHttp() {
        GlobalSearchScope searchScope = (GlobalSearchScope)ObjectUtils.notNull((Object)this.myConfig.getSearchScope(), (Object)GlobalSearchScope.allScope((Project)this.myProject));
        PsiClass testMarker = JavaPsiFacade.getInstance((Project)this.myProject).findClass(TestNGUtil.TEST_ANNOTATION_FQN, searchScope);
        String version = SearchingForTestsTask.getVersion(testMarker);
        return version == null || StringUtil.compareVersionNumbers((String)version, (String)"7.0.0") < 0;
    }

    private static String getVersion(PsiClass classFromCommon) {
        String name;
        VirtualFile localFile;
        VirtualFileSystem fileSystem;
        ProjectFileIndex index;
        VirtualFile root;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)classFromCommon);
        if (virtualFile != null && (root = (index = ProjectFileIndex.getInstance((Project)classFromCommon.getProject())).getClassRootForFile(virtualFile)) != null && (fileSystem = root.getFileSystem()) instanceof JarFileSystem && (localFile = ((JarFileSystem)fileSystem).getLocalVirtualFileFor(root)) != null && (name = localFile.getNameWithoutExtension()).startsWith("testng-")) {
            return StringUtil.trimStart((String)name, (String)"testng-");
        }
        return null;
    }

    private boolean shouldSearchForTestMethods() {
        for (Map<PsiMethod, List<String>> methods : this.myClasses.values()) {
            if (methods.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void composeTestSuiteFromXml() throws CantRunException {
        Map<String, String> buildTestParams = this.buildTestParameters();
        try {
            if (buildTestParams.isEmpty()) {
                String path = new File(this.myData.getSuiteName()).getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(StandardCharsets.UTF_8), (boolean)true);
                return;
            }
            Parser parser = new Parser(new FileInputStream(this.myData.getSuiteName()));
            parser.setLoadClasses(false);
            Collection<XmlSuite> suites = parser.parse();
            for (XmlSuite suite : suites) {
                Map<String, String> params = suite.getParameters();
                params.putAll(buildTestParams);
                String fileId = FileUtil.sanitizeFileName((String)(this.myProject.getName() + "_" + suite.getName() + "_" + Integer.toHexString(suite.getName().hashCode()) + ".xml"));
                File suiteFile = new File(PathManager.getSystemPath(), fileId);
                try (FileWriter fileWriter = new FileWriter(suiteFile, StandardCharsets.UTF_8);){
                    fileWriter.write(suite.toXml());
                }
                String path = suiteFile.getAbsolutePath() + "\n";
                FileUtil.writeToFile((File)this.myTempFile, (byte[])path.getBytes(StandardCharsets.UTF_8), (boolean)true);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new CantRunException(TestngBundle.message("dialog.message.unable.to.parse.suite", e.getMessage()));
        }
    }

    protected void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestNGTestObject.fromConfig(this.myConfig).fillTestObjects(classes);
    }

    private Map<String, String> buildTestParameters() {
        File propertiesFile;
        HashMap<String, String> testParams = new HashMap<String, String>();
        if (this.myData.PROPERTIES_FILE != null && (propertiesFile = new File(this.myData.PROPERTIES_FILE)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> testParams.put((String)key, (String)value)));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        testParams.putAll(this.myData.TEST_PROPERTIES);
        return testParams;
    }
}

