/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.statistics.FusAwareActionGroup;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\tB\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup;", "T", "", "Lcom/intellij/profiler/statistics/FusAwareActionGroup;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;)V", "createImage", "Ljava/awt/image/BufferedImage;", "ImageTransferable", "intellij.profiler.common"})
public class CaptureImageActionGroup<T>
extends FusAwareActionGroup {
    @NotNull
    private final FlameGraphPanel<T> flameGraphPanel;

    public CaptureImageActionGroup(@NotNull FlameGraphPanel<T> flameGraphPanel2) {
        Intrinsics.checkNotNullParameter(flameGraphPanel2, (String)"flameGraphPanel");
        super(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_CAPTURE_IMAGE, null, 2, null);
        this.flameGraphPanel = flameGraphPanel2;
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Dump);
        this.getTemplatePresentation().setText(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture", new Object[0]));
        this.setPopup(true);
        String string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.toClipboard", new Object[0]);
        this.add((AnAction)new DumbAwareAction(string){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.Companion.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.Companion, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_COPY_IMAGE, e, null, 4, null);
                CopyPasteManager.getInstance().setContents((Transferable)new ImageTransferable(this.createImage()));
            }
        });
        string = CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.save", new Object[0]);
        this.add((AnAction)new DumbAwareAction(string){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProfilerUsageTriggerCollector.Companion.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.Companion, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.FG_SAVE_IMAGE, e, null, 4, null);
                String[] stringArray = new String[]{"png"};
                FileSaverDescriptor descriptor = new FileSaverDescriptor(CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), CommonProfilerBundleKt.profilerMessage("ui.flamechart.actions.capture.saveImage", new Object[0]), stringArray);
                FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, e.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance().createSave\u2026og(descriptor, e.project)");
                FileSaverDialog dialog2 = fileSaverDialog;
                VirtualFileWrapper file = dialog2.save("flamegraph.png");
                if (file != null) {
                    ImageIO.write((RenderedImage)this.createImage(), "png", file.getFile());
                }
            }
        });
    }

    @NotNull
    public final BufferedImage createImage() {
        Rectangle bounds2 = this.flameGraphPanel.getVisibleRect();
        BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)((Object)this.flameGraphPanel)), (int)bounds2.width, (int)bounds2.height, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(flameGraphPa\u2026fferedImage.TYPE_INT_RGB)");
        BufferedImage image = bufferedImage;
        Graphics2D graphics = image.createGraphics();
        graphics.translate(-bounds2.x, -bounds2.y);
        this.flameGraphPanel.paint(graphics);
        return image;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/flamegraph/CaptureImageActionGroup$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "intellij.profiler.common"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final BufferedImage image;

        public ImageTransferable(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@Nullable DataFlavor flavor) {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

