/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.parser.panels;

import com.intellij.profiler.eventtrace.intervals.ColorizeTimelineInterval;
import com.intellij.profiler.eventtrace.intervals.TextualTimelineInterval;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/eventtrace/parser/panels/TextDefaultTimelineCellRenderer;", "T", "F", "Lcom/intellij/profiler/ui/timeline/DefaultTimelineCellRenderer;", "()V", "paint", "", "panel", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "g", "Ljava/awt/Graphics2D;", "node", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "intellij.profiler.common"})
public class TextDefaultTimelineCellRenderer<T, F>
extends DefaultTimelineCellRenderer<T, F> {
    @Override
    public void paint(@NotNull TimelineComponent<?, F> panel2, @NotNull Graphics2D g, @NotNull TimelineModel.TimelineInterval<F> node2) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        super.paint(panel2, g, node2);
        if (node2 instanceof TextualTimelineInterval && ((TextualTimelineInterval)node2).getText() != null) {
            String string = ((TextualTimelineInterval)node2).getText();
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.isBlank((CharSequence)string)) {
                double aQuarter = (double)panel2.getRowHeight() / 8.0;
                AffineTransform transform2 = g.getTransform();
                double scaleX = 1.0 / transform2.getScaleX();
                double scaleY = 1.0 / transform2.getScaleY();
                Rectangle $this$paint_u24lambda_u240 = g.getClipBounds();
                boolean bl = false;
                Rectangle2D.Double outerRect = new Rectangle2D.Double($this$paint_u24lambda_u240.x, aQuarter, $this$paint_u24lambda_u240.width, (double)panel2.getRowHeight() - 2.0 * aQuarter);
                int border = 2;
                Rectangle2D.Double innerRect = new Rectangle2D.Double(outerRect.x + scaleX, outerRect.y + scaleY, outerRect.width - scaleX * (double)2, outerRect.height - scaleY * (double)2);
                if (outerRect.width > 10.0) {
                    Color color2;
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    double boundWidth = innerRect.width - (double)border;
                    double boundHeight = innerRect.height;
                    if (node2 instanceof ColorizeTimelineInterval && ((ColorizeTimelineInterval)node2).getColor() != null) {
                        JBColor jBColor = ((ColorizeTimelineInterval)node2).getColor();
                        Intrinsics.checkNotNull((Object)jBColor);
                        JBColor color3 = jBColor;
                        int sum = color3.getBlue() + color3.getRed() + color3.getGreen();
                        color2 = sum > 381 ? Color.BLACK : Color.LIGHT_GRAY;
                    } else {
                        color2 = (Color)JBColor.BLACK;
                    }
                    g.setColor(color2);
                    FontRenderContext fontRendererContext = new FontRenderContext(null, true, true);
                    g.setFont((Font)JBFont.label().deriveFont((float)(innerRect.height * 0.72)).asPlain());
                    Rectangle2D stringBounds = g.getFont().getStringBounds(((TextualTimelineInterval)node2).getText(), fontRendererContext);
                    int textHeight = (int)((boundHeight + stringBounds.getHeight()) / (double)2);
                    int textWidth = stringBounds.getWidth() <= boundWidth ? Math.max(border, (int)((boundWidth - stringBounds.getWidth()) / (double)2)) : border;
                    String string2 = ((TextualTimelineInterval)node2).getText();
                    Intrinsics.checkNotNull((Object)string2);
                    g.drawString(string2, textWidth + (int)innerRect.x, textHeight);
                }
            }
        }
    }
}

