/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Calendar;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0003\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"formatTabName", "", "format", "Lcom/intellij/profiler/CommonProfilerUiOptions$TabNameFormat;", "defaultName", "time", "", "existingNames", "", "isToday", "", "intellij.profiler.common"})
public final class ProfilerToolWindowManagerKt {
    @NlsSafe
    private static final String formatTabName(CommonProfilerUiOptions.TabNameFormat format, String defaultName, long time, Collection<String> existingNames2) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                string = defaultName;
                break;
            }
            case 2: {
                String string2 = time > 0L ? DateFormatUtil.formatDateTime((long)time) : defaultName;
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (time > 0) DateFormat\u2026me(time) else defaultName");
                break;
            }
            case 3: {
                String string3 = time > 0L ? (ProfilerToolWindowManagerKt.isToday(time) ? DateFormatUtil.formatTime((long)time) : DateFormatUtil.formatDateTime((long)time)) : defaultName;
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (time > 0) {\n      if\u2026   }\n    else defaultName");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String tabName = string;
        String string4 = UniqueNameGenerator.generateUniqueName((String)tabName, (String)"", (String)"", (String)" (", (String)")", arg_0 -> ProfilerToolWindowManagerKt.formatTabName$lambda$0((Function1)new Function1<String, Boolean>(existingNames2){
            final /* synthetic */ Collection<String> $existingNames;
            {
                this.$existingNames = $existingNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return !this.$existingNames.contains(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"existingNames: Collectio\u2026stingNames.contains(it) }");
        return string4;
    }

    static /* synthetic */ String formatTabName$default(CommonProfilerUiOptions.TabNameFormat tabNameFormat, String string, long l, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ProfilerToolWindowManagerKt.formatTabName(tabNameFormat, string, l, collection);
    }

    private static final boolean isToday(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Clock.getTime());
        Pair pair = TuplesKt.to((Object)c.get(1), (Object)c.get(6));
        int currentYear = ((Number)pair.component1()).intValue();
        int currentDayOfYear = ((Number)pair.component2()).intValue();
        c.setTimeInMillis(time);
        Pair pair2 = TuplesKt.to((Object)c.get(1), (Object)c.get(6));
        int year = ((Number)pair2.component1()).intValue();
        int dayOfYear = ((Number)pair2.component2()).intValue();
        return currentYear == year && currentDayOfYear == dayOfYear;
    }

    private static final boolean formatTabName$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$formatTabName(CommonProfilerUiOptions.TabNameFormat format, String defaultName, long time, Collection existingNames2) {
        return ProfilerToolWindowManagerKt.formatTabName(format, defaultName, time, existingNames2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommonProfilerUiOptions.TabNameFormat.values().length];
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.ABSOLUTE_TIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.SHORT_TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

