/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.vfs;

import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFile;

public class MavenPropertiesVirtualFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "maven-properties";
    @NonNls
    public static final String SYSTEM_PROPERTIES_FILE = "System.properties";
    @NonNls
    public static final String ENV_PROPERTIES_FILE = "Environment.properties";
    public static final String[] PROPERTIES_FILES = new String[]{"System.properties", "Environment.properties"};
    private VirtualFile mySystemPropertiesFile;
    private VirtualFile myEnvPropertiesFile;

    public static MavenPropertiesVirtualFileSystem getInstance() {
        return (MavenPropertiesVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile getSystemPropertiesFile() {
        if (this.mySystemPropertiesFile == null) {
            Properties systemProperties = new Properties();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                Object object = entry.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                if (!(entry.getValue() instanceof String) || key.startsWith("idea.")) continue;
                systemProperties.setProperty(key, (String)entry.getValue());
            }
            this.mySystemPropertiesFile = new MavenPropertiesVirtualFile(SYSTEM_PROPERTIES_FILE, systemProperties, (VirtualFileSystem)this);
        }
        return this.mySystemPropertiesFile;
    }

    public VirtualFile getEnvPropertiesFile() {
        if (this.myEnvPropertiesFile == null) {
            Properties envProperties = new Properties();
            for (Map.Entry<String, String> each : System.getenv().entrySet()) {
                String key = each.getKey();
                if (key.startsWith("=")) continue;
                envProperties.setProperty(SystemInfo.isWindows ? StringUtil.toUpperCase((String)key) : key, each.getValue());
            }
            this.myEnvPropertiesFile = new MavenPropertiesVirtualFile(ENV_PROPERTIES_FILE, envProperties, (VirtualFileSystem)this);
        }
        return this.myEnvPropertiesFile;
    }

    public synchronized VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            MavenPropertiesVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if (path.equals(SYSTEM_PROPERTIES_FILE)) {
            return this.getSystemPropertiesFile();
        }
        if (path.equals(ENV_PROPERTIES_FILE)) {
            return this.getEnvPropertiesFile();
        }
        return null;
    }

    @Nullable
    public IProperty findSystemProperty(Project project2, @NotNull String propertyName) {
        if (propertyName == null) {
            MavenPropertiesVirtualFileSystem.$$$reportNull$$$0(1);
        }
        return MavenDomUtil.findProperty(project2, this.getSystemPropertiesFile(), propertyName);
    }

    @Nullable
    public IProperty findEnvProperty(Project project2, @NotNull String propertyName) {
        if (propertyName == null) {
            MavenPropertiesVirtualFileSystem.$$$reportNull$$$0(2);
        }
        return MavenDomUtil.findProperty(project2, this.getEnvPropertiesFile(), propertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFileSystem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findSystemProperty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnvProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

