/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import icons.ExternalSystemIcons;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.n3.nanoxml.IXMLBuilder;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenWslUtil;
import org.jetbrains.idea.maven.utils.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MavenUtil {
    private static final List<String> settingsListNamespaces = List.of("http://maven.apache.org/SETTINGS/1.0.0", "http://maven.apache.org/SETTINGS/1.1.0", "http://maven.apache.org/SETTINGS/1.2.0");
    private static final List<String> extensionListNamespaces = List.of("http://maven.apache.org/EXTENSIONS/1.0.0", "http://maven.apache.org/EXTENSIONS/1.1.0", "http://maven.apache.org/EXTENSIONS/1.2.0");
    private static final Set<Runnable> runnables = Collections.newSetFromMap(new IdentityHashMap());
    public static final String INTELLIJ_PLUGIN_ID = "org.jetbrains.idea.maven";
    @ApiStatus.Experimental
    @NlsSafe
    public static final String MAVEN_NAME = "Maven";
    @NonNls
    public static final String MAVEN_NAME_UPCASE = "Maven".toUpperCase();
    @NotNull
    public static final ProjectSystemId SYSTEM_ID = new ProjectSystemId(MAVEN_NAME_UPCASE);
    public static final String MAVEN_NOTIFICATION_GROUP = "Maven";
    public static final String SETTINGS_XML = "settings.xml";
    public static final String DOT_M2_DIR = ".m2";
    public static final String PROP_USER_HOME = "user.home";
    public static final String ENV_M2_HOME = "M2_HOME";
    public static final String M2_DIR = "m2";
    public static final String BIN_DIR = "bin";
    public static final String CONF_DIR = "conf";
    public static final String M2_CONF_FILE = "m2.conf";
    public static final String REPOSITORY_DIR = "repository";
    public static final String LIB_DIR = "lib";
    public static final String CLIENT_ARTIFACT_SUFFIX = "-client";
    public static final String CLIENT_EXPLODED_ARTIFACT_SUFFIX = "-client exploded";
    protected static final String PROP_FORCED_M2_HOME = "idea.force.m2.home";
    private static final Pair<Pattern, String>[] SUPER_POM_PATHS = new Pair[]{Pair.create((Object)Pattern.compile("maven-\\d+\\.\\d+\\.\\d+-uber\\.jar"), (Object)"org/apache/maven/project/pom-4.0.0.xml"), Pair.create((Object)Pattern.compile("maven-model-builder-\\d+\\.\\d+\\.\\d+\\.jar"), (Object)"org/apache/maven/model/pom-4.0.0.xml")};
    private static volatile Map<String, String> ourPropertiesFromMvnOpts;

    public static Map<String, String> getPropertiesFromMavenOpts() {
        Map<String, String> res = ourPropertiesFromMvnOpts;
        if (res == null) {
            ourPropertiesFromMvnOpts = res = MavenUtil.parseMavenProperties(System.getenv("MAVEN_OPTS"));
        }
        return res;
    }

    @NotNull
    public static Map<String, String> parseMavenProperties(@Nullable String mavenOpts) {
        if (mavenOpts != null) {
            ParametersList mavenOptsList = new ParametersList();
            mavenOptsList.addParametersString(mavenOpts);
            Map map = mavenOptsList.getProperties();
            if (map == null) {
                MavenUtil.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            MavenUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    public static void invokeLater(Project p, Runnable r) {
        MavenUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state2, Runnable r) {
        MavenUtil.startTestRunnable(r);
        ApplicationManager.getApplication().invokeLater(() -> MavenUtil.runAndFinishTestRunnable(r), state2, p.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTestRunnable(Runnable r) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Set<Runnable> set = runnables;
        synchronized (set) {
            runnables.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAndFinishTestRunnable(Runnable r) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            r.run();
            return;
        }
        try {
            r.run();
        }
        finally {
            Set<Runnable> set = runnables;
            synchronized (set) {
                runnables.remove(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static boolean noUncompletedRunnables() {
        Set<Runnable> set = runnables;
        synchronized (set) {
            return runnables.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanAllRunnables() {
        Set<Runnable> set = runnables;
        synchronized (set) {
            runnables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static List<Runnable> getUncompletedRunnables() {
        ArrayList<Runnable> result2;
        Set<Runnable> set = runnables;
        synchronized (set) {
            result2 = new ArrayList<Runnable>(runnables);
        }
        return result2;
    }

    public static void invokeAndWait(@NotNull Project p, @NotNull Runnable r) {
        if (p == null) {
            MavenUtil.$$$reportNull$$$0(2);
        }
        if (r == null) {
            MavenUtil.$$$reportNull$$$0(3);
        }
        MavenUtil.invokeAndWait(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeAndWait(Project p, ModalityState state2, @NotNull Runnable r) {
        if (r == null) {
            MavenUtil.$$$reportNull$$$0(4);
        }
        MavenUtil.startTestRunnable(r);
        ApplicationManager.getApplication().invokeAndWait(DisposeAwareRunnable.create(() -> MavenUtil.runAndFinishTestRunnable(r), (Project)p), state2);
    }

    public static void invokeAndWaitWriteAction(@NotNull Project p, @NotNull Runnable r) {
        if (p == null) {
            MavenUtil.$$$reportNull$$$0(5);
        }
        if (r == null) {
            MavenUtil.$$$reportNull$$$0(6);
        }
        MavenUtil.startTestRunnable(r);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            MavenUtil.runAndFinishTestRunnable(r);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().runWriteAction(r);
        } else {
            ApplicationManager.getApplication().invokeAndWait(DisposeAwareRunnable.create(() -> ApplicationManager.getApplication().runWriteAction(() -> MavenUtil.runAndFinishTestRunnable(r)), (Project)p), ModalityState.defaultModalityState());
        }
    }

    public static void runDumbAware(@NotNull Project project2, @NotNull Runnable r) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(7);
        }
        if (r == null) {
            MavenUtil.$$$reportNull$$$0(8);
        }
        MavenUtil.startTestRunnable(r);
        if (DumbService.isDumbAware((Object)r)) {
            MavenUtil.runAndFinishTestRunnable(r);
        } else {
            DumbService.getInstance((Project)project2).runWhenSmart(DisposeAwareRunnable.create(() -> MavenUtil.runAndFinishTestRunnable(r), (Project)project2));
        }
    }

    public static void runWhenInitialized(@NotNull Project project2, @NotNull Runnable runnable) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(9);
        }
        if (runnable == null) {
            MavenUtil.$$$reportNull$$$0(10);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (project2.isInitialized()) {
            MavenUtil.runDumbAware(project2, runnable);
        } else {
            MavenUtil.startTestRunnable(runnable);
            StartupManager.getInstance((Project)project2).runAfterOpened(() -> MavenUtil.runAndFinishTestRunnable(runnable));
        }
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContext();
    }

    public static void showError(Project project2, @NlsContexts.NotificationTitle String title, Throwable e) {
        MavenLog.LOG.warn(title, e);
        Notifications.Bus.notify((Notification)new Notification("Maven", title, e.getMessage(), NotificationType.ERROR), (Project)project2);
    }

    public static void showError(Project project2, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message) {
        MavenLog.LOG.warn(title);
        Notifications.Bus.notify((Notification)new Notification("Maven", title, message, NotificationType.ERROR), (Project)project2);
    }

    @NotNull
    public static java.nio.file.Path getPluginSystemDir(@NotNull String folder) {
        if (folder == null) {
            MavenUtil.$$$reportNull$$$0(11);
        }
        java.nio.file.Path path = PathManagerEx.getAppSystemDir().resolve("Maven").resolve(folder);
        if (path == null) {
            MavenUtil.$$$reportNull$$$0(12);
        }
        return path;
    }

    public static java.nio.file.Path getBaseDir(@NotNull VirtualFile file) {
        if (file == null) {
            MavenUtil.$$$reportNull$$$0(13);
        }
        VirtualFile virtualBaseDir = MavenUtil.getVFileBaseDir(file);
        return virtualBaseDir.toNioPath();
    }

    public static MultiMap<String, MavenProject> groupByBasedir(@NotNull Collection<MavenProject> projects, @NotNull MavenProjectsTree tree) {
        if (projects == null) {
            MavenUtil.$$$reportNull$$$0(14);
        }
        if (tree == null) {
            MavenUtil.$$$reportNull$$$0(15);
        }
        return ContainerUtil.groupBy(projects, p -> MavenUtil.getBaseDir(tree.findRootProject((MavenProject)p).getDirectoryFile()).toString());
    }

    public static VirtualFile getVFileBaseDir(@NotNull VirtualFile file) {
        VirtualFile baseDir;
        if (file == null) {
            MavenUtil.$$$reportNull$$$0(16);
        }
        VirtualFile dir2 = baseDir = file.isDirectory() || file.getParent() == null ? file : file.getParent();
        do {
            VirtualFile child;
            if ((child = dir2.findChild(".mvn")) == null || !child.isDirectory()) continue;
            if (MavenLog.LOG.isDebugEnabled()) {
                MavenLog.LOG.debug("found .mvn in " + child);
            }
            baseDir = dir2;
            break;
        } while ((dir2 = dir2.getParent()) != null);
        if (MavenLog.LOG.isDebugEnabled()) {
            MavenLog.LOG.debug("return " + baseDir + " as baseDir");
        }
        return baseDir;
    }

    @Nullable
    public static VirtualFile findProfilesXmlFile(VirtualFile pomFile) {
        if (pomFile == null) {
            return null;
        }
        VirtualFile parent = pomFile.getParent();
        if (parent == null || !parent.isValid()) {
            return null;
        }
        return parent.findChild("profiles.xml");
    }

    @Nullable
    public static File getProfilesXmlIoFile(VirtualFile pomFile) {
        if (pomFile == null) {
            return null;
        }
        VirtualFile parent = pomFile.getParent();
        if (parent == null) {
            return null;
        }
        return new File(parent.getPath(), "profiles.xml");
    }

    public static <T, U> List<T> collectFirsts(List<? extends Pair<T, U>> pairs) {
        ArrayList<Object> result2 = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result2.add(each.first);
        }
        return result2;
    }

    public static <T, U> List<U> collectSeconds(List<? extends Pair<T, U>> pairs) {
        ArrayList<Object> result2 = new ArrayList<Object>(pairs.size());
        for (Pair<T, U> each : pairs) {
            result2.add(each.second);
        }
        return result2;
    }

    public static List<String> collectPaths(List<? extends VirtualFile> files2) {
        return ContainerUtil.map(files2, file -> file.getPath());
    }

    public static List<VirtualFile> collectFiles(Collection<? extends MavenProject> projects) {
        return ContainerUtil.map(projects, project2 -> project2.getFile());
    }

    public static <T> boolean equalAsSets(Collection<T> collection1, Collection<T> collection2) {
        return MavenUtil.toSet(collection1).equals(MavenUtil.toSet(collection2));
    }

    private static <T> Collection<T> toSet(Collection<T> collection) {
        return collection instanceof Set ? collection : new HashSet(collection);
    }

    @NotNull
    public static <T, U> List<Pair<T, U>> mapToList(Map<T, U> map) {
        List list = ContainerUtil.map(map.entrySet(), tuEntry -> Pair.create(tuEntry.getKey(), tuEntry.getValue()));
        if (list == null) {
            MavenUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static String formatHtmlImage(URL url) {
        return "<img src=\"" + url + "\"> ";
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project2, VirtualFile file, @NotNull MavenId projectId, boolean interactive) throws IOException {
        if (projectId == null) {
            MavenUtil.$$$reportNull$$$0(18);
        }
        MavenUtil.runOrApplyMavenProjectFileTemplate(project2, file, projectId, null, null, interactive);
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project2, VirtualFile file, @NotNull MavenId projectId, MavenId parentId, @Nullable VirtualFile parentFile, boolean interactive) throws IOException {
        if (projectId == null) {
            MavenUtil.$$$reportNull$$$0(19);
        }
        MavenUtil.runOrApplyMavenProjectFileTemplate(project2, file, projectId, parentId, parentFile, new Properties(), new Properties(), "Maven Project.xml", interactive);
    }

    public static void runOrApplyMavenProjectFileTemplate(Project project2, VirtualFile file, @NotNull MavenId projectId, MavenId parentId, @Nullable VirtualFile parentFile, @NotNull Properties properties, @NotNull Properties conditions, @NonNls @NotNull String template, boolean interactive) throws IOException {
        if (projectId == null) {
            MavenUtil.$$$reportNull$$$0(20);
        }
        if (properties == null) {
            MavenUtil.$$$reportNull$$$0(21);
        }
        if (conditions == null) {
            MavenUtil.$$$reportNull$$$0(22);
        }
        if (template == null) {
            MavenUtil.$$$reportNull$$$0(23);
        }
        properties.setProperty("GROUP_ID", projectId.getGroupId());
        properties.setProperty("ARTIFACT_ID", projectId.getArtifactId());
        properties.setProperty("VERSION", projectId.getVersion());
        if (parentId != null) {
            conditions.setProperty("HAS_PARENT", "true");
            properties.setProperty("PARENT_GROUP_ID", parentId.getGroupId());
            properties.setProperty("PARENT_ARTIFACT_ID", parentId.getArtifactId());
            properties.setProperty("PARENT_VERSION", parentId.getVersion());
            if (parentFile != null) {
                String relativePath;
                VirtualFile modulePath = file.getParent();
                VirtualFile parentModulePath = parentFile.getParent();
                if (!(Comparing.equal((Object)modulePath.getParent(), (Object)parentModulePath) && FileUtil.namesEqual((String)"pom.xml", (String)parentFile.getName()) || (relativePath = VfsUtilCore.findRelativePath((VirtualFile)file, (VirtualFile)parentModulePath, (char)'/')) == null)) {
                    conditions.setProperty("HAS_RELATIVE_PATH", "true");
                    properties.setProperty("PARENT_RELATIVE_PATH", relativePath);
                }
            }
        } else {
            SdkTypeId relativePath;
            Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
            if (sdk != null && (relativePath = sdk.getSdkType()) instanceof JavaSdk) {
                JavaSdk javaSdk = (JavaSdk)relativePath;
                JavaSdkVersion version2 = javaSdk.getVersion(sdk);
                String description = version2 == null ? null : version2.getDescription();
                boolean shouldSetLangLevel = version2 != null && version2.isAtLeast(JavaSdkVersion.JDK_1_6);
                conditions.setProperty("SHOULD_SET_LANG_LEVEL", String.valueOf(shouldSetLangLevel));
                properties.setProperty("COMPILER_LEVEL_SOURCE", description);
                properties.setProperty("COMPILER_LEVEL_TARGET", description);
            }
        }
        MavenUtil.runOrApplyFileTemplate(project2, file, template, properties, conditions, interactive);
    }

    public static void runFileTemplate(Project project2, VirtualFile file, String templateName) throws IOException {
        MavenUtil.runOrApplyFileTemplate(project2, file, templateName, new Properties(), new Properties(), true);
    }

    public static void runOrApplyFileTemplate(Project project2, VirtualFile file, String templateName, Properties properties, Properties conditions, boolean interactive) throws IOException {
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)project2);
        FileTemplate fileTemplate = manager.getJ2eeTemplate(templateName);
        Properties allProperties = manager.getDefaultProperties();
        if (!interactive) {
            allProperties.putAll((Map<?, ?>)properties);
        }
        allProperties.putAll((Map<?, ?>)conditions);
        String text = fileTemplate.getText(allProperties);
        Pattern pattern = Pattern.compile("\\$\\{(.*)}");
        Matcher matcher = pattern.matcher(text);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(builder, "\\$" + StringUtil.toUpperCase((String)matcher.group(1)) + "\\$");
        }
        matcher.appendTail(builder);
        text = builder.toString();
        TemplateImpl template = (TemplateImpl)TemplateManager.getInstance((Project)project2).createTemplate("", "", text);
        for (int i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            if (i2 == template.getEndSegmentNumber()) continue;
            String name = template.getSegmentName(i2);
            String value = "\"" + properties.getProperty(name, "") + "\"";
            template.addVariable(name, value, value, true);
        }
        if (interactive) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, file);
            Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
            editor.getDocument().setText((CharSequence)"");
            TemplateManager.getInstance((Project)project2).startTemplate(editor, (Template)template);
        } else {
            VfsUtil.saveText((VirtualFile)file, (String)template.getTemplateText());
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
            if (psiFile != null && project2.isInitialized()) {
                new ReformatCodeProcessor(project2, psiFile, null, false).run();
            }
        }
    }

    public static <T extends Collection<Pattern>> T collectPattern(String text, T result2) {
        String antPattern = FileUtil.convertAntToRegexp((String)text.trim());
        try {
            result2.add((Pattern)Pattern.compile(antPattern));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return result2;
    }

    public static boolean isIncluded(String relativeName, List<Pattern> includes, List<Pattern> excludes) {
        boolean result2 = false;
        for (Pattern each : includes) {
            if (!each.matcher(relativeName).matches()) continue;
            result2 = true;
            break;
        }
        if (!result2) {
            return false;
        }
        for (Pattern each : excludes) {
            if (!each.matcher(relativeName).matches()) continue;
            return false;
        }
        return true;
    }

    public static void run(@NlsContexts.DialogTitle String title, final MavenTask task) throws MavenProcessCanceledException {
        final Exception[] canceledEx = new Exception[1];
        final RuntimeException[] runtimeEx = new RuntimeException[1];
        final Error[] errorEx = new Error[1];
        ProgressManager.getInstance().run((Task)new Task.Modal(null, title, true){

            public void run(@NotNull ProgressIndicator i2) {
                if (i2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    task.run(new MavenProgressIndicator(null, i2, null));
                }
                catch (ProcessCanceledException | MavenProcessCanceledException e) {
                    canceledEx[0] = e;
                }
                catch (RuntimeException e) {
                    runtimeEx[0] = e;
                }
                catch (Error e) {
                    errorEx[0] = e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "org/jetbrains/idea/maven/utils/MavenUtil$1", "run"));
            }
        });
        if (canceledEx[0] instanceof MavenProcessCanceledException) {
            throw (MavenProcessCanceledException)canceledEx[0];
        }
        if (canceledEx[0] instanceof ProcessCanceledException) {
            throw new MavenProcessCanceledException();
        }
        if (runtimeEx[0] != null) {
            throw runtimeEx[0];
        }
        if (errorEx[0] != null) {
            throw errorEx[0];
        }
    }

    @NotNull
    public static MavenTaskHandler runInBackground(@NotNull Project project2, @NotNull @NlsContexts.Command String title, boolean cancellable, @NotNull MavenTask task) {
        MavenProjectsManager manager;
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(24);
        }
        if (title == null) {
            MavenUtil.$$$reportNull$$$0(25);
        }
        if (task == null) {
            MavenUtil.$$$reportNull$$$0(26);
        }
        Supplier<MavenSyncConsole> syncConsoleSupplier = (manager = MavenProjectsManager.getInstanceIfCreated(project2)) == null ? null : () -> manager.getSyncConsole();
        final MavenProgressIndicator indicator = new MavenProgressIndicator(project2, syncConsoleSupplier);
        Runnable runnable = () -> {
            if (project2.isDisposed()) {
                return;
            }
            try {
                task.run(indicator);
            }
            catch (ProcessCanceledException | MavenProcessCanceledException e) {
                indicator.cancel();
            }
        };
        final Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
        final MavenTaskHandler handler = new MavenTaskHandler(){

            @Override
            public void waitFor() {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    MavenLog.LOG.error((Throwable)e);
                }
            }
        };
        MavenUtil.invokeLater(project2, () -> {
            if (future.isDone()) {
                return;
            }
            new Task.Backgroundable(project2, title, cancellable){

                public void run(@NotNull ProgressIndicator i2) {
                    if (i2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    indicator.setIndicator(i2);
                    handler.waitFor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "org/jetbrains/idea/maven/utils/MavenUtil$3", "run"));
                }
            }.queue();
        });
        MavenTaskHandler mavenTaskHandler = handler;
        if (mavenTaskHandler == null) {
            MavenUtil.$$$reportNull$$$0(27);
        }
        return mavenTaskHandler;
    }

    @Nullable
    public static File resolveMavenHomeDirectory(@Nullable String overrideMavenHome) {
        File underUserHome;
        File mavenHomeFile;
        File homeFromEnv;
        if (!MavenUtil.isEmptyOrSpaces(overrideMavenHome)) {
            return MavenUtil.getMavenHomeFile(overrideMavenHome);
        }
        String m2home = System.getenv(ENV_M2_HOME);
        if (!MavenUtil.isEmptyOrSpaces(m2home) && MavenUtil.isValidMavenHome(homeFromEnv = new File(m2home))) {
            return homeFromEnv;
        }
        String mavenHome = System.getenv("MAVEN_HOME");
        if (!MavenUtil.isEmptyOrSpaces(mavenHome) && MavenUtil.isValidMavenHome(mavenHomeFile = new File(mavenHome))) {
            return mavenHomeFile;
        }
        String userHome = SystemProperties.getUserHome();
        if (!MavenUtil.isEmptyOrSpaces(userHome) && MavenUtil.isValidMavenHome(underUserHome = new File(userHome, M2_DIR))) {
            return underUserHome;
        }
        if (SystemInfo.isMac) {
            home = MavenUtil.fromBrew();
            if (home != null) {
                return home;
            }
            home = MavenUtil.fromMacSystemJavaTools();
            if (home != null) {
                return home;
            }
        } else if (SystemInfo.isLinux) {
            home = new File("/usr/share/maven");
            if (MavenUtil.isValidMavenHome(home)) {
                return home;
            }
            home = new File("/usr/share/maven2");
            if (MavenUtil.isValidMavenHome(home)) {
                return home;
            }
        }
        return MavenUtil.getMavenHomeFile("Bundled (Maven 3)");
    }

    public static void addEventListener(@NotNull String mavenVersion, @NotNull SimpleJavaParameters params) {
        if (mavenVersion == null) {
            MavenUtil.$$$reportNull$$$0(28);
        }
        if (params == null) {
            MavenUtil.$$$reportNull$$$0(29);
        }
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.0.2") < 0) {
            MavenLog.LOG.warn("Maven version less than 3.0.2 are not correctly displayed in Build Window");
            return;
        }
        String listenerPath = MavenServerManager.getInstance().getMavenEventListener().getAbsolutePath();
        String userExtClassPath = StringUtils.stripToEmpty((String)params.getVMParametersList().getPropertyValue("maven.ext.class.path"));
        String vmParameter = "-Dmaven.ext.class.path=";
        String[] userListeners = userExtClassPath.split(File.pathSeparator);
        CompositeParameterTargetedValue targetedValue = new CompositeParameterTargetedValue(vmParameter).addPathPart(listenerPath);
        for (String path : userListeners) {
            if (StringUtil.isEmptyOrSpaces((String)path)) continue;
            targetedValue = targetedValue.addPathSeparator().addPathPart(path);
        }
        params.getVMParametersList().add(targetedValue);
    }

    @Nullable
    private static File fromMacSystemJavaTools() {
        File file;
        File symlinkDir = new File("/usr/share/maven");
        if (MavenUtil.isValidMavenHome(symlinkDir)) {
            return symlinkDir;
        }
        File dir2 = new File("/usr/share/java");
        String[] list = dir2.list();
        if (list == null || list.length == 0) {
            return null;
        }
        String home = null;
        String prefix = "maven-";
        int versionIndex = "maven-".length();
        for (String path : list) {
            if (!path.startsWith("maven-") || home != null && StringUtil.compareVersionNumbers((String)path.substring(versionIndex), (String)home.substring(versionIndex)) <= 0) continue;
            home = path;
        }
        if (home != null && MavenUtil.isValidMavenHome(file = new File(dir2, home))) {
            return file;
        }
        return null;
    }

    @Nullable
    private static File fromBrew() {
        File file;
        File brewDir = new File("/usr/local/Cellar/maven");
        String[] list = brewDir.list();
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Arrays.sort(list, (o1, o2) -> StringUtil.compareVersionNumbers((String)o2, (String)o1));
        }
        return MavenUtil.isValidMavenHome(file = new File(brewDir, list[0] + "/libexec")) ? file : null;
    }

    public static boolean isEmptyOrSpaces(@Nullable String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static boolean isValidMavenHome(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return false;
        }
        if (mavenHome.equals("Bundled (Maven 2)")) {
            return true;
        }
        if (mavenHome.equals("Bundled (Maven 3)")) {
            return true;
        }
        if (mavenHome.equals("Use Maven wrapper")) {
            return true;
        }
        return MavenUtil.isValidMavenHome(new File(mavenHome));
    }

    public static boolean isValidMavenHome(@Nullable File home) {
        if (home == null) {
            return false;
        }
        return MavenUtil.getMavenConfFile(home).exists();
    }

    public static File getMavenConfFile(File mavenHome) {
        return new File(new File(mavenHome, BIN_DIR), M2_CONF_FILE);
    }

    @Nullable
    @ApiStatus.Internal
    public static File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        for (MavenVersionAwareSupportExtension e : MavenVersionAwareSupportExtension.MAVEN_VERSION_SUPPORT.getExtensionList()) {
            File file = e.getMavenHomeFile(mavenHome);
            if (file == null) continue;
            return file;
        }
        File home = new File(mavenHome);
        return MavenUtil.isValidMavenHome(home) ? home : null;
    }

    @Nullable
    public static String getMavenVersionByMavenHome(@Nullable String mavenHome) {
        return MavenUtil.getMavenVersion(MavenUtil.getMavenHomeFile(mavenHome));
    }

    @Nullable
    public static String getMavenVersion(@Nullable File mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        File[] libs = new File(mavenHome, LIB_DIR).listFiles();
        if (libs != null) {
            for (File mavenLibFile : libs) {
                String lib = mavenLibFile.getName();
                if (lib.equals("maven-core.jar")) {
                    MavenLog.LOG.debug("Choosing version by maven-core.jar");
                    return MavenUtil.getMavenLibVersion(mavenLibFile);
                }
                if (lib.startsWith("maven-core-") && lib.endsWith(".jar")) {
                    MavenLog.LOG.debug("Choosing version by maven-core.xxx.jar");
                    String version2 = lib.substring("maven-core-".length(), lib.length() - ".jar".length());
                    return StringUtil.contains((CharSequence)version2, (CharSequence)".x") ? MavenUtil.getMavenLibVersion(mavenLibFile) : version2;
                }
                if (!lib.startsWith("maven-") || !lib.endsWith("-uber.jar")) continue;
                MavenLog.LOG.debug("Choosing version by maven-xxx-uber.jar");
                return lib.substring("maven-".length(), lib.length() - "-uber.jar".length());
            }
        }
        MavenLog.LOG.warn("Cannot resolve maven version for " + mavenHome);
        return null;
    }

    private static String getMavenLibVersion(File file) {
        WSLDistribution distribution = WslPath.getDistributionByWindowsUncPath((String)file.getPath());
        File fileToRead = Optional.ofNullable(distribution).map(it -> distribution.getWslPath(file.getPath())).map(it -> distribution.resolveSymlink(it)).map(it -> distribution.getWindowsPath(it)).map(it -> new File((String)it)).orElse(file);
        Properties props = JarUtil.loadProperties((File)fileToRead, (String)"META-INF/maven/org.apache.maven/maven-core/pom.properties");
        return props != null ? StringUtil.nullize((String)props.getProperty("version")) : StringUtil.nullize((String)JarUtil.getJarAttribute((File)file, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION));
    }

    @Nullable
    public static String getMavenVersion(String mavenHome) {
        return MavenUtil.getMavenVersion(new File(mavenHome));
    }

    public static boolean isMaven3(String mavenHome) {
        String version2 = MavenUtil.getMavenVersion(mavenHome);
        return version2 != null && version2.compareTo("3.0.0") >= 0;
    }

    @Nullable
    public static File resolveGlobalSettingsFile(@Nullable String overriddenMavenHome) {
        if (overriddenMavenHome == null) {
            return null;
        }
        File directory = MavenUtil.resolveMavenHomeDirectory(overriddenMavenHome);
        if (directory == null) {
            return null;
        }
        return new File(new File(directory, CONF_DIR), SETTINGS_XML);
    }

    @NotNull
    public static File resolveUserSettingsFile(@Nullable String overriddenUserSettingsFile) {
        if (!MavenUtil.isEmptyOrSpaces(overriddenUserSettingsFile)) {
            return new File(overriddenUserSettingsFile);
        }
        return new File(MavenUtil.resolveM2Dir(), SETTINGS_XML);
    }

    @NotNull
    public static File resolveM2Dir() {
        return new File(SystemProperties.getUserHome(), DOT_M2_DIR);
    }

    @NotNull
    public static File resolveLocalRepository(@Nullable String overriddenLocalRepository, @Nullable String overriddenMavenHome, @Nullable String overriddenUserSettingsFile) {
        File file;
        String forcedM2Home = System.getProperty(PROP_FORCED_M2_HOME);
        if (forcedM2Home != null) {
            return new File(forcedM2Home);
        }
        File result2 = null;
        if (!MavenUtil.isEmptyOrSpaces(overriddenLocalRepository)) {
            result2 = new File(overriddenLocalRepository);
        }
        if (result2 == null && (result2 = MavenUtil.doResolveLocalRepository(MavenUtil.resolveUserSettingsFile(overriddenUserSettingsFile), MavenUtil.resolveGlobalSettingsFile(overriddenMavenHome))) == null) {
            result2 = new File(MavenUtil.resolveM2Dir(), REPOSITORY_DIR);
        }
        try {
            file = result2.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = result2;
            if (file2 == null) {
                MavenUtil.$$$reportNull$$$0(31);
            }
            return file2;
        }
        if (file == null) {
            MavenUtil.$$$reportNull$$$0(30);
        }
        return file;
    }

    @Nullable
    public static File getRepositoryFile(@NotNull Project project2, @NotNull MavenId id, @NotNull String extension, @Nullable String classifier) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(32);
        }
        if (id == null) {
            MavenUtil.$$$reportNull$$$0(33);
        }
        if (extension == null) {
            MavenUtil.$$$reportNull$$$0(34);
        }
        if (id.getGroupId() == null || id.getArtifactId() == null || id.getVersion() == null) {
            return null;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        return MavenUtil.makeLocalRepositoryFile(id, projectsManager.getLocalRepository(), extension, classifier);
    }

    @NotNull
    public static File makeLocalRepositoryFile(MavenId id, File localRepository, @NotNull String extension, @Nullable String classifier) {
        if (extension == null) {
            MavenUtil.$$$reportNull$$$0(35);
        }
        Object relPath = id.getGroupId().replace(".", "/");
        relPath = (String)relPath + "/" + id.getArtifactId();
        relPath = (String)relPath + "/" + id.getVersion();
        relPath = (String)relPath + "/" + id.getArtifactId() + "-" + id.getVersion();
        relPath = classifier == null ? (String)relPath + "." + extension : (String)relPath + "-" + classifier + "." + extension;
        return new File(localRepository, (String)relPath);
    }

    @Nullable
    public static java.nio.file.Path getArtifactPath(@NotNull java.nio.file.Path localRepository, @NotNull MavenId id, @NotNull String extension, @Nullable String classifier) {
        if (localRepository == null) {
            MavenUtil.$$$reportNull$$$0(36);
        }
        if (id == null) {
            MavenUtil.$$$reportNull$$$0(37);
        }
        if (extension == null) {
            MavenUtil.$$$reportNull$$$0(38);
        }
        if (id.getGroupId() == null || id.getArtifactId() == null || id.getVersion() == null) {
            return null;
        }
        String[] artifactPath = id.getGroupId().split("\\.");
        try {
            for (String path : artifactPath) {
                localRepository = localRepository.resolve(path);
            }
            return localRepository.resolve(id.getArtifactId()).resolve(id.getVersion()).resolve(id.getArtifactId() + "-" + id.getVersion() + (classifier == null ? "." + extension : "-" + classifier + "." + extension));
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Nullable
    public static java.nio.file.Path getRepositoryParentFile(@NotNull Project project2, @NotNull MavenId id) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(39);
        }
        if (id == null) {
            MavenUtil.$$$reportNull$$$0(40);
        }
        if (id.getGroupId() == null || id.getArtifactId() == null || id.getVersion() == null) {
            return null;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        return MavenUtil.getParentFile(id, projectsManager.getLocalRepository());
    }

    private static java.nio.file.Path getParentFile(@NotNull MavenId id, File localRepository) {
        if (id == null) {
            MavenUtil.$$$reportNull$$$0(41);
        }
        assert (id.getGroupId() != null);
        String[] pathParts = id.getGroupId().split("\\.");
        java.nio.file.Path path = Paths.get(localRepository.getAbsolutePath(), pathParts);
        path = Paths.get(path.toString(), id.getArtifactId(), id.getVersion());
        return path;
    }

    @Nullable
    protected static File doResolveLocalRepository(@Nullable File userSettingsFile, @Nullable File globalSettingsFile) {
        String fromGlobalSettings;
        String fromUserSettings;
        if (userSettingsFile != null && !StringUtil.isEmpty((String)(fromUserSettings = MavenUtil.getRepositoryFromSettings(userSettingsFile)))) {
            return new File(fromUserSettings);
        }
        if (globalSettingsFile != null && !StringUtil.isEmpty((String)(fromGlobalSettings = MavenUtil.getRepositoryFromSettings(globalSettingsFile)))) {
            return new File(fromGlobalSettings);
        }
        return null;
    }

    @Nullable
    public static String getRepositoryFromSettings(File file) {
        try {
            Element repository = MavenUtil.getRepositoryElement(file);
            if (repository == null) {
                return null;
            }
            String text = repository.getText();
            if (MavenUtil.isEmptyOrSpaces(text)) {
                return null;
            }
            return MavenUtil.expandProperties(text.trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMirroredUrl(File settingsFile2, String url, String id) {
        try {
            Element mirrorParent = MavenUtil.getElementWithRegardToNamespace(MavenUtil.getDomRootElement(settingsFile2), "mirrors", settingsListNamespaces);
            if (mirrorParent == null) {
                return url;
            }
            List<Element> mirrors = MavenUtil.getElementsWithRegardToNamespace(mirrorParent, "mirror", settingsListNamespaces);
            for (Element el : mirrors) {
                Element mirrorOfElement = MavenUtil.getElementWithRegardToNamespace(el, "mirrorOf", settingsListNamespaces);
                Element mirrorUrlElement = MavenUtil.getElementWithRegardToNamespace(el, "url", settingsListNamespaces);
                if (mirrorOfElement == null || mirrorUrlElement == null) continue;
                String mirrorOf = mirrorOfElement.getTextTrim();
                String mirrorUrl = mirrorUrlElement.getTextTrim();
                if (StringUtil.isEmptyOrSpaces((String)mirrorOf) || StringUtil.isEmptyOrSpaces((String)mirrorUrl) || !MavenUtil.isMirrorApplicable(mirrorOf, url, id)) continue;
                return mirrorUrl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private static boolean isMirrorApplicable(String mirrorOf, String url, String id) {
        HashSet patterns = new HashSet(StringUtil.split((String)mirrorOf, (String)","));
        if (patterns.contains("!" + id)) {
            return false;
        }
        if (patterns.contains("*")) {
            return true;
        }
        if (patterns.contains(id)) {
            return true;
        }
        if (patterns.contains("external:*")) {
            try {
                URI uri = URI.create(url);
                if ("file".equals(uri.getScheme())) {
                    return false;
                }
                if ("localhost".equals(uri.getHost())) {
                    return false;
                }
                return !"127.0.0.1".equals(uri.getHost());
            }
            catch (IllegalArgumentException e) {
                MavenLog.LOG.warn("cannot parse uri " + url, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Nullable
    private static Element getRepositoryElement(File file) throws JDOMException, IOException {
        return MavenUtil.getElementWithRegardToNamespace(MavenUtil.getDomRootElement(file), "localRepository", settingsListNamespaces);
    }

    private static Element getDomRootElement(File file) throws IOException, JDOMException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        return JDOMUtil.load((Reader)reader);
    }

    @Nullable
    private static Element getElementWithRegardToNamespace(@NotNull Element parent, String childName, List<String> namespaces) {
        Element element;
        if (parent == null) {
            MavenUtil.$$$reportNull$$$0(42);
        }
        if ((element = parent.getChild(childName)) != null) {
            return element;
        }
        for (String namespace : namespaces) {
            element = parent.getChild(childName, Namespace.getNamespace((String)namespace));
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private static List<Element> getElementsWithRegardToNamespace(@NotNull Element parent, String childrenName, List<String> namespaces) {
        List elements;
        if (parent == null) {
            MavenUtil.$$$reportNull$$$0(43);
        }
        if (!(elements = parent.getChildren(childrenName)).isEmpty()) {
            return elements;
        }
        for (String namespace : namespaces) {
            elements = parent.getChildren(childrenName, Namespace.getNamespace((String)namespace));
            if (elements.isEmpty()) continue;
            return elements;
        }
        return Collections.emptyList();
    }

    public static String expandProperties(String text, Properties props) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return text;
        }
        for (Map.Entry<Object, Object> each : props.entrySet()) {
            Object val = each.getValue();
            text = text.replace("${" + each.getKey() + "}", val instanceof CharSequence ? (CharSequence)val : val.toString());
        }
        return text;
    }

    public static String expandProperties(String text) {
        return MavenUtil.expandProperties(text, MavenServerUtil.collectSystemProperties());
    }

    @Nullable
    public static VirtualFile resolveSuperPomFile(@Nullable File mavenHome) {
        VirtualFile result2 = null;
        if (mavenHome != null) {
            result2 = MavenUtil.doResolveSuperPomFile(new File(mavenHome, LIB_DIR));
        }
        return result2 == null ? MavenUtil.doResolveSuperPomFile(new File(MavenUtil.getMavenHomeFile("Bundled (Maven 3)"), LIB_DIR)) : result2;
    }

    @Nullable
    public static VirtualFile doResolveSuperPomFile(@NotNull File mavenHome) {
        File[] files2;
        if (mavenHome == null) {
            MavenUtil.$$$reportNull$$$0(44);
        }
        if ((files2 = mavenHome.listFiles()) == null) {
            return null;
        }
        for (File library : files2) {
            for (Pair<Pattern, String> path : SUPER_POM_PATHS) {
                VirtualFile pomFile;
                VirtualFile root;
                VirtualFile libraryVirtualFile;
                if (!((Pattern)path.first).matcher(library.getName()).matches() || (libraryVirtualFile = LocalFileSystem.getInstance().findFileByNioFile(library.toPath())) == null || (root = JarFileSystem.getInstance().getJarRootForLocalFile(libraryVirtualFile)) == null || (pomFile = root.findFileByRelativePath((String)path.second)) == null) continue;
                return pomFile;
            }
        }
        return null;
    }

    public static List<LookupElement> getPhaseVariants(MavenProjectsManager manager) {
        HashSet<String> goals2 = new HashSet<String>(MavenConstants.PHASES);
        for (MavenProject mavenProject2 : manager.getProjects()) {
            for (MavenPlugin plugin : mavenProject2.getPlugins()) {
                MavenPluginInfo pluginInfo = MavenArtifactUtil.readPluginInfo(manager.getLocalRepository(), plugin.getMavenId());
                if (pluginInfo == null) continue;
                for (MavenPluginInfo.Mojo mojo2 : pluginInfo.getMojos()) {
                    goals2.add(mojo2.getDisplayName());
                }
            }
        }
        ArrayList<LookupElement> res = new ArrayList<LookupElement>(goals2.size());
        for (String goal : goals2) {
            res.add((LookupElement)LookupElementBuilder.create((String)goal).withIcon(ExternalSystemIcons.Task));
        }
        return res;
    }

    public static boolean isProjectTrustedEnoughToImport(Project project2) {
        return ExternalSystemUtil.confirmLoadingUntrustedProject((Project)project2, (ProjectSystemId)SYSTEM_ID);
    }

    public static void restartMavenConnectors(@NotNull Project project2, boolean wait, Predicate<MavenServerConnector> condition) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(45);
        }
        MavenServerManager.getInstance().restartMavenConnectors(project2, wait, condition);
    }

    public static void restartMavenConnectors(@NotNull Project project2, boolean wait) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(46);
        }
        MavenUtil.restartMavenConnectors(project2, wait, c -> Boolean.TRUE);
    }

    public static boolean verifyMavenSdkRequirements(@NotNull Sdk jdk2, String mavenVersion) {
        JavaSdkVersion version2;
        if (jdk2 == null) {
            MavenUtil.$$$reportNull$$$0(47);
        }
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3.1") < 0) {
            return true;
        }
        SdkTypeId sdkType = jdk2.getSdkType();
        return sdkType instanceof JavaSdk && ((version2 = ((JavaSdk)sdkType).getVersion(jdk2)) == null || version2.isAtLeast(JavaSdkVersion.JDK_1_7));
    }

    public static int crcWithoutSpaces(@NotNull InputStream in) throws IOException {
        if (in == null) {
            MavenUtil.$$$reportNull$$$0(48);
        }
        try {
            final CRC32 crc = new CRC32();
            SAXParser parser = SAXParserFactory.newDefaultInstance().newSAXParser();
            parser.getXMLReader().setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            parser.parse(in, new DefaultHandler(){
                boolean textContentOccur = false;
                int spacesCrc;

                private void putString(@Nullable String string) {
                    if (string == null) {
                        return;
                    }
                    int end = string.length();
                    for (int i2 = 0; i2 < end; ++i2) {
                        crc.update(string.charAt(i2));
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    this.textContentOccur = false;
                    crc.update(1);
                    this.putString(qName);
                    for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                        this.putString(attributes.getQName(i2));
                        this.putString(attributes.getValue(i2));
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    this.textContentOccur = false;
                    crc.update(2);
                    this.putString(qName);
                }

                private void processTextOrSpaces(char[] ch, int start, int length) {
                    int end = start + length;
                    for (int i2 = start; i2 < end; ++i2) {
                        char a = ch[i2];
                        if (Character.isWhitespace(a)) {
                            if (!this.textContentOccur) continue;
                            this.spacesCrc = this.spacesCrc * 31 + a;
                            continue;
                        }
                        if (this.textContentOccur && this.spacesCrc != 0) {
                            crc.update(this.spacesCrc);
                            crc.update(this.spacesCrc >> 8);
                        }
                        crc.update(a);
                        this.textContentOccur = true;
                        this.spacesCrc = 0;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.processTextOrSpaces(ch, start, length);
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) {
                    this.processTextOrSpaces(ch, start, length);
                }

                @Override
                public void processingInstruction(String target, String data2) {
                    this.putString(target);
                    this.putString(data2);
                }

                @Override
                public void skippedEntity(String name) {
                    this.putString(name);
                }

                @Override
                public void error(SAXParseException e) {
                    crc.update(100);
                }
            });
            return (int)crc.getValue();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            return -1;
        }
    }

    public static String getSdkPath(@Nullable Sdk sdk) {
        VirtualFile jreDir;
        if (sdk == null) {
            return null;
        }
        VirtualFile homeDirectory = sdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        if (!"jre".equals(homeDirectory.getName()) && (jreDir = homeDirectory.findChild("jre")) != null) {
            homeDirectory = jreDir;
        }
        return homeDirectory.getPath();
    }

    @Nullable
    public static String getModuleJreHome(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject2) {
        if (mavenProjectsManager == null) {
            MavenUtil.$$$reportNull$$$0(49);
        }
        if (mavenProject2 == null) {
            MavenUtil.$$$reportNull$$$0(50);
        }
        return MavenUtil.getSdkPath(MavenUtil.getModuleJdk(mavenProjectsManager, mavenProject2));
    }

    @Nullable
    public static String getModuleJavaVersion(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject2) {
        Sdk sdk;
        if (mavenProjectsManager == null) {
            MavenUtil.$$$reportNull$$$0(51);
        }
        if (mavenProject2 == null) {
            MavenUtil.$$$reportNull$$$0(52);
        }
        if ((sdk = MavenUtil.getModuleJdk(mavenProjectsManager, mavenProject2)) == null) {
            return null;
        }
        return sdk.getVersionString();
    }

    @Nullable
    public static Sdk getModuleJdk(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject2) {
        Module module2;
        if (mavenProjectsManager == null) {
            MavenUtil.$$$reportNull$$$0(53);
        }
        if (mavenProject2 == null) {
            MavenUtil.$$$reportNull$$$0(54);
        }
        if ((module2 = mavenProjectsManager.findModule(mavenProject2)) == null) {
            return null;
        }
        return ModuleRootManager.getInstance((Module)module2).getSdk();
    }

    @NotNull
    public static <K, V extends Map<?, ?>> V getOrCreate(Map<K, V> map, K key) {
        HashMap res = (HashMap)map.get(key);
        if (res == null) {
            res = new HashMap();
            map.put(key, res);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            MavenUtil.$$$reportNull$$$0(55);
        }
        return (V)hashMap;
    }

    public static boolean isMavenModule(@Nullable Module module2) {
        return module2 != null && MavenProjectsManager.getInstance(module2.getProject()).isMavenizedModule(module2);
    }

    public static String getArtifactName(String packaging, Module module2, boolean exploded) {
        return MavenUtil.getArtifactName(packaging, module2.getName(), exploded);
    }

    public static String getArtifactName(String packaging, String moduleName, boolean exploded) {
        return moduleName + ":" + packaging + (exploded ? " exploded" : "");
    }

    public static String getEjbClientArtifactName(Module module2, boolean exploded) {
        return MavenUtil.getEjbClientArtifactName(module2.getName(), exploded);
    }

    public static String getEjbClientArtifactName(String moduleName, boolean exploded) {
        return moduleName + ":ejb" + (exploded ? CLIENT_EXPLODED_ARTIFACT_SUFFIX : CLIENT_ARTIFACT_SUFFIX);
    }

    public static String getIdeaVersionToPassToMavenProcess() {
        return ApplicationInfoImpl.getShadowInstance().getMajorVersion() + "." + ApplicationInfoImpl.getShadowInstance().getMinorVersion();
    }

    public static boolean isPomFileName(String fileName) {
        return fileName.equals("pom.xml") || fileName.endsWith(".pom") || fileName.startsWith("pom.") || fileName.equals("pom-4.0.0.xml");
    }

    public static boolean isPotentialPomFile(String nameOrPath) {
        return ArrayUtil.contains((String)FileUtilRt.getExtension((String)nameOrPath), (String[])MavenConstants.POM_EXTENSIONS);
    }

    public static boolean isPomFile(@Nullable VirtualFile file) {
        return MavenUtil.isPomFile(null, file);
    }

    public static boolean isPomFile(@Nullable Project project2, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        String name = file.getName();
        if (MavenUtil.isPomFileName(name)) {
            return true;
        }
        if (!MavenUtil.isPotentialPomFile(name)) {
            return false;
        }
        return MavenUtil.isPomFileIgnoringName(project2, file);
    }

    public static boolean containsDeclaredExtension(File extensionFile, @NotNull MavenId mavenId) {
        if (mavenId == null) {
            MavenUtil.$$$reportNull$$$0(56);
        }
        try {
            Element extensions = MavenUtil.getDomRootElement(extensionFile);
            if (extensions == null) {
                return false;
            }
            if (!extensions.getName().equals("extensions")) {
                return false;
            }
            for (Element extension : MavenUtil.getElementsWithRegardToNamespace(extensions, "extension", extensionListNamespaces)) {
                Element groupId = MavenUtil.getElementWithRegardToNamespace(extension, "groupId", extensionListNamespaces);
                Element artifactId = MavenUtil.getElementWithRegardToNamespace(extension, "artifactId", extensionListNamespaces);
                Element version2 = MavenUtil.getElementWithRegardToNamespace(extension, "version", extensionListNamespaces);
                if (groupId == null || !groupId.getTextTrim().equals(mavenId.getGroupId()) || artifactId == null || !artifactId.getTextTrim().equals(mavenId.getArtifactId()) || version2 == null || !version2.getTextTrim().equals(mavenId.getVersion())) continue;
                return true;
            }
        }
        catch (IOException | JDOMException e) {
            return false;
        }
        return false;
    }

    public static boolean isPomFileIgnoringName(@Nullable Project project2, @NotNull VirtualFile file) {
        if (file == null) {
            MavenUtil.$$$reportNull$$$0(57);
        }
        if (project2 == null || !project2.isInitialized()) {
            boolean bl;
            block12: {
                if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                    return false;
                }
                InputStream in = file.getInputStream();
                try {
                    final Ref isPomFile = Ref.create((Object)false);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)new NanoXmlBuilder(){

                        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                            if ("project".equals(name)) {
                                isPomFile.set((Object)nsURI.startsWith("http://maven.apache.org/POM/"));
                            }
                            NanoXmlBuilder.stop();
                        }
                    });
                    bl = (Boolean)isPomFile.get();
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ignore) {
                        return false;
                    }
                }
                in.close();
            }
            return bl;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        if (mavenProjectsManager.findProject(file) != null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2.isDisposed()) {
                return false;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
            if (psiFile == null) {
                return false;
            }
            return MavenDomUtil.isProjectFile(psiFile);
        });
    }

    public static Stream<VirtualFile> streamPomFiles(@Nullable Project project2, @Nullable VirtualFile root) {
        if (root == null) {
            return Stream.empty();
        }
        return Stream.of(root.getChildren()).filter(file -> MavenUtil.isPomFile(project2, file));
    }

    public static void restartConfigHighlighting(Collection<MavenProject> projects) {
        VirtualFile[] configFiles = MavenUtil.getConfigFiles(projects);
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((VirtualFile[])configFiles));
    }

    public static VirtualFile[] getConfigFiles(Collection<MavenProject> projects) {
        SmartList result2 = new SmartList();
        for (MavenProject project2 : projects) {
            VirtualFile file = MavenUtil.getConfigFile(project2, "/.mvn/maven.config");
            if (file == null) continue;
            result2.add(file);
        }
        if (result2.isEmpty()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return result2.toArray(VirtualFile.EMPTY_ARRAY);
    }

    public static VirtualFile getConfigFile(MavenProject mavenProject2, String fileRelativePath) {
        VirtualFile baseDir = MavenUtil.getVFileBaseDir(mavenProject2.getDirectoryFile());
        if (baseDir != null) {
            return baseDir.findFileByRelativePath(fileRelativePath);
        }
        return null;
    }

    public static Path toPath(@Nullable MavenProject mavenProject2, String path) {
        if (!Paths.get(path, new String[0]).isAbsolute()) {
            if (mavenProject2 == null) {
                throw new IllegalArgumentException("Project should be not-nul for non-absolute paths");
            }
            path = new File(mavenProject2.getDirectory(), path).getPath();
        }
        return new Path(path);
    }

    @NotNull
    public static Sdk getJdk(@NotNull Project project2, @NotNull String name) throws ExternalSystemJdkException {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(58);
        }
        if (name == null) {
            MavenUtil.$$$reportNull$$$0(59);
        }
        if (MavenWslUtil.useWslMaven(project2)) {
            Sdk sdk = MavenWslUtil.getWslJdk(project2, name);
            if (sdk == null) {
                MavenUtil.$$$reportNull$$$0(60);
            }
            return sdk;
        }
        if (name.equals("#JAVA_INTERNAL") || project2.isDefault()) {
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (sdk == null) {
                MavenUtil.$$$reportNull$$$0(61);
            }
            return sdk;
        }
        if (name.equals("#USE_PROJECT_JDK")) {
            Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
            if (res == null) {
                res = MavenUtil.suggestProjectSdk(project2);
            }
            if (res != null && res.getSdkType() instanceof JavaSdkType) {
                Sdk sdk = res;
                if (sdk == null) {
                    MavenUtil.$$$reportNull$$$0(62);
                }
                return sdk;
            }
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            if (sdk == null) {
                MavenUtil.$$$reportNull$$$0(63);
            }
            return sdk;
        }
        if (name.equals("#JAVA_HOME")) {
            String javaHome = ExternalSystemJdkUtil.getJavaHome();
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new InvalidJavaHomeException(javaHome);
            }
            Sdk sdk = JavaSdk.getInstance().createJdk("", javaHome);
            if (sdk == null) {
                MavenUtil.$$$reportNull$$$0(64);
            }
            return sdk;
        }
        Sdk projectJdk = MavenUtil.getSdkByExactName(name);
        if (projectJdk != null) {
            Sdk sdk = projectJdk;
            if (sdk == null) {
                MavenUtil.$$$reportNull$$$0(65);
            }
            return sdk;
        }
        throw new InvalidSdkException(name);
    }

    @Nullable
    protected static Sdk getSdkByExactName(@NotNull String name) {
        if (name == null) {
            MavenUtil.$$$reportNull$$$0(66);
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(name) || !(projectJdk.getSdkType() instanceof JavaSdkType)) continue;
            return projectJdk;
        }
        return null;
    }

    public static File getMavenPluginParentFile() {
        return Paths.get(PathManager.getCommunityHomePath(), "plugins", "maven").toFile();
    }

    @ApiStatus.Internal
    public static boolean isMavenUnitTestModeEnabled() {
        if (MavenUtil.shouldRunTasksAsynchronouslyInTests()) {
            return false;
        }
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean shouldRunTasksAsynchronouslyInTests() {
        return Boolean.getBoolean("maven.unit.tests.remove");
    }

    @NotNull
    public static String getCompilerPluginVersion(@NotNull MavenProject mavenProject2) {
        MavenPlugin plugin;
        if (mavenProject2 == null) {
            MavenUtil.$$$reportNull$$$0(67);
        }
        return (plugin = mavenProject2.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin")) != null ? plugin.getVersion() : "";
    }

    public static boolean isWrapper(@NotNull MavenGeneralSettings settings) {
        if (settings == null) {
            MavenUtil.$$$reportNull$$$0(68);
        }
        return "Use Maven wrapper".equals(settings.getMavenHome()) || StringUtil.equals((CharSequence)settings.getMavenHome(), (CharSequence)MavenProjectBundle.message("maven.wrapper.version.title", new Object[0]));
    }

    public static void setupProjectSdk(@NotNull Project project2) {
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(69);
        }
        if (ProjectRootManager.getInstance((Project)project2).getProjectSdk() == null) {
            Sdk projectSdk = MavenUtil.suggestProjectSdk(project2);
            if (projectSdk == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> JavaSdkUtil.applyJdkToProject((Project)project2, (Sdk)projectSdk));
        }
    }

    @Nullable
    public static Sdk suggestProjectSdk(@NotNull Project project2) {
        Project defaultProject;
        ProjectRootManager defaultProjectManager;
        Sdk defaultProjectSdk;
        if (project2 == null) {
            MavenUtil.$$$reportNull$$$0(70);
        }
        if ((defaultProjectSdk = (defaultProjectManager = ProjectRootManager.getInstance((Project)(defaultProject = ProjectManager.getInstance().getDefaultProject()))).getProjectSdk()) != null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
        return projectJdkTable.getSdksOfType((SdkTypeId)sdkType).stream().filter(it -> it.getHomePath() != null && JdkUtil.checkForJre((String)it.getHomePath())).filter(it -> MavenWslUtil.tryGetWslDistributionForPath(it.getHomePath()) == MavenWslUtil.tryGetWslDistribution(project2)).max(sdkType.versionComparator()).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Set<MavenRemoteRepository> getRemoteResolvedRepositories(@NotNull Project project2) {
        Set<MavenRemoteRepository> repositories;
        block10: {
            Set<MavenRemoteRepository> set;
            if (project2 == null) {
                MavenUtil.$$$reportNull$$$0(71);
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
            repositories = projectsManager.getRemoteRepositories();
            MavenEmbeddersManager embeddersManager = projectsManager.getEmbeddersManager();
            String baseDir = project2.getBasePath();
            List<MavenProject> projects = projectsManager.getRootProjects();
            if (!projects.isEmpty()) {
                baseDir = MavenUtil.getBaseDir(projects.get(0).getDirectoryFile()).toString();
            }
            if (null == baseDir) {
                baseDir = "";
            }
            MavenEmbedderWrapper embedderWrapper = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_POST_PROCESSING, baseDir);
            try {
                Set<MavenRemoteRepository> resolvedRepositories = embedderWrapper.resolveRepositories(repositories);
                Set<MavenRemoteRepository> set2 = resolvedRepositories.isEmpty() ? repositories : resolvedRepositories;
                set = set2;
            }
            catch (Exception e) {
                MavenLog.LOG.warn("resolve remote repo error", (Throwable)e);
                break block10;
            }
            finally {
                embeddersManager.release(embedderWrapper);
            }
            if (set == null) {
                MavenUtil.$$$reportNull$$$0(72);
            }
            return set;
        }
        Set<MavenRemoteRepository> set = repositories;
        if (set == null) {
            MavenUtil.$$$reportNull$$$0(73);
        }
        return set;
    }

    public static boolean isMavenizedModule(@NotNull Module m) {
        if (m == null) {
            MavenUtil.$$$reportNull$$$0(74);
        }
        try {
            return !m.isDisposed() && ExternalSystemModulePropertyManager.getInstance((Module)m).isMavenized();
        }
        catch (AlreadyDisposedException e) {
            return false;
        }
    }

    public static boolean isLinearImportEnabled() {
        return Registry.is((String)"maven.linear.import");
    }

    @ApiStatus.Internal
    public static boolean shouldResetDependenciesAndFolders(Collection<MavenProjectProblem> readingProblems) {
        if (Registry.is((String)"maven.always.reset")) {
            return true;
        }
        MavenProjectProblem unrecoverable = (MavenProjectProblem)ContainerUtil.find(readingProblems, it -> !it.isRecoverable());
        return unrecoverable == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 66, 67, 68, 69, 70, 71, 74 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: 
            case 9: 
            case 24: 
            case 32: 
            case 39: 
            case 45: 
            case 46: 
            case 58: 
            case 69: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 13: 
            case 16: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 33: 
            case 37: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepository";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectsManager";
                break;
            }
            case 50: 
            case 52: 
            case 54: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenId";
                break;
            }
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMavenProperties";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSystemDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "runInBackground";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalRepository";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteResolvedRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitWriteAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runDumbAware";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWhenInitialized";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPluginSystemDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDir";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "groupByBasedir";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVFileBaseDir";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runOrApplyMavenProjectFileTemplate";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addEventListener";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "makeLocalRepositoryFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactPath";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryParentFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getElementWithRegardToNamespace";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getElementsWithRegardToNamespace";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doResolveSuperPomFile";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "restartMavenConnectors";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "verifyMavenSdkRequirements";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "crcWithoutSpaces";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getModuleJreHome";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getModuleJavaVersion";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getModuleJdk";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaredExtension";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isPomFileIgnoringName";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getJdk";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSdkByExactName";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerPluginVersion";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isWrapper";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectSdk";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "suggestProjectSdk";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteResolvedRepositories";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 66, 67, 68, 69, 70, 71, 74 -> new IllegalArgumentException(string);
        };
    }

    public static interface MavenTaskHandler {
        public void waitFor();
    }
}

