/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.starters;

import com.intellij.ide.starters.StarterModuleImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/starters/MavenStarterModuleImporter;", "Lcom/intellij/ide/starters/StarterModuleImporter;", "()V", "id", "", "getId", "()Ljava/lang/String;", "title", "getTitle", "collectPomXml", "", "directoryFrom", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectionInto", "", "runAfterSetup", "", "module", "Lcom/intellij/openapi/module/Module;", "intellij.maven"})
public final class MavenStarterModuleImporter
implements StarterModuleImporter {
    @NotNull
    private final String id;
    @NotNull
    private final String title;

    public MavenStarterModuleImporter() {
        this.id = "maven";
        this.title = "Maven";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getTitle() {
        return this.title;
    }

    public boolean runAfterSetup(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        List pomXMLs = new ArrayList();
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(module).contentRoots");
        for (VirtualFile contentRoot : virtualFileArray) {
            Intrinsics.checkNotNullExpressionValue((Object)contentRoot, (String)"contentRoot");
            this.collectPomXml(contentRoot, pomXMLs);
            if (!((Collection)pomXMLs).isEmpty()) break;
        }
        if (pomXMLs.isEmpty()) {
            VirtualFile[] virtualFileArray2 = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getInstance(module).contentRoots");
            for (VirtualFile contentRoot : virtualFileArray2) {
                VirtualFile[] virtualFileArray3;
                Intrinsics.checkNotNullExpressionValue((Object)contentRoot.getChildren(), (String)"contentRoot.children");
                for (VirtualFile child : virtualFileArray3) {
                    if (!child.isDirectory()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.collectPomXml(child, pomXMLs);
                }
            }
        }
        if (pomXMLs.isEmpty()) {
            return true;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project3);
        mavenProjectsManager.addManagedFiles(pomXMLs);
        return false;
    }

    private final void collectPomXml(VirtualFile directoryFrom, Collection<VirtualFile> collectionInto) {
        VirtualFile child = directoryFrom.findChild("pom.xml");
        if (child != null) {
            collectionInto.add(child);
        }
    }
}

