/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public abstract class RemoteObjectWrapper<T> {
    @Nullable
    private final RemoteObjectWrapper<?> myParent;
    @Nullable
    private T myWrappee;

    protected RemoteObjectWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        this.myParent = parent;
    }

    @Nullable
    protected synchronized T getWrappee() {
        return this.myWrappee;
    }

    @NotNull
    protected synchronized T getOrCreateWrappee() throws RemoteException {
        if (this.myWrappee == null) {
            this.myWrappee = this.create();
            this.onWrappeeCreated();
        }
        this.onWrappeeAccessed();
        T t = this.myWrappee;
        if (t == null) {
            RemoteObjectWrapper.$$$reportNull$$$0(0);
        }
        return t;
    }

    @NotNull
    protected abstract T create() throws RemoteException;

    protected void onWrappeeCreated() throws RemoteException {
    }

    protected void onWrappeeAccessed() {
        if (this.myParent != null) {
            this.myParent.onWrappeeAccessed();
        }
    }

    protected synchronized void handleRemoteError(RemoteException e) {
        MavenLog.LOG.debug("[connector] Connection failed. Will be reconnected on the next request.", (Throwable)e);
        this.onError();
    }

    protected synchronized void onError() {
        this.cleanup();
        if (this.myParent != null) {
            this.myParent.onError();
        }
    }

    protected synchronized void cleanup() {
        this.myWrappee = null;
    }

    protected <R, E extends Exception> R perform(Retriable<R, E> r) throws E {
        RemoteException last = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
        }
        throw new CannotStartServerException(SyncBundle.message("maven.cannot.reconnect", new Object[0]), last);
    }

    protected <R, E extends Exception> R performCancelable(RetriableCancelable<R, E> r) throws MavenProcessCanceledException, E {
        RemoteException last = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
            catch (MavenServerProcessCanceledException e) {
                throw new MavenProcessCanceledException();
            }
        }
        throw new CannotStartServerException(SyncBundle.message("maven.cannot.reconnect", new Object[0]), last);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/RemoteObjectWrapper", "getOrCreateWrappee"));
    }

    @FunctionalInterface
    protected static interface Retriable<T, E extends Exception> {
        public T execute() throws RemoteException, E;
    }

    @FunctionalInterface
    protected static interface RetriableCancelable<T, E extends Exception> {
        public T execute() throws RemoteException, MavenServerProcessCanceledException, E;
    }
}

