/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class MavenIndexerWrapper
extends MavenRemoteObjectWrapper<MavenServerIndexer> {
    private static volatile Path ourTestIndicesDir;
    private MavenIndices myIndices;

    @TestOnly
    public static void setTestIndicesDir(Path myTestIndicesDir) {
        ourTestIndicesDir = myTestIndicesDir;
    }

    @NotNull
    public static Path getIndicesDir() {
        Path path = ourTestIndicesDir == null ? MavenUtil.getPluginSystemDir("Indices") : ourTestIndicesDir;
        if (path == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(0);
        }
        return path;
    }

    public MavenIndexerWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    public void releaseIndex(MavenIndexId mavenIndexId) throws MavenServerIndexerException {
        MavenLog.LOG.debug("releaseIndex " + mavenIndexId.indexId);
        MavenServerIndexer w = (MavenServerIndexer)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.releaseIndex(mavenIndexId, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public boolean indexExists(File dir2) {
        try {
            return ((MavenServerIndexer)this.getOrCreateWrappee()).indexExists(dir2, ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return false;
        }
    }

    public int getIndexCount() {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).getIndexCount(ourToken));
    }

    public void updateIndex(@NotNull MavenIndexId mavenIndexId, @Nullable MavenGeneralSettings settings, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException, MavenServerIndexerException {
        if (mavenIndexId == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(2);
        }
        this.performCancelable(() -> {
            MavenServerProgressIndicator indicatorWrapper = MavenIndexerWrapper.wrapAndExport(indicator);
            try {
                ((MavenServerIndexer)this.getOrCreateWrappee()).updateIndex(mavenIndexId, indicatorWrapper, ourToken);
            }
            finally {
                UnicastRemoteObject.unexportObject((Remote)indicatorWrapper, true);
            }
            return null;
        });
    }

    public void processArtifacts(MavenIndexId mavenIndexId, MavenIndicesProcessor processor, MavenProgressIndicator progress) throws MavenServerIndexerException {
        this.perform(() -> {
            try {
                List list;
                int start = 0;
                do {
                    if (progress.isCanceled()) {
                        return null;
                    }
                    MavenLog.LOG.warn("process artifacts: " + start);
                    list = ((MavenServerIndexer)this.getOrCreateWrappee()).processArtifacts(mavenIndexId, start, ourToken);
                    if (list == null) continue;
                    processor.processArtifacts(list);
                    start += list.size();
                } while (list != null);
                return null;
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @NotNull
    public List<AddArtifactResponse> addArtifacts(MavenIndexId mavenIndexId, Collection<File> artifactFiles) {
        List list = this.perform(() -> {
            try {
                return ((MavenServerIndexer)this.getOrCreateWrappee()).addArtifacts(mavenIndexId, artifactFiles, ourToken);
            }
            catch (Throwable ignore) {
                return ContainerUtil.map((Collection)artifactFiles, file -> new AddArtifactResponse(file, null));
            }
        });
        if (list == null) {
            MavenIndexerWrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    public Set<MavenArtifactInfo> search(MavenIndexId mavenIndexId, String pattern, int maxResult) throws MavenServerIndexerException {
        return this.perform(() -> ((MavenServerIndexer)this.getOrCreateWrappee()).search(mavenIndexId, pattern, maxResult, ourToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public MavenIndices getOrCreateIndices() {
        if (this.myIndices != null) {
            return this.myIndices;
        }
        MavenIndexerWrapper mavenIndexerWrapper = this;
        synchronized (mavenIndexerWrapper) {
            if (this.myIndices == null) {
                this.myIndices = this.createMavenIndices();
            }
            return this.myIndices;
        }
    }

    protected abstract MavenIndices createMavenIndices();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenIndexId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenIndexerWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

