/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.reposearch.DependencySearchService;

@ApiStatus.Internal
public class MavenIndices
implements Disposable {
    public static final String LOCAL_REPOSITORY_ID = "local";
    private static final Object ourDirectoryLock = new Object();
    private final MavenIndexerWrapper myIndexer;
    private final File myIndicesDir;
    @NotNull
    private volatile MavenIndexHolder myIndexHolder = new MavenIndexHolder(Collections.emptyList(), null);
    private volatile boolean indicesInit;
    private volatile boolean isDisposed;
    private final ReentrantLock updateIndicesLock = new ReentrantLock();

    public MavenIndices(MavenIndexerWrapper indexer, File indicesDir) {
        this.myIndexer = indexer;
        this.myIndicesDir = indicesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateIndicesList(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndices.$$$reportNull$$$0(0);
        }
        if (this.isDisposed) {
            return;
        }
        this.updateIndicesLock.lock();
        try {
            Map<String, Set<String>> remoteRepositoryIdsByUrl = MavenIndexUtils.getRemoteRepositoryIdsByUrl(project2);
            MavenIndexUtils.RepositoryInfo localRepository = MavenIndexUtils.getLocalRepository(project2);
            if (localRepository == null || project2.isDisposed()) {
                return;
            }
            if (this.myIndexHolder.isEquals(remoteRepositoryIdsByUrl.keySet(), localRepository.url)) {
                return;
            }
            MavenLog.LOG.debug("start update indices " + this.myIndexHolder);
            MavenIndex localIndex = this.myIndexHolder.getLocalIndex();
            List<MavenIndex> remoteIndices = this.myIndexHolder.getRemoteIndices();
            if (this.isDisposed) {
                return;
            }
            RepositoryDiffContext context2 = new RepositoryDiffContext(this.myIndexer, this.myIndicesDir);
            RepositoryDiff<MavenIndex> localDiff = MavenIndices.getLocalDiff(localRepository, context2, localIndex);
            RepositoryDiff<List<MavenIndex>> remoteDiff = MavenIndices.getRemoteDiff(remoteRepositoryIdsByUrl, remoteIndices, context2);
            this.myIndexHolder = new MavenIndexHolder((List)remoteDiff.newIndices, (MavenIndex)localDiff.newIndices);
            MavenLog.LOG.debug("new indices " + this.myIndexHolder);
            if (this.isDisposed) {
                this.closeIndices(this.myIndexHolder.getIndices());
            }
            this.indicesInit = true;
            this.closeIndices(MavenIndices.getOldIndices(localDiff, remoteDiff));
            MavenIndices.clearDependencySearchCache(project2);
        }
        catch (AlreadyDisposedException | IncorrectOperationException e) {
            this.myIndexHolder = new MavenIndexHolder(Collections.emptyList(), null);
        }
        finally {
            this.updateIndicesLock.unlock();
        }
    }

    public boolean isIndicesInit() {
        return this.indicesInit;
    }

    public boolean isNotInit() {
        return !this.indicesInit;
    }

    private static List<MavenIndex> getOldIndices(@NotNull RepositoryDiff<MavenIndex> localDiff, @NotNull RepositoryDiff<List<MavenIndex>> remoteDiff) {
        if (localDiff == null) {
            MavenIndices.$$$reportNull$$$0(1);
        }
        if (remoteDiff == null) {
            MavenIndices.$$$reportNull$$$0(2);
        }
        ArrayList<MavenIndex> oldIndices = new ArrayList<MavenIndex>((Collection)remoteDiff.oldIndices);
        if (localDiff.oldIndices != null) {
            oldIndices.add((MavenIndex)localDiff.oldIndices);
        }
        return oldIndices;
    }

    @NotNull
    private static List<MavenIndexUtils.IndexPropertyHolder> readCurrentIndexFileProperty(@NotNull File indicesDir) {
        Object[] indices;
        if (indicesDir == null) {
            MavenIndices.$$$reportNull$$$0(3);
        }
        if ((indices = indicesDir.listFiles()) == null) {
            List<MavenIndexUtils.IndexPropertyHolder> list = Collections.emptyList();
            if (list == null) {
                MavenIndices.$$$reportNull$$$0(4);
            }
            return list;
        }
        Arrays.sort(indices);
        ArrayList<MavenIndexUtils.IndexPropertyHolder> result2 = new ArrayList<MavenIndexUtils.IndexPropertyHolder>();
        for (Object each : indices) {
            if (!((File)each).isDirectory()) continue;
            try {
                MavenIndexUtils.IndexPropertyHolder propertyHolder = MavenIndexUtils.readIndexProperty((File)each);
                result2.add(propertyHolder);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        ArrayList<MavenIndexUtils.IndexPropertyHolder> arrayList = result2;
        if (arrayList == null) {
            MavenIndices.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public List<MavenIndex> getIndices() {
        return this.myIndexHolder.getIndices();
    }

    @NotNull
    public MavenIndexHolder getIndexHolder() {
        if (this.isDisposed) {
            throw new AlreadyDisposedException("Index was already disposed");
        }
        MavenIndexHolder mavenIndexHolder = this.myIndexHolder;
        if (mavenIndexHolder == null) {
            MavenIndices.$$$reportNull$$$0(6);
        }
        return mavenIndexHolder;
    }

    @NotNull
    private static File createNewIndexDir(File parent) {
        return MavenIndices.createNewDir(parent, "Index", 1000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static File createNewDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            int i2 = 0;
            while (true) {
                boolean createSuccessFull;
                if (i2 >= max) {
                    throw new RuntimeException("No available dir found");
                }
                String name = prefix + i2;
                File f = new File(parent, name);
                if (!f.exists() && (createSuccessFull = f.mkdirs())) {
                    File file = f;
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (file == null) {
                        MavenIndices.$$$reportNull$$$0(7);
                    }
                    return file;
                }
                ++i2;
            }
        }
    }

    public void dispose() {
        this.isDisposed = true;
        this.closeIndices(this.myIndexHolder.getIndices());
        this.myIndexHolder = null;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private void closeIndices(@NotNull List<MavenIndex> indices) {
        if (indices == null) {
            MavenIndices.$$$reportNull$$$0(8);
        }
        ArrayList<MavenIndex> list = new ArrayList<MavenIndex>(indices);
        for (MavenIndex each : list) {
            try {
                each.close(false);
            }
            catch (Exception e) {
                MavenLog.LOG.error("indices dispose error", (Throwable)e);
            }
        }
    }

    public static void updateOrRepair(@NotNull MavenSearchIndex index, boolean fullUpdate, @Nullable MavenGeneralSettings settings, MavenProgressIndicator progress) throws MavenProcessCanceledException {
        if (index == null) {
            MavenIndices.$$$reportNull$$$0(9);
        }
        index.updateOrRepair(fullUpdate, settings, progress);
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<MavenIndex> getLocalDiff(@NotNull MavenIndexUtils.RepositoryInfo localRepo, @NotNull RepositoryDiffContext context2, @Nullable MavenIndex currentLocalIndex) {
        if (localRepo == null) {
            MavenIndices.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(11);
        }
        if (currentLocalIndex != null && FileUtil.pathsEqual((String)localRepo.url, (String)currentLocalIndex.getRepositoryPathOrUrl())) {
            return new RepositoryDiff<Object>(currentLocalIndex, null);
        }
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders = MavenIndices.readCurrentIndexFileProperty(context2.indicesDir);
        context2.indexPropertyHolders = indexPropertyHolders;
        MavenIndex index = indexPropertyHolders.stream().filter(iph -> iph.kind == MavenSearchIndex.Kind.LOCAL && FileUtil.pathsEqual((String)iph.repositoryPathOrUrl, (String)localRepo.url)).findFirst().map(iph -> MavenIndices.createMavenIndex(iph, context2)).orElseGet(() -> {
            MavenIndexUtils.IndexPropertyHolder propertyHolder = new MavenIndexUtils.IndexPropertyHolder(MavenIndices.createNewIndexDir(context2.indicesDir), MavenSearchIndex.Kind.LOCAL, Collections.singleton(LOCAL_REPOSITORY_ID), localRepo.url);
            return MavenIndices.createMavenIndex(propertyHolder, context2);
        });
        if (index == null) {
            return new RepositoryDiff<Object>(currentLocalIndex, null);
        }
        return new RepositoryDiff<MavenIndex>(index, currentLocalIndex);
    }

    @VisibleForTesting
    @NotNull
    static RepositoryDiff<List<MavenIndex>> getRemoteDiff(@NotNull Map<String, Set<String>> remoteRepositoryIdsByUrl, @NotNull List<MavenIndex> currentRemoteIndex, @NotNull RepositoryDiffContext context2) {
        Map currentRemoteIndicesByUrls;
        if (remoteRepositoryIdsByUrl == null) {
            MavenIndices.$$$reportNull$$$0(12);
        }
        if (currentRemoteIndex == null) {
            MavenIndices.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(14);
        }
        if ((currentRemoteIndicesByUrls = currentRemoteIndex.stream().collect(Collectors.toMap(i2 -> i2.getRepositoryPathOrUrl(), Function.identity()))).keySet().equals(remoteRepositoryIdsByUrl.keySet())) {
            return new RepositoryDiff<List<MavenIndex>>(currentRemoteIndex, Collections.emptyList());
        }
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders = context2.indexPropertyHolders;
        indexPropertyHolders = indexPropertyHolders != null ? indexPropertyHolders : MavenIndices.readCurrentIndexFileProperty(context2.indicesDir);
        Map propertyHolderMapByUrl = indexPropertyHolders.stream().filter(iph -> iph.kind == MavenSearchIndex.Kind.REMOTE).collect(Collectors.toMap(iph -> iph.repositoryPathOrUrl, Function.identity(), (i1, i2) -> i1));
        List oldIndices = ContainerUtil.filter(currentRemoteIndex, i2 -> !remoteRepositoryIdsByUrl.containsKey(i2.getRepositoryPathOrUrl()));
        List newMavenIndices = remoteRepositoryIdsByUrl.entrySet().stream().map(e -> MavenIndices.getOrCreateMavenIndex((MavenIndex)currentRemoteIndicesByUrls.get(e.getKey()), (MavenIndexUtils.IndexPropertyHolder)propertyHolderMapByUrl.get(e.getKey()), e, context2)).filter(i2 -> i2 != null).collect(Collectors.toList());
        return new RepositoryDiff<List<MavenIndex>>(newMavenIndices, oldIndices);
    }

    private static MavenIndex getOrCreateMavenIndex(@Nullable MavenIndex index, @Nullable MavenIndexUtils.IndexPropertyHolder propertyHolder, @NotNull Map.Entry<String, Set<String>> remoteEntry, @NotNull RepositoryDiffContext context2) {
        if (remoteEntry == null) {
            MavenIndices.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(16);
        }
        if (index != null) {
            return index;
        }
        if (propertyHolder != null) {
            index = MavenIndices.createMavenIndex(propertyHolder, context2);
        }
        if (index != null) {
            return index;
        }
        propertyHolder = new MavenIndexUtils.IndexPropertyHolder(MavenIndices.createNewIndexDir(context2.indicesDir), MavenSearchIndex.Kind.REMOTE, remoteEntry.getValue(), remoteEntry.getKey());
        return MavenIndices.createMavenIndex(propertyHolder, context2);
    }

    private static void clearDependencySearchCache(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndices.$$$reportNull$$$0(17);
        }
        try {
            DependencySearchService.getInstance((Project)project2).clearCache();
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    @Nullable
    private static MavenIndex createMavenIndex(@NotNull MavenIndexUtils.IndexPropertyHolder propertyHolder, @NotNull RepositoryDiffContext context2) {
        if (propertyHolder == null) {
            MavenIndices.$$$reportNull$$$0(18);
        }
        if (context2 == null) {
            MavenIndices.$$$reportNull$$$0(19);
        }
        try {
            return new MavenIndex(context2.indexer, propertyHolder);
        }
        catch (Exception e) {
            FileUtil.delete((File)propertyHolder.dir);
            MavenLog.LOG.warn((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDiff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteDiff";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicesDir";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepo";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositoryIdsByUrl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRemoteIndex";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteEntry";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readCurrentIndexFileProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateIndicesList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOldIndices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readCurrentIndexFileProperty";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "closeIndices";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateOrRepair";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalDiff";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDiff";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMavenIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearDependencySearchCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createMavenIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    static class RepositoryDiffContext {
        @NotNull
        final MavenIndexerWrapper indexer;
        @NotNull
        final File indicesDir;
        @Nullable
        List<MavenIndexUtils.IndexPropertyHolder> indexPropertyHolders;

        RepositoryDiffContext(@NotNull MavenIndexerWrapper indexer, @NotNull File dir2) {
            if (indexer == null) {
                RepositoryDiffContext.$$$reportNull$$$0(0);
            }
            if (dir2 == null) {
                RepositoryDiffContext.$$$reportNull$$$0(1);
            }
            this.indexer = indexer;
            this.indicesDir = dir2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/indices/MavenIndices$RepositoryDiffContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RepositoryDiff<T> {
        final T newIndices;
        final T oldIndices;

        private RepositoryDiff(T newIndices, T oldIndices) {
            this.newIndices = newIndices;
            this.oldIndices = oldIndices;
        }
    }
}

