/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingContextUtils;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandLineProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import icons.OpenapiIcons;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenCommandLineOptions;
import org.jetbrains.idea.maven.execution.MavenRunAnythingProvider;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunAnythingMavenItem;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0014 \u0010*\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u000f0\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider;", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider;", "()V", "completeBasicPhases", "Lkotlin/sequences/Sequence;", "", "commandLine", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingCommandLineProvider$CommandLine;", "completeCustomGoals", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "completeOptions", "isLongOpt", "", "getCompletionGroupTitle", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "getHelpCommand", "getHelpCommandPlaceholder", "getHelpGroupTitle", "getHelpIcon", "Ljavax/swing/Icon;", "getIcon", "value", "getMainListItem", "Lorg/jetbrains/idea/maven/execution/RunAnythingMavenItem;", "run", "suggestCompletionVariants", "getMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lcom/intellij/ide/actions/runAnything/RunAnythingContext;", "projectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "Companion", "intellij.maven"})
public final class MavenRunAnythingProvider
extends RunAnythingCommandLineProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String HELP_COMMAND = "mvn";

    @NotNull
    public String getHelpCommand() {
        return HELP_COMMAND;
    }

    @NotNull
    public Icon getHelpIcon() {
        Icon icon = OpenapiIcons.RepositoryLibraryLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RepositoryLibraryLogo");
        return icon;
    }

    @NotNull
    public String getHelpGroupTitle() {
        return "Maven";
    }

    @NotNull
    public Icon getIcon(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Icon icon = OpenapiIcons.RepositoryLibraryLogo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RepositoryLibraryLogo");
        return icon;
    }

    public String getCompletionGroupTitle() {
        return RunnerBundle.message("popup.title.maven.goals", new Object[0]);
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return "mvn <goals...> <options...>";
    }

    @NotNull
    public RunAnythingMavenItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new RunAnythingMavenItem(this.getCommand(value), this.getIcon(value));
    }

    @NotNull
    protected Sequence<String> suggestCompletionVariants(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Sequence basicPhasesVariants = SequencesKt.sorted(this.completeBasicPhases(commandLine));
        Sequence customGoalsVariants = SequencesKt.sorted(this.completeCustomGoals(dataContext, commandLine));
        Sequence longOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, true));
        Sequence shortOptionsVariants = SequencesKt.sorted(this.completeOptions(commandLine, false));
        return StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"--", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)longOptionsVariants, (Sequence)shortOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : (StringsKt.startsWith$default((String)commandLine.getToComplete(), (String)"-", (boolean)false, (int)2, null) ? SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)shortOptionsVariants, (Sequence)longOptionsVariants), (Sequence)basicPhasesVariants), (Sequence)customGoalsVariants) : SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)basicPhasesVariants, (Sequence)customGoalsVariants), (Sequence)longOptionsVariants), (Sequence)shortOptionsVariants));
    }

    protected boolean run(@NotNull DataContext dataContext, @NotNull RunAnythingCommandLineProvider.CommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Project project2 = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"fetchProject(dataContext)");
        Project project3 = project2;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProviderBase.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = (RunAnythingContext)new RunAnythingContext.ProjectContext(project3);
        }
        RunAnythingContext context2 = runAnythingContext;
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project3);
        Intrinsics.checkNotNullExpressionValue((Object)projectsManager, (String)"projectsManager");
        MavenProject mavenProject2 = this.getMavenProject(context2, projectsManager);
        Object object = mavenProject2;
        if ((object == null || (object = ((MavenProject)object).getDirectory()) == null) && (object = RunAnythingContextUtils.getPath((RunAnythingContext)context2)) == null) {
            return false;
        }
        Object workingDirPath = object;
        Object object2 = mavenProject2;
        if (object2 == null || (object2 = ((MavenProject)object2).getFile()) == null || (object2 = object2.getName()) == null) {
            object2 = "pom.xml";
        }
        Object pomFileName = object2;
        MavenExplicitProfiles mavenExplicitProfiles = projectsManager.getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"projectsManager.explicitProfiles");
        MavenExplicitProfiles explicitProfiles = mavenExplicitProfiles;
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        List goals2 = commandLine.getParameters();
        MavenRunnerParameters params = new MavenRunnerParameters(true, (String)workingDirPath, (String)pomFileName, goals2, enabledProfiles, disabledProfiles);
        MavenRunner mavenRunner = MavenRunner.getInstance(project3);
        mavenRunner.run(params, mavenRunner.getSettings(), null);
        return true;
    }

    private final MavenProject getMavenProject(RunAnythingContext $this$getMavenProject, MavenProjectsManager projectsManager) {
        MavenProject mavenProject2;
        RunAnythingContext runAnythingContext = $this$getMavenProject;
        if (runAnythingContext instanceof RunAnythingContext.ProjectContext) {
            List<MavenProject> list = projectsManager.getRootProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"projectsManager.rootProjects");
            mavenProject2 = (MavenProject)CollectionsKt.firstOrNull(list);
        } else if (runAnythingContext instanceof RunAnythingContext.ModuleContext) {
            mavenProject2 = projectsManager.findProject(((RunAnythingContext.ModuleContext)$this$getMavenProject).getModule());
        } else if (runAnythingContext instanceof RunAnythingContext.RecentDirectoryContext) {
            mavenProject2 = null;
        } else if (runAnythingContext instanceof RunAnythingContext.BrowseRecentDirectoryContext) {
            mavenProject2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mavenProject2;
    }

    private final Sequence<String> completeOptions(RunAnythingCommandLineProvider.CommandLine commandLine, boolean isLongOpt) {
        Collection<MavenCommandLineOptions.Option> collection = MavenCommandLineOptions.getAllOptions();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllOptions()");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<MavenCommandLineOptions.Option, String>(isLongOpt){
            final /* synthetic */ boolean $isLongOpt;
            {
                this.$isLongOpt = $isLongOpt;
                super(1);
            }

            @Nullable
            public final String invoke(MavenCommandLineOptions.Option it) {
                return it.getName(this.$isLongOpt);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;
            {
                this.$commandLine = $commandLine;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$commandLine.contains(it);
            }
        }));
    }

    private final Sequence<String> completeBasicPhases(RunAnythingCommandLineProvider.CommandLine commandLine) {
        List list = MavenConstants.BASIC_PHASES;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"BASIC_PHASES");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;
            {
                this.$commandLine = $commandLine;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return !this.$commandLine.contains(it);
            }
        }));
    }

    private final Sequence<String> completeCustomGoals(DataContext dataContext, RunAnythingCommandLineProvider.CommandLine commandLine) {
        MavenProjectsManager projectsManager;
        RunAnythingContext context2;
        Project project2 = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"fetchProject(dataContext)");
        Project project3 = project2;
        RunAnythingContext runAnythingContext = (RunAnythingContext)dataContext.getData(RunAnythingProvider.EXECUTING_CONTEXT);
        if (runAnythingContext == null) {
            runAnythingContext = context2 = (RunAnythingContext)new RunAnythingContext.ProjectContext(project3);
        }
        if (!(projectsManager = MavenProjectsManager.getInstance(project3)).isMavenizedProject()) {
            return SequencesKt.emptySequence();
        }
        Intrinsics.checkNotNullExpressionValue((Object)projectsManager, (String)"projectsManager");
        MavenProject mavenProject2 = this.getMavenProject(context2, projectsManager);
        if (mavenProject2 == null) {
            return SequencesKt.emptySequence();
        }
        MavenProject mavenProject3 = mavenProject2;
        File localRepository = projectsManager.getLocalRepository();
        List<MavenPlugin> list = mavenProject3.getDeclaredPlugins();
        Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.declaredPlugins");
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<MavenPlugin, MavenPluginInfo>(localRepository){
            final /* synthetic */ File $localRepository;
            {
                this.$localRepository = $localRepository;
                super(1);
            }

            @Nullable
            public final MavenPluginInfo invoke(MavenPlugin it) {
                return MavenArtifactUtil.readPluginInfo(this.$localRepository, it.getMavenId());
            }
        })), (Function1)completeCustomGoals.2.INSTANCE), (Function1)completeCustomGoals.3.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(commandLine){
            final /* synthetic */ RunAnythingCommandLineProvider.CommandLine $commandLine;
            {
                this.$commandLine = $commandLine;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return !this.$commandLine.contains(it);
            }
        }));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/execution/MavenRunAnythingProvider$Companion;", "", "()V", "HELP_COMMAND", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

