/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenDependencyInsertionHandler;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.PoisonedRepositoryArtifactData;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0014J\u001f\u0010\u0018\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/MavenGroupIdCompletionContributor;", "Lorg/jetbrains/idea/maven/dom/model/completion/MavenCoordinateCompletionContributor;", "()V", "fillResults", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "coordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "cld", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "promise", "Lorg/jetbrains/concurrency/Promise;", "", "completionPrefix", "", "find", "service", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "consumer", "Ljava/util/function/Consumer;", "handleEmptyLookup", "Lcom/intellij/openapi/util/NlsContexts$HintText;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenGroupIdCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenGroupIdCompletionContributor.kt\norg/jetbrains/idea/maven/dom/model/completion/MavenGroupIdCompletionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class MavenGroupIdCompletionContributor
extends MavenCoordinateCompletionContributor {
    public MavenGroupIdCompletionContributor() {
        super("groupId");
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return new MavenCoordinateCompletionContributor.PlaceChecker(parameters).checkPlace().isCorrectPlace() ? IndicesBundle.message("maven.dependency.completion.group.empty", new Object[0]) : null;
    }

    @Override
    @NotNull
    protected Promise<Integer> find(@NotNull DependencySearchService service, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        String string = MavenCoordinateCompletionContributor.trimDummy(coordinates.getGroupId().getStringValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimDummy(coordinates.groupId.stringValue)");
        String groupId = string;
        String string2 = MavenCoordinateCompletionContributor.trimDummy(coordinates.getArtifactId().getStringValue());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimDummy(coordinates.artifactId.stringValue)");
        String artifactId = string2;
        Intrinsics.checkNotNullExpressionValue((Object)searchParameters, (String)"searchParameters");
        Consumer<RepositoryArtifactData> consumer2 = MavenCoordinateCompletionContributor.withPredicate(consumer, arg_0 -> MavenGroupIdCompletionContributor.find$lambda$0(artifactId, arg_0));
        Intrinsics.checkNotNullExpressionValue(consumer2, (String)"withPredicate(consumer,\n\u2026ctId == it.artifactId) })");
        return service.suggestPrefix(groupId, artifactId, searchParameters, consumer2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillResults(@NotNull CompletionResultSet result2, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull ConcurrentLinkedDeque<RepositoryArtifactData> cld, @NotNull Promise<Integer> promise2, @NotNull String completionPrefix) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter(cld, (String)"cld");
        Intrinsics.checkNotNullParameter(promise2, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)completionPrefix, (String)"completionPrefix");
        HashSet<String> set = new HashSet<String>();
        while (promise2.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            RepositoryArtifactData item = cld.poll();
            if (item instanceof MavenRepositoryArtifactInfo && set.add(((MavenRepositoryArtifactInfo)item).getGroupId())) {
                void it;
                LookupElementBuilder lookupElementBuilder;
                LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder = MavenDependencyCompletionUtil.lookupElement((MavenRepositoryArtifactInfo)item, ((MavenRepositoryArtifactInfo)item).getGroupId()).withInsertHandler(MavenDependencyInsertionHandler.INSTANCE);
                CompletionResultSet completionResultSet = result2;
                boolean bl = false;
                it.putUserData(MavenCoordinateCompletionContributor.MAVEN_COORDINATE_COMPLETION_PREFIX_KEY, (Object)completionPrefix);
                completionResultSet.addElement((LookupElement)lookupElementBuilder);
            }
            if (item != PoisonedRepositoryArtifactData.INSTANCE) continue;
            break;
        }
    }

    private static final boolean find$lambda$0(String $artifactId, RepositoryArtifactData it) {
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        return it instanceof MavenRepositoryArtifactInfo && (((CharSequence)$artifactId).length() == 0 || Intrinsics.areEqual((Object)$artifactId, (Object)((MavenRepositoryArtifactInfo)it).getArtifactId()));
    }
}

