/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class JabbaInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private Provider<String> jabbaHomeDir = this.getEnvironmentProperty("JABBA_HOME");

    @Inject
    public JabbaInstallationSupplier(ProviderFactory factory) {
        super(factory);
    }

    @Override
    public String getSourceName() {
        return "Jabba";
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        return this.jabbaHomeDir.map(this.findJavaCandidates()).getOrElse(Collections.emptySet());
    }

    private Transformer<Set<InstallationLocation>, String> findJavaCandidates() {
        return jabbaHome -> {
            File root = new File((String)jabbaHome, "jdk");
            return FileBasedInstallationFactory.fromDirectory(root, this.getSourceName());
        };
    }
}

