/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.impldep.com.jcraft.jsch.ChannelSftp;
import org.gradle.internal.impldep.com.jcraft.jsch.SftpException;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;

public class SftpResourceUploader
implements ExternalResourceUploader {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceUploader(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        LockableSftpClient client = this.sftpClientFactory.createSftpClient(destination.getUri(), this.credentials);
        try {
            ChannelSftp channel = client.getSftpClient();
            this.ensureParentDirectoryExists(channel, destination.getUri());
            try (InputStream sourceStream = resource.open();){
                channel.put(sourceStream, destination.getPath());
            }
        }
        catch (SftpException e) {
            throw ResourceExceptions.putFailed(destination.getUri(), e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(client);
        }
    }

    private void ensureParentDirectoryExists(ChannelSftp channel, URI uri) {
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)uri.getPath());
        if (parentPath.equals("/")) {
            return;
        }
        URI parent = uri.resolve(parentPath);
        try {
            channel.lstat(parentPath);
            return;
        }
        catch (SftpException e) {
            if (e.id != 2) {
                throw new ResourceException(parent, String.format("Could not lstat resource '%s'.", parent), e);
            }
            this.ensureParentDirectoryExists(channel, parent);
            try {
                channel.mkdir(parentPath);
            }
            catch (SftpException e2) {
                throw new ResourceException(parent, String.format("Could not create resource '%s'.", parent), e2);
            }
            return;
        }
    }
}

