/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenDependencyType;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantSelectionResult;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class MavenDependencyDescriptor
extends ExternalDependencyDescriptor {
    private final ModuleComponentSelector selector;
    private final MavenScope scope;
    private final MavenDependencyType type;
    private final ImmutableList<ExcludeMetadata> excludes;
    @Nullable
    private final IvyArtifactName dependencyArtifact;

    public MavenDependencyDescriptor(MavenScope scope, MavenDependencyType type, ModuleComponentSelector selector, @Nullable IvyArtifactName dependencyArtifact, List<ExcludeMetadata> excludes) {
        this.scope = scope;
        this.selector = selector;
        this.type = type;
        this.dependencyArtifact = dependencyArtifact;
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public String toString() {
        return "dependency: " + this.getSelector() + ", scope: " + (Object)((Object)this.scope) + ", optional: " + this.isOptional();
    }

    public MavenScope getScope() {
        return this.scope;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return !this.isConstraint() && !this.isOptional();
    }

    @Override
    public VariantSelectionResult selectLegacyConfigurations(ComponentIdentifier fromComponent, ConfigurationMetadata fromConfiguration, ComponentGraphResolveState targetComponentState) {
        ConfigurationGraphResolveMetadata master;
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        ImmutableList.Builder result2 = ImmutableList.builder();
        boolean requiresCompile = fromConfiguration.getName().equals("compile");
        if (!requiresCompile) {
            ConfigurationGraphResolveMetadata runtime = this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "runtime");
            result2.add((Object)runtime);
            boolean bl = requiresCompile = !runtime.getHierarchy().contains("compile");
        }
        if (requiresCompile) {
            result2.add((Object)this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "compile"));
        }
        if (!((master = targetComponent.getConfiguration("master")) == null || master.getDependencies().isEmpty() && targetComponentState.resolveArtifactsFor(master).getArtifacts().isEmpty())) {
            result2.add((Object)master);
        }
        return new VariantSelectionResult((List<? extends VariantGraphResolveMetadata>)result2.build(), false);
    }

    private ConfigurationGraphResolveMetadata findTargetConfiguration(ComponentIdentifier fromComponentId, ConfigurationMetadata fromConfiguration, ComponentGraphResolveMetadata targetComponent, String target) {
        ConfigurationGraphResolveMetadata configuration = targetComponent.getConfiguration(target);
        if (configuration == null && (configuration = targetComponent.getConfiguration("default")) == null) {
            throw new ConfigurationNotFoundException(fromComponentId, fromConfiguration.getName(), target, targetComponent.getId());
        }
        return configuration;
    }

    @Override
    protected ExternalDependencyDescriptor withRequested(ModuleComponentSelector newRequested) {
        return new MavenDependencyDescriptor(this.scope, this.type, newRequested, this.dependencyArtifact, (List<ExcludeMetadata>)this.excludes);
    }

    public List<ExcludeMetadata> getAllExcludes() {
        return this.excludes;
    }

    public MavenDependencyType getType() {
        return this.type;
    }

    @Override
    public List<ExcludeMetadata> getConfigurationExcludes(Collection<String> configurations) {
        if (this.type == MavenDependencyType.OPTIONAL_DEPENDENCY) {
            return Collections.emptyList();
        }
        return this.excludes;
    }

    @Nullable
    public IvyArtifactName getDependencyArtifact() {
        return this.dependencyArtifact;
    }

    public ImmutableList<IvyArtifactName> getConfigurationArtifacts(ConfigurationMetadata fromConfiguration) {
        if (this.isOptional()) {
            return this.getArtifactsForOptionalDependency();
        }
        return this.getDependencyArtifacts();
    }

    private ImmutableList<IvyArtifactName> getArtifactsForOptionalDependency() {
        return ImmutableList.of();
    }

    private ImmutableList<IvyArtifactName> getDependencyArtifacts() {
        return this.dependencyArtifact == null ? ImmutableList.of() : ImmutableList.of((Object)this.dependencyArtifact);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public boolean isOptional() {
        return this.type == MavenDependencyType.OPTIONAL_DEPENDENCY;
    }

    @Override
    public boolean isConstraint() {
        return this.type == MavenDependencyType.DEPENDENCY_MANAGEMENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenDependencyDescriptor that = (MavenDependencyDescriptor)o;
        return this.type == that.type && Objects.equal((Object)this.selector, (Object)that.selector) && this.scope == that.scope && Objects.equal(this.excludes, that.excludes) && Objects.equal((Object)this.dependencyArtifact, (Object)that.dependencyArtifact);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.selector, this.scope, this.type, this.excludes, this.dependencyArtifact});
    }
}

