/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.Stat;

public class SingleFileTreeElementMatcher {
    private final Stat stat;

    public SingleFileTreeElementMatcher(Stat stat) {
        this.stat = stat;
    }

    public boolean elementWithRelativePathMatches(Spec<FileTreeElement> filter, File element, String relativePathString) {
        boolean elementIsFile = !element.isDirectory();
        RelativePath relativePath = RelativePath.parse(elementIsFile, relativePathString);
        if (!filter.isSatisfiedBy(new ReadOnlyFileTreeElement(element, relativePath, this.stat))) {
            return false;
        }
        RelativePath parentRelativePath = relativePath.getParent();
        File parentFile = element.getParentFile();
        while (parentRelativePath != null && parentRelativePath != RelativePath.EMPTY_ROOT) {
            if (!filter.isSatisfiedBy(new ReadOnlyFileTreeElement(parentFile, parentRelativePath, this.stat))) {
                return false;
            }
            parentRelativePath = parentRelativePath.getParent();
            parentFile = parentFile.getParentFile();
        }
        return true;
    }

    private static class ReadOnlyFileTreeElement
    implements FileTreeElement {
        private final File file;
        private final RelativePath relativePath;
        private final Stat stat;

        public ReadOnlyFileTreeElement(File file, RelativePath relativePath, Stat stat) {
            this.file = file;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return !this.relativePath.isFile();
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public long getSize() {
            return this.file.length();
        }

        @Override
        public InputStream open() {
            try {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.relativePath.getPathString();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.relativePath;
        }

        @Override
        public int getMode() {
            return this.stat.getUnixMode(this.file);
        }
    }
}

