/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.execution.ProjectExecutionServices;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;

public class ProjectExecutionServiceRegistry
implements AutoCloseable {
    private final NodeExecutionContext global;
    private final LoadingCache<ProjectInternal, NodeExecutionContext> projectRegistries = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ProjectInternal, NodeExecutionContext>(){

        public NodeExecutionContext load(@Nonnull ProjectInternal project) {
            return new DefaultNodeExecutionContext(new ProjectExecutionServices(project));
        }
    });

    public ProjectExecutionServiceRegistry(ServiceRegistry globalServices) {
        this.global = globalServices::get;
    }

    public NodeExecutionContext forProject(@Nullable ProjectInternal project) {
        if (project == null) {
            return this.global;
        }
        return (NodeExecutionContext)this.projectRegistries.getUnchecked((Object)project);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.projectRegistries.asMap().values()).stop();
    }

    private static class DefaultNodeExecutionContext
    implements NodeExecutionContext,
    Closeable {
        private final ProjectExecutionServices services;

        public DefaultNodeExecutionContext(ProjectExecutionServices services) {
            this.services = services;
        }

        @Override
        public <T> T getService(Class<T> type) throws ServiceLookupException {
            return this.services.get(type);
        }

        @Override
        public void close() throws IOException {
            this.services.close();
        }
    }
}

