/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.initialization.ConfigureBuildBuildOperationType;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationFiringProjectsPreparer
implements ProjectsPreparer {
    private static final ConfigureBuildBuildOperationType.Result CONFIGURE_BUILD_RESULT = new ConfigureBuildBuildOperationType.Result(){};
    private final ProjectsPreparer delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperationFiringProjectsPreparer(ProjectsPreparer delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        this.buildOperationExecutor.run(new ConfigureBuild(gradle));
    }

    private class ConfigureBuild
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public ConfigureBuild(GradleInternal gradle) {
            this.gradle = gradle;
        }

        @Override
        public void run(BuildOperationContext context) {
            BuildOperationFiringProjectsPreparer.this.delegate.prepareProjects(this.gradle);
            context.setResult(CONFIGURE_BUILD_RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            BuildOperationDescriptor.Builder builder = BuildOperationDescriptor.displayName(this.gradle.contextualize("Configure build"));
            if (this.gradle.isRootBuild()) {
                builder.metadata(BuildOperationCategory.CONFIGURE_ROOT_BUILD);
            } else {
                builder.metadata(BuildOperationCategory.CONFIGURE_BUILD);
            }
            builder.totalProgress(this.gradle.getSettings().getProjectRegistry().size());
            return builder.details(new ConfigureBuildBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return ConfigureBuild.this.gradle.getIdentityPath().toString();
                }
            });
        }
    }
}

