/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyModifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalModuleDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Nested;

@Incubating
public interface PlatformDependencyModifiers {
    @Nested
    public PlatformDependencyModifier getPlatform();

    @Nested
    public EnforcedPlatformDependencyModifier getEnforcedPlatform();

    @Incubating
    public static abstract class EnforcedPlatformDependencyModifier
    implements DependencyModifier {
        @Inject
        protected abstract ObjectFactory getObjectFactory();

        @Override
        public <D extends ModuleDependency> D modify(D dependency) {
            if (dependency instanceof ExternalDependency) {
                ((AbstractExternalModuleDependency)dependency).version(constraint -> constraint.strictly(dependency.getVersion()));
            }
            dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, this.getObjectFactory().named(Category.class, "enforced-platform")));
            return dependency;
        }
    }

    @Incubating
    public static abstract class PlatformDependencyModifier
    implements DependencyModifier {
        @Inject
        protected abstract ObjectFactory getObjectFactory();

        @Override
        public <D extends ModuleDependency> D modify(D dependency) {
            dependency.endorseStrictVersions();
            dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, this.getObjectFactory().named(Category.class, "platform")));
            return dependency;
        }
    }
}

