/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final List<Capability> capabilities = new ArrayList<Capability>(1);
    private final ProjectInternal project;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;
    private boolean allowPublication = true;

    public DefaultJavaFeatureSpec(String name, ProjectInternal project) {
        this.name = name;
        this.project = project;
    }

    @Override
    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Override
    public void capability(String group, String name, String version) {
        this.capabilities.add(new DefaultImmutableCapability(group, name, version));
    }

    @Override
    public void create() {
        this.setupConfigurations(this.sourceSet);
    }

    @Override
    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    @Override
    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    @Override
    public void disablePublication() {
        this.allowPublication = false;
    }

    private void setupConfigurations(SourceSet sourceSet) {
        if (sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        if (this.capabilities.isEmpty()) {
            this.capabilities.add(new ProjectDerivedCapability(this.project, this.name));
        }
        ConfigurationRole role = ConfigurationRolesForMigration.CONSUMABLE_BUCKET_TO_CONSUMABLE;
        DefaultJvmFeature feature = new DefaultJvmFeature(this.name, sourceSet, this.capabilities, this.project, role, SourceSet.isMain(sourceSet));
        feature.withApi();
        AdhocComponentWithVariants component = this.findJavaComponent();
        if (this.withJavadocJar && component != null) {
            feature.withJavadocJar();
            Configuration javadocElements = feature.getJavadocElementsConfiguration();
            component.addVariantsFromConfiguration(javadocElements, new JavaConfigurationVariantMapping("runtime", true));
        }
        if (this.withSourcesJar && component != null) {
            feature.withSourcesJar();
            Configuration sourcesElements = feature.getSourcesElementsConfiguration();
            component.addVariantsFromConfiguration(sourcesElements, new JavaConfigurationVariantMapping("runtime", true));
        }
        if (this.allowPublication && component != null) {
            component.addVariantsFromConfiguration(feature.getApiElementsConfiguration(), new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(feature.getRuntimeElementsConfiguration(), new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Nullable
    public AdhocComponentWithVariants findJavaComponent() {
        SoftwareComponent component = (SoftwareComponent)this.project.getComponents().findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }
}

