/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.function.BiFunction;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.plugins.DistributionPlugin;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultApplicationPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaApplication;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.internal.JavaExecExecutableUtils;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public abstract class ApplicationPlugin
implements Plugin<Project> {
    public static final String APPLICATION_PLUGIN_NAME = "application";
    public static final String APPLICATION_GROUP = "application";
    public static final String TASK_RUN_NAME = "run";
    public static final String TASK_START_SCRIPTS_NAME = "startScripts";
    public static final String TASK_DIST_ZIP_NAME = "distZip";
    public static final String TASK_DIST_TAR_NAME = "distTar";

    @Override
    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(DistributionPlugin.class);
        JvmFeatureInternal mainFeature = JavaPluginHelper.getJavaComponent(project).getMainFeature();
        JavaApplication extension = this.addExtension(project);
        this.addRunTask(project, mainFeature, extension);
        this.addCreateScriptsTask(project, mainFeature, extension);
        this.configureJavaCompileTask(mainFeature.getCompileJavaTask(), extension);
        this.configureInstallTask(project.getProviders(), (TaskProvider<Sync>)tasks.named("installDist", Sync.class), extension);
        DistributionContainer distributions = project.getExtensions().getByType(DistributionContainer.class);
        Distribution mainDistribution = (Distribution)distributions.getByName("main");
        this.configureDistribution(project, mainFeature, mainDistribution, extension);
    }

    private void configureJavaCompileTask(TaskProvider<JavaCompile> javaCompile, JavaApplication pluginExtension) {
        javaCompile.configure(j -> j.getOptions().getJavaModuleMainClass().convention(pluginExtension.getMainClass()));
    }

    private void configureInstallTask(ProviderFactory providers, TaskProvider<Sync> installTask, JavaApplication pluginExtension) {
        installTask.configure(task -> task.doFirst("don't overwrite existing directories", new PreventDestinationOverwrite(providers.provider(pluginExtension::getApplicationName), providers.provider(pluginExtension::getExecutableDir))));
    }

    private JavaApplication addExtension(Project project) {
        ApplicationPluginConvention pluginConvention = project.getObjects().newInstance(DefaultApplicationPluginConvention.class, project);
        DeprecationLogger.whileDisabled(() -> pluginConvention.setApplicationName(project.getName()));
        DeprecationLogger.whileDisabled(() -> project.getConvention().getPlugins().put("application", pluginConvention));
        return project.getExtensions().create(JavaApplication.class, "application", DefaultJavaApplication.class, pluginConvention);
    }

    private void addRunTask(Project project, JvmFeatureInternal mainFeature, JavaApplication pluginExtension) {
        project.getTasks().register(TASK_RUN_NAME, JavaExec.class, run -> {
            run.setDescription("Runs this project as a JVM application");
            run.setGroup("application");
            ConfigurableFileCollection runtimeClasspath = project.files(new Object[0]).from(() -> {
                if (run.getMainModule().isPresent()) {
                    return this.jarsOnlyRuntimeClasspath(mainFeature);
                }
                return this.runtimeClasspath(mainFeature);
            });
            run.setClasspath(runtimeClasspath);
            run.getMainModule().set(pluginExtension.getMainModule());
            run.getMainClass().set(pluginExtension.getMainClass());
            run.getJvmArguments().convention(project.provider(pluginExtension::getApplicationDefaultJvmArgs));
            JavaPluginExtension javaPluginExtension = project.getExtensions().getByType(JavaPluginExtension.class);
            run.getModularity().getInferModulePath().convention(javaPluginExtension.getModularity().getInferModulePath());
            ObjectFactory objectFactory = project.getObjects();
            Provider<JavaToolchainSpec> toolchainOverrideSpec = project.provider(() -> JavaExecExecutableUtils.getExecutableOverrideToolchainSpec(run, objectFactory));
            run.getJavaLauncher().convention(this.getToolchainTool(project, JavaToolchainService::launcherFor, toolchainOverrideSpec));
        });
    }

    private <T> Provider<T> getToolchainTool(Project project, BiFunction<JavaToolchainService, JavaToolchainSpec, Provider<T>> toolMapper, Provider<JavaToolchainSpec> toolchainOverride) {
        JavaToolchainService service = project.getExtensions().getByType(JavaToolchainService.class);
        JavaPluginExtension extension = project.getExtensions().getByType(JavaPluginExtension.class);
        return toolchainOverride.orElse(extension.getToolchain()).flatMap(spec -> (Provider)toolMapper.apply(service, (JavaToolchainSpec)spec));
    }

    private void addCreateScriptsTask(Project project, JvmFeatureInternal mainFeature, JavaApplication pluginExtension) {
        project.getTasks().register(TASK_START_SCRIPTS_NAME, CreateStartScripts.class, startScripts -> {
            startScripts.setDescription("Creates OS specific scripts to run the project as a JVM application.");
            startScripts.setClasspath(this.jarsOnlyRuntimeClasspath(mainFeature));
            startScripts.getMainModule().set(pluginExtension.getMainModule());
            startScripts.getMainClass().set(pluginExtension.getMainClass());
            startScripts.getConventionMapping().map("applicationName", pluginExtension::getApplicationName);
            startScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "scripts"));
            startScripts.getConventionMapping().map("executableDir", pluginExtension::getExecutableDir);
            startScripts.getConventionMapping().map("defaultJvmOpts", pluginExtension::getApplicationDefaultJvmArgs);
            JavaPluginExtension javaPluginExtension = project.getExtensions().getByType(JavaPluginExtension.class);
            startScripts.getModularity().getInferModulePath().convention(javaPluginExtension.getModularity().getInferModulePath());
        });
    }

    private FileCollection runtimeClasspath(JvmFeatureInternal mainFeature) {
        return mainFeature.getSourceSet().getRuntimeClasspath();
    }

    private FileCollection jarsOnlyRuntimeClasspath(JvmFeatureInternal mainFeature) {
        return ((Jar)mainFeature.getJarTask().get()).getOutputs().getFiles().plus(mainFeature.getRuntimeClasspathConfiguration());
    }

    private CopySpec configureDistribution(Project project, JvmFeatureInternal mainFeature, Distribution mainDistribution, JavaApplication pluginExtension) {
        mainDistribution.getDistributionBaseName().convention(project.provider(pluginExtension::getApplicationName));
        CopySpec distSpec = mainDistribution.getContents();
        TaskProvider<Jar> jar = mainFeature.getJarTask();
        NamedDomainObjectProvider startScripts = project.getTasks().named(TASK_START_SCRIPTS_NAME);
        CopySpec libChildSpec = project.copySpec();
        libChildSpec.into("lib");
        libChildSpec.from(jar);
        libChildSpec.from(mainFeature.getRuntimeClasspathConfiguration());
        CopySpec binChildSpec = project.copySpec();
        binChildSpec.into(pluginExtension::getExecutableDir);
        binChildSpec.from(startScripts);
        binChildSpec.setFileMode(493);
        CopySpec childSpec = project.copySpec();
        childSpec.from(project.file("src/dist"));
        childSpec.with(libChildSpec);
        childSpec.with(binChildSpec);
        distSpec.with(childSpec);
        distSpec.with(pluginExtension.getApplicationDistribution());
        return distSpec;
    }

    private static class PreventDestinationOverwrite
    implements Action<Task> {
        private final Provider<String> applicationName;
        private final Provider<String> executableDir;

        private PreventDestinationOverwrite(Provider<String> applicationName, Provider<String> executableDir) {
            this.applicationName = applicationName;
            this.executableDir = executableDir;
        }

        @Override
        public void execute(Task task) {
            Sync sync = (Sync)task;
            File destinationDir = sync.getDestinationDir();
            if (destinationDir.isDirectory()) {
                String[] children = destinationDir.list();
                if (children == null) {
                    throw new UncheckedIOException("Could not list directory " + destinationDir);
                }
                if (!(children.length <= 0 || new File(destinationDir, "lib").isDirectory() && new File(destinationDir, this.executableDir.get()).isDirectory())) {
                    throw new GradleException("The specified installation directory '" + destinationDir + "' is neither empty nor does it contain an installation for '" + this.applicationName.get() + "'.\nIf you really want to install to this directory, delete it and run the install task again.\nAlternatively, choose a different installation directory.");
                }
            }
        }
    }
}

