/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.io.File;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.tasks.properties.DirectoryTreeOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.model.internal.type.ModelType;

public enum ValidationActions implements ValidationAction
{
    NO_OP("file collection"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
        }

        @Override
        public void validate(String propertyName, Supplier<Object> propertyValue, PropertyValidationContext context) {
        }
    }
    ,
    INPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File file = ValidationActions.toFile(context, value);
            if (!file.exists()) {
                ValidationActions.reportMissingInput(context, "File", propertyName, file);
            } else if (!file.isFile()) {
                ValidationActions.reportUnexpectedInputKind(context, "File", propertyName, file);
            }
        }
    }
    ,
    INPUT_DIRECTORY_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toDirectory(context, value);
            if (!directory.exists()) {
                ValidationActions.reportMissingInput(context, "Directory", propertyName, directory);
            } else if (!directory.isDirectory()) {
                ValidationActions.reportUnexpectedInputKind(context, "Directory", propertyName, directory);
            }
        }
    }
    ,
    OUTPUT_DIRECTORY_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, directory, "'" + directory + "' is not a directory");
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, candidate, "'" + directory + "' ancestor '" + candidate + "' is not a directory");
                    return;
                }
            }
        }
    }
    ,
    OUTPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            block2: {
                File file;
                block1: {
                    file = ValidationActions.toFile(context, value);
                    ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, file);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    ValidationActions.reportCannotWriteFileToDirectory(propertyName, context, file);
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotCreateParentDirectories(propertyName, context, file, candidate);
                    break;
                }
            }
        }
    }
    ,
    OUTPUT_FILE_TREE_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    ValidationActions.reportFileTreeWithFileRoot(propertyName, context, directory);
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, candidate, "'" + directory + "' ancestor '" + candidate + "' is not a directory");
                    return;
                }
            }
        }
    };

    private final String targetType;

    public static ValidationAction inputValidationActionFor(InputFilePropertyType type) {
        switch (type) {
            case FILE: {
                return INPUT_FILE_VALIDATOR;
            }
            case DIRECTORY: {
                return INPUT_DIRECTORY_VALIDATOR;
            }
            case FILES: {
                return NO_OP;
            }
        }
        throw new AssertionError((Object)("Unknown input property type " + (Object)((Object)type)));
    }

    public static ValidationAction outputValidationActionFor(OutputFilePropertySpec spec) {
        if (spec instanceof DirectoryTreeOutputFilePropertySpec) {
            return OUTPUT_FILE_TREE_VALIDATOR;
        }
        switch (spec.getOutputType()) {
            case FILE: {
                return OUTPUT_FILE_VALIDATOR;
            }
            case DIRECTORY: {
                return OUTPUT_DIRECTORY_VALIDATOR;
            }
        }
        throw new AssertionError((Object)("Unknown tree type " + spec));
    }

    private static void reportMissingInput(PropertyValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem2 -> {
            String lowerKind = kind.toLowerCase();
            ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.INPUT_FILE_DOES_NOT_EXIST)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "specifies " + lowerKind + " '" + input + "' which doesn't exist")).happensBecause("An input file was expected to be present but it doesn't exist")).addPossibleSolution(() -> "Make sure the " + lowerKind + " exists before the task is called")).addPossibleSolution(() -> "Make sure that the task which produces the " + lowerKind + " is declared as an input")).documentedAt("validation_problems", "input_file_does_not_exist");
        });
    }

    private static void reportUnexpectedInputKind(PropertyValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem2 -> {
            String lowerKind = kind.toLowerCase();
            ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.UNEXPECTED_INPUT_FILE_TYPE)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> lowerKind + " '" + input + "' is not a " + lowerKind)).happensBecause(() -> "Expected an input to be a " + lowerKind + " but it was a " + ValidationActions.actualKindOf(input))).addPossibleSolution(() -> "Use a " + lowerKind + " as an input")).addPossibleSolution(() -> "Declare the input as a " + ValidationActions.actualKindOf(input) + " instead")).documentedAt("validation_problems", "unexpected_input_file_type");
        });
    }

    private static void reportCannotWriteToDirectory(String propertyName, PropertyValidationContext context, File directory, String cause) {
        context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because " + cause)).happensBecause(() -> "Expected '" + directory + "' to be a directory but it's a " + ValidationActions.actualKindOf(directory))).addPossibleSolution("Make sure that the '" + propertyName + "' is configured to a directory")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static void reportFileTreeWithFileRoot(String propertyName, PropertyValidationContext context, File directory) {
        context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because '" + directory + "' is not a directory")).happensBecause(() -> "Expected the root of the file tree '" + directory + "' to be a directory but it's a " + ValidationActions.actualKindOf(directory))).addPossibleSolution("Make sure that the root of the file tree '" + propertyName + "' is configured to a directory")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static void reportCannotWriteFileToDirectory(String propertyName, PropertyValidationContext context, File file) {
        context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because '" + file + "' is not a file")).happensBecause(() -> "Cannot write a file to a location pointing at a directory")).addPossibleSolution(() -> "Configure '" + propertyName + "' to point to a file, not a directory")).addPossibleSolution(() -> "Annotate '" + propertyName + "' with @OutputDirectory instead of @OutputFiles")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static void reportCannotCreateParentDirectories(String propertyName, PropertyValidationContext context, File file, File ancestor) {
        context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.CANNOT_WRITE_OUTPUT)).reportAs(Severity.ERROR)).forProperty(propertyName).withDescription(() -> "is not writable because '" + file + "' ancestor '" + ancestor + "' is not a directory")).happensBecause(() -> "Cannot create parent directories that are existing as file")).addPossibleSolution(() -> "Configure '" + propertyName + "' to point to the correct location")).documentedAt("validation_problems", "cannot_write_output"));
    }

    private static String actualKindOf(File input) {
        if (input.isFile()) {
            return "file";
        }
        if (input.isDirectory()) {
            return "directory";
        }
        return "unexpected file type";
    }

    private static void validateNotInReservedFileSystemLocation(String propertyName, PropertyValidationContext context, File location) {
        if (context.isInReservedFileSystemLocation(location)) {
            context.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.CANNOT_WRITE_TO_RESERVED_LOCATION)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "points to '" + location + "' which is managed by Gradle")).happensBecause("Trying to write an output to a read-only location which is for Gradle internal use only")).addPossibleSolution("Select a different output location")).documentedAt("validation_problems", "cannot_write_to_reserved_location"));
        }
    }

    private ValidationActions(String targetType) {
        this.targetType = targetType;
    }

    protected abstract void doValidate(String var1, Object var2, PropertyValidationContext var3);

    @Override
    public void validate(String propertyName, Supplier<Object> value, PropertyValidationContext context) {
        try {
            this.doValidate(propertyName, value.get(), context);
        }
        catch (UnsupportedNotationException unsupportedNotationException) {
            ValidationActions.reportUnsupportedValue(propertyName, context, this.targetType, value.get(), unsupportedNotationException.getCandidates());
        }
    }

    private static void reportUnsupportedValue(String propertyName, PropertyValidationContext context, String targetType, Object value, Collection<String> candidates) {
        context.visitPropertyProblem(problem2 -> {
            ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.UNSUPPORTED_NOTATION)).forProperty(propertyName).reportAs(Severity.ERROR)).withDescription(() -> "has unsupported value '" + value + "'")).happensBecause(() -> "Type '" + ValidationActions.typeOf(value) + "' cannot be converted to a " + targetType);
            if (candidates.isEmpty()) {
                problem2.addPossibleSolution(() -> "Use a value of type '" + targetType + "'");
            } else {
                candidates.forEach(candidate -> problem2.addPossibleSolution(() -> ValidationActions.toCandidateSolution(candidate)));
            }
            problem2.documentedAt("validation_problems", "unsupported_notation");
        });
    }

    private static String typeOf(@Nullable Object instance) {
        if (instance == null) {
            return Object.class.getSimpleName();
        }
        if (instance instanceof GeneratedSubclass) {
            return ModelType.of(((GeneratedSubclass)instance).publicType()).getDisplayName();
        }
        return ModelType.typeOf(instance).getDisplayName();
    }

    private static String toCandidateSolution(String conversionCandidate) {
        String result2 = StringUtils.uncapitalize((String)conversionCandidate);
        if (result2.endsWith(".")) {
            result2 = result2.substring(0, result2.lastIndexOf("."));
        }
        return "Use " + result2;
    }

    private static File toDirectory(PropertyValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return ValidationActions.toFile(context, value);
    }

    private static File toFile(PropertyValidationContext context, Object value) {
        return context.getFileResolver().resolve(value);
    }
}

