/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.FilteredResultFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.PostExecutionNodeAwareActionNode;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;

public class DefaultTransformUpstreamDependenciesResolver
implements TransformUpstreamDependenciesResolver {
    public static final ArtifactTransformDependencies NO_RESULT = new ArtifactTransformDependencies(){

        @Override
        public Optional<FileCollection> getFiles() {
            return Optional.empty();
        }
    };
    public static final TransformUpstreamDependencies NO_DEPENDENCIES = new TransformUpstreamDependencies(){

        @Override
        @Nullable
        public ConfigurationIdentity getConfigurationIdentity() {
            return null;
        }

        @Override
        public FileCollection selectedArtifacts() {
            throw DefaultTransformUpstreamDependenciesResolver.failure();
        }

        @Override
        public void finalizeIfNotAlready() {
        }

        @Override
        public Try<ArtifactTransformDependencies> computeArtifacts() {
            return Try.successful(NO_RESULT);
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }
    };
    private final ComponentIdentifier componentIdentifier;
    private final ConfigurationIdentity configurationIdentity;
    private final ResolutionResultProvider<ResolutionResult> resolutionResultProvider;
    private final DomainObjectContext owner;
    private final FilteredResultFactory filteredResultFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private Set<ComponentIdentifier> buildDependencies;
    private Set<ComponentIdentifier> dependencies;

    public DefaultTransformUpstreamDependenciesResolver(ComponentIdentifier componentIdentifier, ConfigurationIdentity configurationIdentity, ResolutionResultProvider<ResolutionResult> resolutionResultProvider, DomainObjectContext owner, FilteredResultFactory filteredResultFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.componentIdentifier = componentIdentifier;
        this.configurationIdentity = configurationIdentity;
        this.resolutionResultProvider = resolutionResultProvider;
        this.owner = owner;
        this.filteredResultFactory = filteredResultFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    private static IllegalStateException failure() {
        return new IllegalStateException("Transform does not use artifact dependencies.");
    }

    @Override
    public TransformUpstreamDependencies dependenciesFor(TransformationStep transformationStep) {
        if (!transformationStep.requiresDependencies()) {
            return NO_DEPENDENCIES;
        }
        return new TransformUpstreamDependenciesImpl(this.configurationIdentity, transformationStep, this.calculatedValueContainerFactory);
    }

    private FileCollectionInternal selectedArtifactsFor(ImmutableAttributes fromAttributes) {
        if (this.dependencies == null) {
            ResolutionResult result2 = this.resolutionResultProvider.getValue();
            this.dependencies = DefaultTransformUpstreamDependenciesResolver.computeDependencies(this.componentIdentifier, ComponentIdentifier.class, result2.getAllComponents(), false);
        }
        return this.filteredResultFactory.resultsMatching(fromAttributes, this.selectDependenciesWithId(this.dependencies));
    }

    private void computeDependenciesFor(ImmutableAttributes fromAttributes, TaskDependencyResolveContext context) {
        if (this.buildDependencies == null) {
            ResolutionResult result2 = this.resolutionResultProvider.getTaskDependencyValue();
            this.buildDependencies = DefaultTransformUpstreamDependenciesResolver.computeDependencies(this.componentIdentifier, ComponentIdentifier.class, result2.getAllComponents(), true);
        }
        FileCollectionInternal files = this.filteredResultFactory.resultsMatching(fromAttributes, this.selectDependenciesWithId(this.buildDependencies));
        context.add(files);
    }

    private Spec<ComponentIdentifier> selectDependenciesWithId(Set<ComponentIdentifier> dependencies) {
        return SerializableLambdas.spec(element -> dependencies.contains(element));
    }

    private static Set<ComponentIdentifier> computeDependencies(ComponentIdentifier componentIdentifier, Class<? extends ComponentIdentifier> type, Set<ResolvedComponentResult> componentResults, boolean strict) {
        ResolvedComponentResult targetComponent = null;
        for (ResolvedComponentResult component : componentResults) {
            if (!component.getId().equals(componentIdentifier)) continue;
            targetComponent = component;
            break;
        }
        if (targetComponent == null) {
            if (strict) {
                throw new AssertionError((Object)("Could not find component " + componentIdentifier + " in provided results."));
            }
            return Collections.emptySet();
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultTransformUpstreamDependenciesResolver.collectDependenciesIdentifiers(buildDependencies, type, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    private static void collectDependenciesIdentifiers(Set<ComponentIdentifier> dependenciesIdentifiers, Class<? extends ComponentIdentifier> type, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult) || dependencyResult.isConstraint()) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            if (type.isInstance(selected.getId())) {
                dependenciesIdentifiers.add(selected.getId());
            }
            if (!visited.add(selected.getId())) continue;
            DefaultTransformUpstreamDependenciesResolver.collectDependenciesIdentifiers(dependenciesIdentifiers, type, visited, selected.getDependencies());
        }
    }

    private class TransformUpstreamDependenciesImpl
    implements TransformUpstreamDependencies {
        private final ConfigurationIdentity configurationIdentity;
        private final CalculatedValueContainer<ArtifactTransformDependencies, FinalizeTransformDependencies> transformDependencies;
        private final ImmutableAttributes fromAttributes;

        public TransformUpstreamDependenciesImpl(ConfigurationIdentity configurationIdentity, TransformationStep transformationStep, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.configurationIdentity = configurationIdentity;
            this.fromAttributes = transformationStep.getFromAttributes();
            this.transformDependencies = calculatedValueContainerFactory.create(Describables.of("dependencies for", DefaultTransformUpstreamDependenciesResolver.this.componentIdentifier, this.fromAttributes), new FinalizeTransformDependenciesFromSelectedArtifacts(transformationStep.getFromAttributes()));
        }

        @Override
        public ConfigurationIdentity getConfigurationIdentity() {
            return this.configurationIdentity;
        }

        @Override
        public FileCollection selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.fromAttributes);
        }

        @Override
        public Try<ArtifactTransformDependencies> computeArtifacts() {
            return this.transformDependencies.getValue();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.transformDependencies);
        }

        @Override
        public void finalizeIfNotAlready() {
            this.transformDependencies.finalizeIfNotAlready();
        }
    }

    private static class CollectingTaskDependencyResolveContext
    implements TaskDependencyResolveContext {
        private final TaskNodeFactory taskNodeFactory;
        private final Collection<TaskNode> tasks;

        public CollectingTaskDependencyResolveContext(Collection<TaskNode> tasks, TaskNodeFactory taskNodeFactory) {
            this.tasks = tasks;
            this.taskNodeFactory = taskNodeFactory;
        }

        @Override
        public void add(Object dependency) {
            if (dependency instanceof Task) {
                this.tasks.add(this.taskNodeFactory.getNode((Task)dependency));
            }
        }

        @Override
        public void visitFailure(Throwable failure) {
        }

        @Override
        @Nullable
        public Task getTask() {
            return null;
        }
    }

    public class FinalizeTransformDependenciesFromSelectedArtifacts
    extends FinalizeTransformDependencies {
        private final ImmutableAttributes fromAttributes;

        public FinalizeTransformDependenciesFromSelectedArtifacts(ImmutableAttributes fromAttributes) {
            this.fromAttributes = fromAttributes;
        }

        @Override
        public FileCollectionInternal selectedArtifacts() {
            return DefaultTransformUpstreamDependenciesResolver.this.selectedArtifactsFor(this.fromAttributes);
        }

        @Override
        public boolean usesMutableProjectState() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject() != null;
        }

        @Override
        public ProjectInternal getOwningProject() {
            return DefaultTransformUpstreamDependenciesResolver.this.owner.getProject();
        }

        @Override
        @Nullable
        public WorkNodeAction getPreExecutionAction() {
            return new CalculateFinalDependencies();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            DefaultTransformUpstreamDependenciesResolver.this.computeDependenciesFor(this.fromAttributes, context);
        }

        public class CalculateFinalDependencies
        implements PostExecutionNodeAwareActionNode {
            final List<TaskNode> tasks = new ArrayList<TaskNode>();

            @Override
            public boolean usesMutableProjectState() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.usesMutableProjectState();
            }

            @Override
            @Nullable
            public Project getOwningProject() {
                return FinalizeTransformDependenciesFromSelectedArtifacts.this.getOwningProject();
            }

            @Override
            public void run(NodeExecutionContext context) {
                TaskNodeFactory taskNodeFactory = context.getService(TaskNodeFactory.class);
                FinalizeTransformDependenciesFromSelectedArtifacts.this.selectedArtifacts().visitDependencies(new CollectingTaskDependencyResolveContext(this.tasks, taskNodeFactory));
            }

            public List<TaskNode> getPostExecutionNodes() {
                return this.tasks;
            }
        }
    }

    public static abstract class FinalizeTransformDependencies
    implements ValueCalculator<ArtifactTransformDependencies> {
        public abstract FileCollection selectedArtifacts();

        @Override
        public ArtifactTransformDependencies calculateValue(NodeExecutionContext context) {
            FileCollection files = this.selectedArtifacts();
            files.getFiles();
            return new DefaultArtifactTransformDependencies(files);
        }
    }
}

