/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.util.Path;

public class DefaultBuildIdentifier
implements BuildIdentifier {
    public static final BuildIdentifier ROOT = new DefaultBuildIdentifier(Path.ROOT);
    private final Path buildPath;

    public DefaultBuildIdentifier(Path buildPath) {
        if (!buildPath.isAbsolute()) {
            throw new IllegalArgumentException("Build path must be absolute: " + buildPath);
        }
        this.buildPath = buildPath;
    }

    @Override
    public String getBuildPath() {
        return this.buildPath.toString();
    }

    @Override
    public String getName() {
        return this.buildPath.getName() == null ? ":" : this.buildPath.getName();
    }

    @Override
    public boolean isCurrentBuild() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultBuildIdentifier)) {
            return false;
        }
        DefaultBuildIdentifier that = (DefaultBuildIdentifier)o;
        return this.buildPath.equals(that.buildPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildPath});
    }

    public String toString() {
        return "build '" + this.buildPath + "'";
    }
}

