/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.Arrays;
import org.rrd4j.core.Util;

class Normalizer {
    private final long[] timestamps;
    final int count;
    final long step;

    Normalizer(long[] timestamps) {
        this.timestamps = timestamps;
        this.step = timestamps[1] - timestamps[0];
        this.count = timestamps.length;
    }

    double[] normalize(long[] rawTimestamps, double[] rawValues) {
        int rawCount = rawTimestamps.length;
        long rawStep = rawTimestamps[1] - rawTimestamps[0];
        if (rawCount == this.count && rawStep == this.step && rawTimestamps[0] == this.timestamps[0]) {
            return Normalizer.getCopyOf(rawValues);
        }
        double[] values = new double[this.count];
        Arrays.fill(values, Double.NaN);
        double[] weights = new double[this.count];
        Arrays.fill(weights, Double.NaN);
        int seg = 0;
        for (int rawSeg = 0; rawSeg < rawCount && seg < this.count; ++rawSeg) {
            double rawValue = rawValues[rawSeg];
            if (Double.isNaN(rawValue)) continue;
            long rawLeft = rawTimestamps[rawSeg] - rawStep;
            while (seg < this.count && rawLeft >= this.timestamps[seg]) {
                ++seg;
            }
            boolean overlap = true;
            for (int fillSeg = seg; overlap && fillSeg < this.count; ++fillSeg) {
                long t2;
                long left = this.timestamps[fillSeg] - this.step;
                long t1 = Math.max(rawLeft, left);
                if (t1 < (t2 = Math.min(rawTimestamps[rawSeg], this.timestamps[fillSeg]))) {
                    values[fillSeg] = Util.sum(values[fillSeg], (double)(t2 - t1) * rawValues[rawSeg]);
                    weights[fillSeg] = Util.sum(weights[fillSeg], t2 - t1);
                    continue;
                }
                overlap = false;
            }
        }
        for (int seg2 = 0; seg2 < this.count; ++seg2) {
            if (Double.isNaN(weights[seg2])) continue;
            int n = seg2;
            values[n] = values[n] / weights[seg2];
        }
        return values;
    }

    private static double[] getCopyOf(double[] rawValues) {
        int n = rawValues.length;
        double[] values = new double[n];
        System.arraycopy(rawValues, 0, values, 0, n);
        return values;
    }
}

