<?php
/**
 * intranet Plugin
 * Plugin which will enable desktop notifications for new mails.
 */
class Pluginintranet extends Plugin {
	/**
	 * Function initializes the Plugin and registers all hooks.
	 */
	public function init() {
		$this->registerHook('server.core.settings.init.before');
	}

	/**
	 * Function is executed when a hook is triggered by the PluginManager.
	 *
	 * @param string $eventID the id of the triggered hook
	 * @param mixed  $data    object(s) related to the hook
	 */
	public function execute($eventID, &$data) {
		switch ($eventID) {
			case 'server.core.settings.init.before':
				$this->injectPluginSettings($data);
				break;
		}
	}

	/**
	 * Called when the core Settings class is initialized and ready to accept sysadmin default
	 * settings. Registers the sysadmin defaults for the desktopnotifications plugin.
	 *
	 * @param array $data Reference to the data of the triggered hook
	 */
	public function injectPluginSettings(&$data) {
		$defaultIcon = 'data:image/svg+xml;base64,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';
		$pluginData = [
			'enable' => PLUGIN_INTRANET_USER_DEFAULT_ENABLE,
			'button-title' => PLUGIN_INTRANET_BUTTON_TITLE,
			'url' => PLUGIN_INTRANET_URL,
			'autostart' => defined('PLUGIN_INTRANET_AUTOSTART') ? (bool) PLUGIN_INTRANET_AUTOSTART : false,
			'icon' => defined('PLUGIN_INTRANET_ICON') ? PATH_PLUGIN_DIR . '/intranet/' . PLUGIN_INTRANET_ICON : $defaultIcon,
		];

		$i = 1;
		while (defined('PLUGIN_INTRANET_URL_' . $i)) {
			$pluginData['button-title-' . $i] = constant('PLUGIN_INTRANET_BUTTON_TITLE_' . $i);
			$pluginData['url-' . $i] = constant('PLUGIN_INTRANET_URL_' . $i);
			$pluginData['autostart-' . $i] = defined('PLUGIN_INTRANET_AUTOSTART_' . $i) ? (bool) constant('PLUGIN_INTRANET_AUTOSTART_' . $i) : false;
			$pluginData['icon-' . $i] = defined('PLUGIN_INTRANET_ICON_' . $i) ? PATH_PLUGIN_DIR . '/intranet/' . constant('PLUGIN_INTRANET_ICON_' . $i) : $defaultIcon;
			++$i;
		}

		$data['settingsObj']->addSysAdminDefaults([
			'zarafa' => [
				'v1' => [
					'plugins' => [
						'intranet' => $pluginData,
					],
				],
			],
		]);
	}
}
